<?php

/**
 * @package   Astroid Framework
 * @author    Astroid Framework Team https://astroidframe.work
 * @copyright Copyright (C) 2023 AstroidFrame.work.
 * @license https://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
 * DO NOT MODIFY THIS FILE DIRECTLY AS IT WILL BE OVERWRITTEN IN THE NEXT UPDATE
 * You can easily override all files under /astroid/ folder.
 * Just copy the file to JROOT/media/templates/site/YOUR_ASTROID_TEMPLATE/astroid/elements/module_position/module_position.php folder to create and override
 */

// No direct access.
defined('_JEXEC') or die;

use Astroid\Helper\Style;
use Astroid\Helper\SubForm;

extract($displayData);
$icons     = new SubForm($params->get('icons', ''));
if (!count($icons->data)) {
    return false;
}
$icon_size      = $params->get('icon_size', '18');
$icon_gutter    = $params->get('icon_gutter', '3');
$color          = Style::getColor($params->get('color', ''));
$color_hover    = Style::getColor($params->get('color_hover', ''));

// Alignment
$text_alignment             =   $params->get('text_alignment','');
$text_alignment_breakpoint  =   $params->get('text_alignment_breakpoint','');
$text_alignment_fallback    =   $params->get('text_alignment_fallback','');
if ($text_alignment) {
    $alignment              =   ' justify-content' . ($text_alignment_breakpoint ? '-' . $text_alignment_breakpoint : '') . '-' . $text_alignment . ($text_alignment_fallback ? ' justify-content-' . $text_alignment_fallback : '');
} else {
    $alignment              =   '';
}
echo '<div class="row row-cols-auto g-'.$icon_gutter.$alignment.'">';
foreach ($icons->data as $icon) {
    $icon_params    =   Style::getSubFormParams($icon->params);
    $target         =   $icon->params->get('target', '') ? ' target="'.$icon->params->get('target', '').'"' : '';
    echo '<div class="astroid-icon-item">';
    echo '<a id="btn-'.$icon->id.'" href="' .$icon->params->get('link', ''). '" title="'.$icon->params->get('title', '').'"' . $target . '><i class="'.$icon->params->get('icon', '').'"></i></a>';
    echo '</div>';
}
echo '</div>';

// Set styles for widget
$style = $element->style;
$style_dark = $element->style_dark;
$style->child('.astroid-icon-item')->addCss('font-size', $icon_size.'px');
$style->child('.astroid-icon-item > a')->addCss('color', $color['light']);
$style_dark->child('.astroid-icon-item > a')->addCss('color', $color['dark']);
$style->child('.astroid-icon-item > a')->hover()->addCss('color', $color_hover['light']);
$style_dark->child('.astroid-icon-item > a')->hover()->addCss('color', $color_hover['dark']);