/**ABDB**/CREATE TABLE `#__associations` (
  `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`context`,`id`),
  KEY `idx_key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0,
  `lft` int(11) NOT NULL DEFAULT 0,
  `rgt` int(11) NOT NULL DEFAULT 0,
  `level` int(10) unsigned NOT NULL DEFAULT 0,
  `path` varchar(400) NOT NULL DEFAULT '',
  `extension` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext DEFAULT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `params` text DEFAULT NULL,
  `metadesc` varchar(1024) NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) NOT NULL DEFAULT '' COMMENT 'The keywords for the page.',
  `metadata` varchar(2048) NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL,
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL DEFAULT '',
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__categories`  VALUES 
('1', '0', '0', '0', '13', '0', '', 'system', 'ROOT', 'root', '', '', '1', NULL, NULL, '1', '{}', '', '', '{}', '123', '2024-03-28 05:46:45', '123', '2024-03-28 05:46:45', '0', '*', '1'),
('2', '27', '1', '1', '2', '1', 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"workflow_id\":\"use_default\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '123', '2024-03-28 05:46:45', '123', '2024-03-28 05:46:45', '0', '*', '1'),
('3', '28', '1', '3', '4', '1', 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '123', '2024-03-28 05:46:45', '123', '2024-03-28 05:46:45', '0', '*', '1'),
('4', '29', '1', '5', '6', '1', 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '123', '2024-03-28 05:46:45', '123', '2024-03-28 05:46:45', '0', '*', '1'),
('5', '30', '1', '7', '8', '1', 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '123', '2024-03-28 05:46:45', '123', '2024-03-28 05:46:45', '0', '*', '1'),
('7', '32', '1', '9', '10', '1', 'uncategorised', 'com_users', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '123', '2024-03-28 05:46:45', '123', '2024-03-28 05:46:45', '0', '*', '1'),
('8', '148', '1', '11', '12', '1', 'tours', 'com_content', 'Tours', 'tours', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\",\"astroid_authorinfo\":\"\",\"astroid_relatedposts\":\"\",\"article_relatedposts_count\":\"\",\"article_relatedposts_count_custom\":\"4\",\"article_relatedposts_posttype\":\"\",\"article_relatedposts_badge\":\"\",\"astroid_readtime\":\"\",\"astroid_socialshare\":\"\",\"astroid_comments\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '123', '2024-04-12 03:06:56', '123', '2024-04-12 03:06:56', '0', '*', '1');
/**ABDB**/CREATE TABLE `#__finder_links_terms` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__content_types` (
  `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) NOT NULL DEFAULT '',
  `type_alias` varchar(400) NOT NULL DEFAULT '',
  `table` varchar(2048) NOT NULL DEFAULT '',
  `rules` text NOT NULL,
  `field_mappings` text NOT NULL,
  `router` varchar(255) NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) DEFAULT NULL COMMENT 'JSON string for com_contenthistory options',
  PRIMARY KEY (`type_id`),
  KEY `idx_alias` (`type_alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=10000 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__content_types`  VALUES 
('1', 'Article', 'com_content.article', '{\"special\":{\"dbtable\":\"#__content\",\"key\":\"id\",\"type\":\"ArticleTable\",\"prefix\":\"Joomla\\\\Component\\\\Content\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"introtext\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"attribs\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"asset_id\":\"asset_id\", \"note\":\"note\"}, \"special\":{\"fulltext\":\"fulltext\"}}', 'ContentHelperRoute::getArticleRoute', '{\"formFile\":\"administrator\\/components\\/com_content\\/forms\\/article.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
('2', 'Contact', 'com_contact.contact', '{\"special\":{\"dbtable\":\"#__contact_details\",\"key\":\"id\",\"type\":\"ContactTable\",\"prefix\":\"Joomla\\\\Component\\\\Contact\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"address\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"image\", \"core_urls\":\"webpage\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"asset_id\":\"null\"}, \"special\":{\"con_position\":\"con_position\",\"suburb\":\"suburb\",\"state\":\"state\",\"country\":\"country\",\"postcode\":\"postcode\",\"telephone\":\"telephone\",\"fax\":\"fax\",\"misc\":\"misc\",\"email_to\":\"email_to\",\"default_con\":\"default_con\",\"user_id\":\"user_id\",\"mobile\":\"mobile\",\"sortname1\":\"sortname1\",\"sortname2\":\"sortname2\",\"sortname3\":\"sortname3\"}}', 'ContactHelperRoute::getContactRoute', '{\"formFile\":\"administrator\\/components\\/com_contact\\/forms\\/contact.xml\",\"hideFields\":[\"default_con\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[ {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ] }'),
('3', 'Newsfeed', 'com_newsfeeds.newsfeed', '{\"special\":{\"dbtable\":\"#__newsfeeds\",\"key\":\"id\",\"type\":\"NewsfeedTable\",\"prefix\":\"Joomla\\\\Component\\\\Newsfeeds\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"asset_id\":\"null\"}, \"special\":{\"numarticles\":\"numarticles\",\"cache_time\":\"cache_time\",\"rtl\":\"rtl\"}}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{\"formFile\":\"administrator\\/components\\/com_newsfeeds\\/forms\\/newsfeed.xml\",\"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
('4', 'User', 'com_users.user', '{\"special\":{\"dbtable\":\"#__users\",\"key\":\"id\",\"type\":\"User\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"null\",\"core_alias\":\"username\",\"core_created_time\":\"registerDate\",\"core_modified_time\":\"lastvisitDate\",\"core_body\":\"null\", \"core_hits\":\"null\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"access\":\"null\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"null\", \"core_language\":\"null\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"null\", \"core_ordering\":\"null\", \"core_metakey\":\"null\", \"core_metadesc\":\"null\", \"core_catid\":\"null\", \"asset_id\":\"null\"}, \"special\":{}}', '', ''),
('5', 'Article Category', 'com_content.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"CategoryTable\",\"prefix\":\"Joomla\\\\Component\\\\Categories\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContentHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
('6', 'Contact Category', 'com_contact.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"CategoryTable\",\"prefix\":\"Joomla\\\\Component\\\\Categories\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContactHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
('7', 'Newsfeeds Category', 'com_newsfeeds.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"CategoryTable\",\"prefix\":\"Joomla\\\\Component\\\\Categories\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'NewsfeedsHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
('8', 'Tag', 'com_tags.tag', '{\"special\":{\"dbtable\":\"#__tags\",\"key\":\"tag_id\",\"type\":\"TagTable\",\"prefix\":\"Joomla\\\\Component\\\\Tags\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\"}}', 'TagsHelperRoute::getTagRoute', '{\"formFile\":\"administrator\\/components\\/com_tags\\/forms\\/tag.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"lft\", \"rgt\", \"level\", \"path\", \"urls\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
('9', 'Banner', 'com_banners.banner', '{\"special\":{\"dbtable\":\"#__banners\",\"key\":\"id\",\"type\":\"BannerTable\",\"prefix\":\"Joomla\\\\Component\\\\Banners\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"null\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"asset_id\":\"null\"}, \"special\":{\"imptotal\":\"imptotal\", \"impmade\":\"impmade\", \"clicks\":\"clicks\", \"clickurl\":\"clickurl\", \"custombannercode\":\"custombannercode\", \"cid\":\"cid\", \"purchase_type\":\"purchase_type\", \"track_impressions\":\"track_impressions\", \"track_clicks\":\"track_clicks\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/forms\\/banner.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"reset\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"imptotal\", \"impmade\", \"reset\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"cid\",\"targetTable\":\"#__banner_clients\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
('10', 'Banners Category', 'com_banners.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"CategoryTable\",\"prefix\":\"Joomla\\\\Component\\\\Categories\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
('11', 'Banner Client', 'com_banners.client', '{\"special\":{\"dbtable\":\"#__banner_clients\",\"key\":\"id\",\"type\":\"ClientTable\",\"prefix\":\"Joomla\\\\Component\\\\Banners\\\\Administrator\\\\Table\\\\\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/forms\\/client.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\"], \"ignoreChanges\":[\"checked_out\", \"checked_out_time\"], \"convertToInt\":[], \"displayLookup\":[]}'),
('12', 'User Notes', 'com_users.note', '{\"special\":{\"dbtable\":\"#__user_notes\",\"key\":\"id\",\"type\":\"NoteTable\",\"prefix\":\"Joomla\\\\Component\\\\Users\\\\Administrator\\\\Table\\\\\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_users\\/forms\\/note.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\"], \"convertToInt\":[\"publish_up\", \"publish_down\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
('13', 'User Notes Category', 'com_users.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"CategoryTable\",\"prefix\":\"Joomla\\\\Component\\\\Categories\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/forms\\/category.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}');
/**ABDB**/CREATE TABLE `#__messages_cfg` (
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `cfg_name` varchar(100) NOT NULL DEFAULT '',
  `cfg_value` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `idx_user_var_name` (`user_id`,`cfg_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__guidedtour_steps` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tour_id` int(11) NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `description` text NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `position` varchar(255) NOT NULL,
  `target` varchar(255) NOT NULL,
  `type` int(11) NOT NULL,
  `interactive_type` int(11) NOT NULL DEFAULT 1,
  `url` varchar(255) NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `language` varchar(7) NOT NULL,
  `note` varchar(255) NOT NULL DEFAULT '',
  `params` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_tour` (`tour_id`),
  KEY `idx_state` (`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=120 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__guidedtour_steps`  VALUES 
('1', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_NEW_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_NEW_DESCRIPTION', '1', 'bottom', '.button-new', '2', '1', 'administrator/index.php?option=com_guidedtours&view=tours', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('2', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_TITLE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_TITLE_DESCRIPTION', '2', 'bottom', '#jform_title', '2', '2', 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('3', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_URL_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_URL_DESCRIPTION', '3', 'top', '#jform_url', '2', '2', 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('4', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_CONTENT_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_CONTENT_DESCRIPTION', '4', 'bottom', '#jform_description,#jform_description_ifr', '2', '3', 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('5', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_COMPONENT_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_COMPONENT_DESCRIPTION', '5', 'top', 'joomla-field-fancy-select .choices', '2', '3', 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('6', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_SAVECLOSE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_SAVECLOSE_DESCRIPTION', '7', 'top', '#save-group-children-save .button-save', '2', '1', 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('7', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_CONGRATULATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_CONGRATULATIONS_DESCRIPTION', '8', 'bottom', '', '0', '1', 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('8', '2', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_COUNTER_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_COUNTER_DESCRIPTION', '8', 'top', '#toursList tbody tr:nth-last-of-type(1) td:nth-of-type(5) .btn', '2', '1', '', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('9', '2', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_NEW_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_NEW_DESCRIPTION', '9', 'bottom', '.button-new', '2', '1', '', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('10', '2', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TITLE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TITLE_DESCRIPTION', '10', 'bottom', '#jform_title', '2', '2', '', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('11', '2', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_DESCRIPTION_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_DESCRIPTION_DESCRIPTION', '11', 'bottom', '#jform_description,#jform_description_ifr', '2', '3', '', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('12', '2', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_STATUS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_STATUS_DESCRIPTION', '12', 'bottom', '#jform_published', '2', '3', '', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('13', '2', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_POSITION_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_POSITION_DESCRIPTION', '13', 'top', '#jform_position', '2', '3', '', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('14', '2', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TARGET_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TARGET_DESCRIPTION', '14', 'top', '#jform_target', '2', '3', '', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('15', '2', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TYPE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TYPE_DESCRIPTION', '15', 'top', '#jform_type', '2', '3', '', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('16', '2', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_SAVECLOSE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_SAVECLOSE_DESCRIPTION', '16', 'bottom', '#save-group-children-save .button-save', '2', '1', '', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('17', '2', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_CONGRATULATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_CONGRATULATIONS_DESCRIPTION', '17', 'bottom', '', '0', '1', '', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('18', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_NEW_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_NEW_DESCRIPTION', '18', 'bottom', '.button-new', '2', '1', 'administrator/index.php?option=com_content&view=articles', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('19', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_TITLE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_TITLE_DESCRIPTION', '19', 'bottom', '#jform_title', '2', '2', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('20', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_ALIAS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_ALIAS_DESCRIPTION', '20', 'bottom', '#jform_alias', '2', '2', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('21', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CONTENT_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CONTENT_DESCRIPTION', '21', 'bottom', '#jform_articletext,#jform_articletext_ifr', '2', '3', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('22', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_STATUS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_STATUS_DESCRIPTION', '22', 'bottom', '#jform_state', '2', '3', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('23', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CATEGORY_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CATEGORY_DESCRIPTION', '23', 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', '2', '3', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('24', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_FEATURED_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_FEATURED_DESCRIPTION', '24', 'bottom', '#jform_featured0', '2', '3', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('25', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_ACCESS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_ACCESS_DESCRIPTION', '25', 'bottom', '#jform_access', '2', '3', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('26', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_TAGS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_TAGS_DESCRIPTION', '26', 'top', 'joomla-field-fancy-select .choices[data-type=select-multiple]', '2', '3', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('27', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_NOTE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_NOTE_DESCRIPTION', '27', 'top', '#jform_note', '2', '2', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('28', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_VERSIONNOTE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_VERSIONNOTE_DESCRIPTION', '28', 'top', '#jform_version_note', '2', '2', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('29', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_SAVECLOSE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_SAVECLOSE_DESCRIPTION', '29', 'bottom', '#save-group-children-save .button-save', '2', '1', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('30', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CONGRATULATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CONGRATULATIONS_DESCRIPTION', '30', 'bottom', '', '0', '1', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('31', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_NEW_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_NEW_DESCRIPTION', '31', 'bottom', '.button-new', '2', '1', 'administrator/index.php?option=com_categories&view=categories&extension=com_content', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('32', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_TITLE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_TITLE_DESCRIPTION', '32', 'bottom', '#jform_title', '2', '2', 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('33', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_ALIAS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_ALIAS_DESCRIPTION', '33', 'bottom', '#jform_alias', '2', '2', 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('34', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_CONTENT_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_CONTENT_DESCRIPTION', '34', 'bottom', '#jform_description,#jform_description_ifr', '2', '3', 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('35', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_PARENT_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_PARENT_DESCRIPTION', '35', 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', '2', '3', 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('36', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_STATUS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_STATUS_DESCRIPTION', '36', 'bottom', '#jform_published', '2', '3', 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('37', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_ACCESS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_ACCESS_DESCRIPTION', '37', 'bottom', '#jform_access', '2', '3', 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('38', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_TAGS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_TAGS_DESCRIPTION', '38', 'top', 'joomla-field-fancy-select .choices[data-type=select-multiple]', '2', '3', 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('39', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_NOTE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_NOTE_DESCRIPTION', '39', 'top', '#jform_note', '2', '2', 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('40', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_VERSIONNOTE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_VERSIONNOTE_DESCRIPTION', '40', 'top', '#jform_version_note', '2', '2', 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('41', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_SAVECLOSE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_SAVECLOSE_DESCRIPTION', '41', 'bottom', '#save-group-children-save .button-save', '2', '1', 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('42', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_CONGRATULATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_CONGRATULATIONS_DESCRIPTION', '42', 'bottom', '', '0', '1', 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('43', '5', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_NEW_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_NEW_DESCRIPTION', '43', 'bottom', '.button-new', '2', '1', 'administrator/index.php?option=com_menus&view=menus', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('44', '5', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_TITLE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_TITLE_DESCRIPTION', '44', 'bottom', '#jform_title', '2', '2', 'administrator/index.php?option=com_menus&view=menu&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('45', '5', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_UNIQUENAME_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_UNIQUENAME_DESCRIPTION', '45', 'top', '#jform_menutype', '2', '2', 'administrator/index.php?option=com_menus&view=menu&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('46', '5', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_DESCRIPTION_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_DESCRIPTION_DESCRIPTION', '46', 'top', '#jform_menudescription', '2', '2', 'administrator/index.php?option=com_menus&view=menu&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('47', '5', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_SAVECLOSE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_SAVECLOSE_DESCRIPTION', '47', 'bottom', '#save-group-children-save .button-save', '2', '1', 'administrator/index.php?option=com_menus&view=menu&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('48', '5', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_CONGRATULATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_CONGRATULATIONS_DESCRIPTION', '48', 'bottom', '', '0', '1', 'administrator/index.php?option=com_menus&view=menu&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('49', '6', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_NEW_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_NEW_DESCRIPTION', '49', 'bottom', '.button-new', '2', '1', 'administrator/index.php?option=com_tags&view=tags', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('50', '6', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_TITLE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_TITLE_DESCRIPTION', '50', 'bottom', '#jform_title', '2', '2', 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('51', '6', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_ALIAS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_ALIAS_DESCRIPTION', '51', 'bottom', '#jform_alias', '2', '2', 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('52', '6', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_CONTENT_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_CONTENT_DESCRIPTION', '52', 'bottom', '#jform_description,#jform_description_ifr', '2', '3', 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('53', '6', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_PARENT_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_PARENT_DESCRIPTION', '53', 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', '2', '3', 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('54', '6', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_STATUS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_STATUS_DESCRIPTION', '54', 'bottom', '#jform_published', '2', '3', 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('55', '6', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_ACCESS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_ACCESS_DESCRIPTION', '55', 'bottom', '#jform_access', '2', '3', 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('56', '6', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_NOTE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_NOTE_DESCRIPTION', '56', 'top', '#jform_note', '2', '2', 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('57', '6', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_VERSIONNOTE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_VERSIONNOTE_DESCRIPTION', '57', 'top', '#jform_version_note', '2', '2', 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('58', '6', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_SAVECLOSE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_SAVECLOSE_DESCRIPTION', '58', 'bottom', '#save-group-children-save .button-save', '2', '1', 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('59', '6', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_CONGRATULATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_CONGRATULATIONS_DESCRIPTION', '59', 'bottom', '', '0', '1', 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('60', '7', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_NEW_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_NEW_DESCRIPTION', '60', 'bottom', '.button-new', '2', '1', 'administrator/index.php?option=com_banners&view=banners', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('61', '7', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_TITLE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_TITLE_DESCRIPTION', '61', 'bottom', '#jform_name', '2', '2', 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('62', '7', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_ALIAS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_ALIAS_DESCRIPTION', '62', 'bottom', '#jform_alias', '2', '2', 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('63', '7', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_DETAILS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_DETAILS_DESCRIPTION', '63', 'bottom', '.col-lg-9', '2', '3', 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('64', '7', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_STATUS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_STATUS_DESCRIPTION', '64', 'bottom', '#jform_state', '2', '3', 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('65', '7', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_CATEGORY_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_CATEGORY_DESCRIPTION', '65', 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', '2', '3', 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('66', '7', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_PINNED_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_PINNED_DESCRIPTION', '66', 'bottom', '#jform_sticky1', '2', '3', 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('67', '7', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_VERSIONNOTE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_VERSIONNOTE_DESCRIPTION', '67', 'top', '#jform_version_note', '2', '2', 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('68', '7', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_SAVECLOSE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_SAVECLOSE_DESCRIPTION', '68', 'bottom', '#save-group-children-save .button-save', '2', '1', 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('69', '7', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_CONGRATULATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_CONGRATULATIONS_DESCRIPTION', '69', 'bottom', '', '0', '1', 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('70', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_NEW_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_NEW_DESCRIPTION', '70', 'bottom', '.button-new', '2', '1', 'administrator/index.php?option=com_contact&view=contacts', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('71', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_TITLE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_TITLE_DESCRIPTION', '71', 'bottom', '#jform_name', '2', '2', 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('72', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_ALIAS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_ALIAS_DESCRIPTION', '72', 'bottom', '#jform_alias', '2', '2', 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('73', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_DETAILS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_DETAILS_DESCRIPTION', '73', 'bottom', '.col-lg-9', '0', '1', 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('74', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_STATUS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_STATUS_DESCRIPTION', '74', 'bottom', '#jform_published', '2', '3', 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('75', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_CATEGORY_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_CATEGORY_DESCRIPTION', '75', 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', '2', '3', 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('76', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_FEATURED_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_FEATURED_DESCRIPTION', '76', 'bottom', '#jform_featured0', '2', '3', 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('77', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_ACCESS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_ACCESS_DESCRIPTION', '77', 'bottom', '#jform_access', '2', '3', 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('78', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_TAGS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_TAGS_DESCRIPTION', '78', 'top', 'joomla-field-fancy-select .choices[data-type=select-multiple]', '2', '3', 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('79', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_VERSIONNOTE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_VERSIONNOTE_DESCRIPTION', '79', 'top', '#jform_version_note', '2', '2', 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('80', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_SAVECLOSE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_SAVECLOSE_DESCRIPTION', '80', 'bottom', '#save-group-children-save .button-save', '2', '1', 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('81', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_CONGRATULATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_CONGRATULATIONS_DESCRIPTION', '81', 'bottom', '', '0', '1', 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('82', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_NEW_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_NEW_DESCRIPTION', '82', 'bottom', '.button-new', '2', '1', 'administrator/index.php?option=com_newsfeeds&view=newsfeeds', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('83', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_TITLE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_TITLE_DESCRIPTION', '83', 'bottom', '#jform_name', '2', '2', 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('84', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_ALIAS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_ALIAS_DESCRIPTION', '84', 'bottom', '#jform_alias', '2', '2', 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('85', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_LINK_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_LINK_DESCRIPTION', '85', 'bottom', '#jform_link', '2', '2', 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('86', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_DESCRIPTION_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_DESCRIPTION_DESCRIPTION', '86', 'bottom', '#jform_description,#jform_description_ifr', '2', '3', 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('87', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_STATUS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_STATUS_DESCRIPTION', '87', 'bottom', '#jform_published', '2', '3', 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('88', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_CATEGORY_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_CATEGORY_DESCRIPTION', '88', 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', '2', '3', 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('89', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_ACCESS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_ACCESS_DESCRIPTION', '89', 'bottom', '#jform_access', '2', '3', 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('90', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_TAGS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_TAGS_DESCRIPTION', '90', 'top', 'joomla-field-fancy-select .choices[data-type=select-multiple]', '2', '3', 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('91', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_VERSIONNOTE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_VERSIONNOTE_DESCRIPTION', '91', 'top', '#jform_version_note', '2', '2', 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('92', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_SAVECLOSE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_SAVECLOSE_DESCRIPTION', '92', 'bottom', '#save-group-children-save .button-save', '2', '1', 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('93', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_CONGRATULATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_CONGRATULATIONS_DESCRIPTION', '93', 'bottom', '', '0', '1', 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('94', '10', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_NEW_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_NEW_DESCRIPTION', '94', 'bottom', '.button-new', '2', '1', 'administrator/index.php?option=com_finder&view=filters', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('95', '10', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_TITLE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_TITLE_DESCRIPTION', '95', 'bottom', '#jform_title', '2', '2', 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('96', '10', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_ALIAS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_ALIAS_DESCRIPTION', '96', 'bottom', '#jform_alias', '2', '2', 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('97', '10', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_CONTENT_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_CONTENT_DESCRIPTION', '97', 'bottom', '.col-lg-9', '0', '1', 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('98', '10', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_STATUS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_STATUS_DESCRIPTION', '98', 'bottom', '#jform_state', '2', '3', 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('99', '10', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_SAVECLOSE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_SAVECLOSE_DESCRIPTION', '99', 'bottom', '#save-group-children-save .button-save', '2', '1', 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('100', '10', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_CONGRATULATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_CONGRATULATIONS_DESCRIPTION', '100', 'bottom', '', '0', '1', 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('101', '11', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_NEW_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_NEW_DESCRIPTION', '101', 'bottom', '.button-new', '2', '1', 'administrator/index.php?option=com_users&view=user&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('102', '11', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_NAME_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_NAME_DESCRIPTION', '102', 'bottom', '#jform_name', '2', '2', 'administrator/index.php?option=com_users&view=user&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('103', '11', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_LOGINNAME_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_LOGINNAME_DESCRIPTION', '103', 'bottom', '#jform_username', '2', '2', 'administrator/index.php?option=com_users&view=user&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('104', '11', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORD_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORD_DESCRIPTION', '104', 'bottom', '#jform_password', '2', '2', 'administrator/index.php?option=com_users&view=user&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('105', '11', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORD2_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORD2_DESCRIPTION', '105', 'bottom', '#jform_password2', '2', '2', 'administrator/index.php?option=com_users&view=user&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('106', '11', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_EMAIL_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_EMAIL_DESCRIPTION', '106', 'bottom', '#jform_email', '2', '2', 'administrator/index.php?option=com_users&view=user&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('107', '11', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_SYSTEMEMAIL_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_SYSTEMEMAIL_DESCRIPTION', '107', 'top', '#jform_sendEmail0', '2', '3', 'administrator/index.php?option=com_users&view=user&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('108', '11', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_STATUS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_STATUS_DESCRIPTION', '108', 'top', '#jform_block0', '2', '3', 'administrator/index.php?option=com_users&view=user&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('109', '11', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORDRESET_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORDRESET_DESCRIPTION', '109', 'top', '#jform_requireReset0', '2', '3', 'administrator/index.php?option=com_users&view=user&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('110', '11', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_SAVECLOSE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_SAVECLOSE_DESCRIPTION', '110', 'bottom', '#save-group-children-save .button-save', '2', '1', 'administrator/index.php?option=com_users&view=user&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('111', '11', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_CONGRATULATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_CONGRATULATIONS_DESCRIPTION', '111', 'bottom', '', '0', '1', 'administrator/index.php?option=com_users&view=user&layout=edit', '2024-03-28 05:46:50', '123', '2024-03-28 05:46:50', '123', NULL, NULL, '*', '', NULL),
('112', '12', 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_MENUS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_MENUS_DESCRIPTION', '1', 'right', '#sidebarmenu', '0', '1', '', '2024-04-17 10:42:11', '0', '2024-04-17 10:42:11', '0', NULL, NULL, '*', '', NULL),
('113', '12', 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_QUICKACCESS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_QUICKACCESS_DESCRIPTION', '2', 'center', '', '0', '1', '', '2024-04-17 10:42:11', '0', '2024-04-17 10:42:11', '0', NULL, NULL, '*', '', NULL),
('114', '12', 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_NOTIFICATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_NOTIFICATIONS_DESCRIPTION', '3', 'left', '.quickicons-for-update_quickicon .card', '0', '1', '', '2024-04-17 10:42:11', '0', '2024-04-17 10:42:11', '0', NULL, NULL, '*', '', NULL),
('115', '12', 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_TOPBAR_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_TOPBAR_DESCRIPTION', '4', 'bottom', '#header', '0', '1', '', '2024-04-17 10:42:11', '0', '2024-04-17 10:42:11', '0', NULL, NULL, '*', '', NULL),
('116', '12', 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_FINALWORDS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_FINALWORDS_DESCRIPTION', '5', 'right', '#sidebarmenu nav > ul:first-of-type > li:last-child', '0', '1', '', '2024-04-17 10:42:11', '0', '2024-04-17 10:42:11', '0', NULL, NULL, '*', '', NULL),
('117', '13', 'COM_GUIDEDTOURS_TOUR_WHATSNEW_5_2_STEP_0_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_WHATSNEW_5_2_STEP_0_DESCRIPTION', '0', 'right', '#sidebarmenu nav > ul:first-of-type > li:last-child', '0', '1', '', '2025-09-25 07:34:18', '0', '2025-09-25 07:34:18', '0', NULL, NULL, '*', '', '{\"required\":1,\"requiredvalue\":\"\"}'),
('118', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_AUTOSTART_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_AUTOSTART_DESCRIPTION', '6', 'bottom', '#jform_autostart0', '2', '3', '', '2025-09-25 07:34:18', '0', '2025-09-25 07:34:18', '0', NULL, NULL, '*', '', NULL),
('119', '14', 'COM_GUIDEDTOURS_TOUR_WHATSNEW_5_3_STEP_0_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_WHATSNEW_5_3_STEP_0_DESCRIPTION', '0', 'right', '#sidebarmenu nav > ul:first-of-type > li:last-child', '0', '1', '', '2025-09-25 07:34:19', '0', '2025-09-25 07:34:19', '0', NULL, NULL, '*', '', '\"{\"required\":1,\"requiredvalue\":\"\"}\"');
/**ABDB**/CREATE TABLE `#__scheduler_tasks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `title` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(128) NOT NULL COMMENT 'unique identifier for job defined by plugin',
  `execution_rules` text DEFAULT NULL COMMENT 'Execution Rules, Unprocessed',
  `cron_rules` text DEFAULT NULL COMMENT 'Processed execution rules, crontab-like JSON form',
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `last_exit_code` int(11) NOT NULL DEFAULT 0 COMMENT 'Exit code when job was last run',
  `last_execution` datetime DEFAULT NULL COMMENT 'Timestamp of last run',
  `next_execution` datetime DEFAULT NULL COMMENT 'Timestamp of next (planned) run, referred for execution on trigger',
  `times_executed` int(11) DEFAULT 0 COMMENT 'Count of successful triggers',
  `times_failed` int(11) DEFAULT 0 COMMENT 'Count of failures',
  `locked` datetime DEFAULT NULL,
  `priority` smallint(6) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0 COMMENT 'Configurable list ordering',
  `cli_exclusive` smallint(6) NOT NULL DEFAULT 0 COMMENT 'If 1, the task is only accessible via CLI',
  `params` text NOT NULL,
  `note` text DEFAULT NULL,
  `created` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_type` (`type`),
  KEY `idx_state` (`state`),
  KEY `idx_last_exit` (`last_exit_code`),
  KEY `idx_next_exec` (`next_execution`),
  KEY `idx_locked` (`locked`),
  KEY `idx_priority` (`priority`),
  KEY `idx_cli_exclusive` (`cli_exclusive`),
  KEY `idx_checked_out` (`checked_out`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__scheduler_tasks`  VALUES 
('1', '97', 'Rotate Logs', 'rotation.logs', '{\"rule-type\":\"interval-days\",\"interval-days\":\"30\",\"exec-day\":\"28\",\"exec-time\":\"05:00\"}', '{\"type\":\"interval\",\"exp\":\"P30D\"}', '1', '0', '2025-09-25 07:32:09', '2025-10-25 07:32:09', '3', '0', NULL, '0', '0', '0', '{\"individual_log\":false,\"log_file\":\"\",\"notifications\":{\"success_mail\":\"0\",\"failure_mail\":\"1\",\"fatal_failure_mail\":\"1\",\"orphan_mail\":\"1\"},\"logstokeep\":1}', NULL, '2024-03-28 05:46:49', '123', NULL, NULL),
('2', '98', 'Session GC', 'session.gc', '{\"rule-type\":\"interval-hours\",\"interval-hours\":\"24\",\"exec-day\":\"01\",\"exec-time\":\"05:00\"}', '{\"type\":\"interval\",\"exp\":\"PT24H\"}', '1', '0', '2025-09-25 07:31:06', '2025-09-26 07:31:06', '45', '0', NULL, '0', '0', '0', '{\"individual_log\":false,\"log_file\":\"\",\"notifications\":{\"success_mail\":\"0\",\"failure_mail\":\"1\",\"fatal_failure_mail\":\"1\",\"orphan_mail\":\"1\"},\"enable_session_gc\":1,\"enable_session_metadata_gc\":1}', NULL, '2024-03-28 05:46:49', '123', NULL, NULL),
('3', '99', 'Update Notification', 'update.notification', '{\"rule-type\":\"interval-hours\",\"interval-hours\":\"24\",\"exec-day\":\"01\",\"exec-time\":\"05:00\"}', '{\"type\":\"interval\",\"exp\":\"PT24H\"}', '1', '0', '2025-09-25 07:31:57', '2025-09-26 07:31:57', '45', '0', NULL, '0', '0', '0', '{\"individual_log\":false,\"log_file\":\"\",\"notifications\":{\"success_mail\":\"0\",\"failure_mail\":\"1\",\"fatal_failure_mail\":\"1\",\"orphan_mail\":\"1\"},\"email\":\"\",\"language_override\":\"\"}', NULL, '2024-03-28 05:46:49', '123', NULL, NULL);
/**ABDB**/CREATE TABLE `#__schemas` (
  `extension_id` int(11) NOT NULL,
  `version_id` varchar(20) NOT NULL,
  PRIMARY KEY (`extension_id`,`version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__schemas`  VALUES 
('237', '5.3.0-2025-03-14'),
('271', '9.4.0-20221011');
/**ABDB**/CREATE TABLE `#__finder_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `mime` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `title` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__finder_types`  VALUES 
('1', 'Category', ''),
('2', 'Contact', ''),
('3', 'Article', ''),
('4', 'News Feed', ''),
('5', 'Tag', '');
/**ABDB**/CREATE TABLE `#__menu_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0,
  `menutype` varchar(24) NOT NULL,
  `title` varchar(48) NOT NULL,
  `description` varchar(255) NOT NULL DEFAULT '',
  `client_id` int(11) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_menutype` (`menutype`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__menu_types`  VALUES 
('1', '0', 'mainmenu', 'Main Menu', 'The main menu for the site', '0', '1');
/**ABDB**/CREATE TABLE `#__scheduler_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `taskname` varchar(255) NOT NULL DEFAULT '',
  `tasktype` varchar(128) NOT NULL COMMENT 'unique identifier for job defined by plugin',
  `duration` decimal(5,3) NOT NULL,
  `jobid` int(10) unsigned NOT NULL,
  `taskid` int(10) unsigned NOT NULL,
  `exitcode` int(11) NOT NULL,
  `lastdate` datetime DEFAULT NULL COMMENT 'Timestamp of last run',
  `nextdate` datetime DEFAULT NULL COMMENT 'Timestamp of next (planned) run, referred for execution on trigger',
  PRIMARY KEY (`id`),
  KEY `idx_taskname` (`taskname`),
  KEY `idx_tasktype` (`tasktype`),
  KEY `idx_lastdate` (`lastdate`),
  KEY `idx_nextdate` (`nextdate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `published` tinyint(4) NOT NULL DEFAULT 1,
  `description` text DEFAULT NULL,
  `params` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/**ABDB**/CREATE TABLE `#__content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `introtext` mediumtext NOT NULL,
  `fulltext` mediumtext NOT NULL,
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `catid` int(10) unsigned NOT NULL DEFAULT 0,
  `created` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `images` text NOT NULL,
  `urls` text NOT NULL,
  `attribs` varchar(5120) NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `metakey` text DEFAULT NULL,
  `metadesc` text NOT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'Set if article is featured.',
  `language` char(7) NOT NULL COMMENT 'The language code for the article.',
  `note` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(191))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__content`  VALUES 
('1', '124', '10 Sensational Hotel Baths With A View', '10-sensational-hotel-baths-with-a-view', '<p>Noka Camp’s five stilted villas, including one villa specially designed for families, are perched atop a 100ft cliff, overlooking the winding Palala River below and the endless bush ahead.</p>\r\n', '\r\n<p>The villas are joined by the main lodge consisting of a dining room, bar, lounge area and sprawling outdoor terrace. The camp is entirely off-grid, self-generated all energy by a bespoke, 250m solar walkway.</p>\r\n<h2>The Olive Tree, Bath, Somerset, England</h2>\r\n<p>Small bells hang on the wall perhaps in homage to the Abbey bells, behind a white reception while the rest of the room has funky artworks, as does most of the hotel. Sometimes it’s Regency-style, sometimes faces obscured by a primary colour and bizarrely even animals dressed in military costumes. In much of the communal area, carpets are decorated with butterflies; sometimes there are prints and maps. A lot is going on.</p>\r\n<blockquote>\r\n<p>Imagine sinking into some bubbles looking out across an azure sea, or enjoying a soak with a chilled glass of champagne over a cityscape.</p>\r\n</blockquote>\r\n<p>Sure, there have always been tourists behaving badly ever since the first tourist existed. But, in an age where travel has become so easy and ubiquitous for so many for the first time, those problems have amplified a thousandfold. Destinations didn’t have the necessary infrastructure to handle the flood of tourists cheap travel brought.</p>\r\n<p>All rooms come with comfy Hypnos beds with luxury Egyptian cotton linen, spacious bathrooms, Nespresso coffee machines, highspeed Wi-Fi and several channels on a 40” flat-screen TV.  The mini-bar comes stocked with some drinks that are included in the room rate.</p>\r\n<h2>12 Apostles Hotel &amp; Spa, South Africa</h2>\r\n<ul>\r\n<li>World Nomads (for everyone below 70)</li>\r\n<li>Insure My Trip (for those over 70)</li>\r\n<li>Medjet (for additional repatriation coverage)</li>\r\n</ul>\r\n<p>As we yearn to reconnect with friends, family, and the world at large, I think that what we’ve gone through has also given many of us a chance to reflect on all the things we took for granted: the outdoors, community, neighborhood restaurants, and the arts.</p>\r\n<p>From flouting rules and refusing to wear a mask to hosting parties, coughing on others, and just generally being selfish, the pandemic has shown us that the world is filled with more assholes than we thought. But, despite all of that, when it comes to the future of travel, I think the pandemic is going to make it <em>better</em>.</p>', '1', '2', '2024-04-02 02:29:22', '123', '', '2024-04-02 02:31:06', '123', NULL, NULL, '2024-04-02 02:29:22', NULL, '{\"image_intro\":\"images\\/alexander-ramsey-dBtWLliLt5k-unsplash.jpg#joomlaImage:\\/\\/local-images\\/alexander-ramsey-dBtWLliLt5k-unsplash.jpg?width=1380&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/alexander-ramsey-dBtWLliLt5k-unsplash.jpg#joomlaImage:\\/\\/local-images\\/alexander-ramsey-dBtWLliLt5k-unsplash.jpg?width=1380&height=900\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"astroid_article_type\":\"regular\",\"astroid_article_video_type\":\"youtube\",\"astroid_article_video_url\":\"\",\"astroid_article_gallery_width\":\"\",\"astroid_article_gallery_bullets\":\"1\",\"astroid_article_gallery_navigation\":\"1\",\"astroid_article_thumbnail\":\"1\",\"astroid_article_gallery_items\":[],\"astroid_article_audio_source\":\"soundcloud\",\"astroid_article_audio_soundcloud\":\"\",\"astroid_article_audio_spotify\":\"\",\"astroid_article_review_heading\":\"\",\"astroid_article_review_summery\":\"\",\"astroid_article_review_good\":\"\",\"astroid_article_review_bad\":\"\",\"astroid_article_review_rating\":\"5\",\"astroid_article_button_action\":\"\",\"astroid_article_button_link\":\"\",\"astroid_article_review_criterias\":[],\"astroid_article_quote_text\":\"\",\"astroid_article_quote_author\":\"\",\"astroid_article_content_position\":\"above-title\",\"astroid_article_badge\":\"0\",\"astroid_article_badge_type\":\"2\",\"astroid_article_badge_text\":\"\",\"astroid_article_badge_color\":\"\",\"astroid_article_badge_text_color\":\"\",\"astroid_authorinfo\":\"\",\"astroid_relatedposts\":\"\",\"article_relatedposts_count\":\"\",\"article_relatedposts_count_custom\":\"4\",\"article_relatedposts_posttype\":\"\",\"article_relatedposts_badge\":\"\",\"astroid_readtime\":\"\",\"astroid_socialshare\":\"\",\"astroid_comments\":\"\",\"astroid_og_title\":\"\",\"astroid_og_desc\":\"\",\"astroid_og_image\":\"\"}', '4', '1', '', '', '1', '13', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('2', '125', 'Travel Guide: 48 Hours In Dushanbe, Tajikstan ', 'travel-guide-48-hours-in-dushanbe-tajikstan', '<p>Many travellers arrive in Dushanbe, the capital and gateway of Tajikistan, and dash off for an adventure, perhaps hiking in the Fann Mountains or driving along the famously dramatic Pamir Highway.</p>\r\n', '\r\n<p>Yet this vibrant city along the Varzob (Dushanbinka) River in the Gissar valley, in the southwest of the republic offers plenty to see in just 48 hours.</p>\r\n<p>Whether you are a hobbyist strolling a new city, a travel blogger looking to share spectacular sights with your readers, or a professional photographer looking for a new niche, the architecture around us all the time is exciting and varied subject.</p>\r\n<h2 class=\"wp-block-heading\"><strong>Take A Walk In A Park</strong></h2>\r\n<p>Small bells hang on the wall perhaps in homage to the Abbey bells, behind a white reception while the rest of the room has funky artworks, as does most of the hotel. Sometimes it’s Regency-style, sometimes faces obscured by a primary colour and bizarrely even animals dressed in military costumes. In much of the communal area, carpets are decorated with butterflies; sometimes there are prints and maps. A lot is going on.</p>\r\n<blockquote>\r\n<p>Look out in particular for the red and white parliament building and the iconic Rokhat Teahouse, which is a good spot to stop for a cuppa whilst you admire the intricately painted interior.  </p>\r\n</blockquote>\r\n<p>Sure, there have always been tourists behaving badly ever since the first tourist existed. But, in an age where travel has become so easy and ubiquitous for so many for the first time, those problems have amplified a thousandfold. Destinations didn’t have the necessary infrastructure to handle the flood of tourists cheap travel brought.</p>\r\n<p>All rooms come with comfy Hypnos beds with luxury Egyptian cotton linen, spacious bathrooms, Nespresso coffee machines, highspeed Wi-Fi and several channels on a 40” flat-screen TV.  The mini-bar comes stocked with some drinks that are included in the room rate.</p>\r\n<h2 class=\"wp-block-heading\"><strong>Discover The Past</strong></h2>\r\n<p><strong><img class=\"float-none\" src=\"images/david-edelstein-N4DbvTUDikw-unsplash.jpg\" width=\"1380\" height=\"900\"></strong></p>\r\n<ul>\r\n<li>World Nomads (for everyone below 70)</li>\r\n<li>Insure My Trip (for those over 70)</li>\r\n<li>Medjet (for additional repatriation coverage)</li>\r\n</ul>\r\n<p>As we yearn to reconnect with friends, family, and the world at large, I think that what we’ve gone through has also given many of us a chance to reflect on all the things we took for granted: the outdoors, community, neighborhood restaurants, and the arts.</p>\r\n<p>From flouting rules and refusing to wear a mask to hosting parties, coughing on others, and just generally being selfish, the pandemic has shown us that the world is filled with more assholes than we thought. But, despite all of that, when it comes to the future of travel, I think the pandemic is going to make it <em>better</em>.</p>', '1', '2', '2024-04-02 02:29:22', '123', '', '2024-05-07 02:49:00', '123', NULL, NULL, '2024-04-02 02:29:22', NULL, '{\"image_intro\":\"images\\/daniela-cuevas-t7YycgAoVSw-unsplash.jpg#joomlaImage:\\/\\/local-images\\/daniela-cuevas-t7YycgAoVSw-unsplash.jpg?width=1380&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"astroid_article_type\":\"video\",\"astroid_article_video_type\":\"youtube\",\"astroid_article_video_url\":\"https:\\/\\/www.youtube.com\\/watch?v=mNzenfB3OuY\",\"astroid_article_gallery_width\":\"\",\"astroid_article_gallery_bullets\":\"1\",\"astroid_article_gallery_navigation\":\"1\",\"astroid_article_thumbnail\":\"1\",\"astroid_article_gallery_items\":[],\"astroid_article_audio_source\":\"soundcloud\",\"astroid_article_audio_soundcloud\":\"\",\"astroid_article_audio_spotify\":\"\",\"astroid_article_review_heading\":\"\",\"astroid_article_review_summery\":\"\",\"astroid_article_review_good\":\"\",\"astroid_article_review_bad\":\"\",\"astroid_article_review_rating\":\"5\",\"astroid_article_button_action\":\"\",\"astroid_article_button_link\":\"\",\"astroid_article_review_criterias\":[],\"astroid_article_quote_text\":\"\",\"astroid_article_quote_author\":\"\",\"astroid_article_content_position\":\"above-title\",\"astroid_article_badge\":\"0\",\"astroid_article_badge_type\":\"2\",\"astroid_article_badge_text\":\"\",\"astroid_article_badge_color\":\"\",\"astroid_article_badge_text_color\":\"\",\"astroid_authorinfo\":\"\",\"astroid_relatedposts\":\"\",\"article_relatedposts_count\":\"\",\"article_relatedposts_count_custom\":\"4\",\"article_relatedposts_posttype\":\"\",\"article_relatedposts_badge\":\"\",\"astroid_readtime\":\"\",\"astroid_socialshare\":\"\",\"astroid_comments\":\"\",\"astroid_og_title\":\"\",\"astroid_og_desc\":\"\",\"astroid_og_image\":\"\"}', '6', '2', '', '', '1', '5', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('3', '126', 'Restaurant Review: The Olive Tree, Bath, Somerset, England', 'restaurant-review-the-olive-tree-bath-somerset-england', '<p>The Olive Tree restaurant in Bath is in a basement on Russell Street. That sounds eerie, but actually, this hidden-away restaurant has a fine provenance, on at least two counts.</p>\r\n', '\r\n<p>It’s an easy yet slightly poised ambiance at The Olive Tree restaurant. Diners talk in hushed voices while their facial grimaces show reverence and subdued delight. Lighting is dimmed, walls are in a shade of olive with simple artwork, with a feature wall on one side, floors and tables are of wood, with chairs with black or olive green upholstery.</p>\r\n<h2>Ambience At The Olive Tree Restaurant</h2>\r\n<p>Small bells hang on the wall perhaps in homage to the Abbey bells, behind a white reception while the rest of the room has funky artworks, as does most of the hotel. Sometimes it’s Regency-style, sometimes faces obscured by a primary colour and bizarrely even animals dressed in military costumes. In much of the communal area, carpets are decorated with butterflies; sometimes there are prints and maps. A lot is going on.</p>\r\n<ul>\r\n<li>Always Use a Tripod</li>\r\n<li>Composition for Building Photography</li>\r\n<li>Control Perspective</li>\r\n</ul>\r\n<p>Whether you are a hobbyist strolling a new city, a travel blogger looking to share spectacular sights with your readers, or a professional photographer looking for a new niche, the architecture around us all the time is an exciting and varied subject.</p>\r\n<h2>Food &amp; Drink</h2>\r\n<blockquote>\r\n<p><em>The biggest mistake you can make in architecture photos is to snap and go, with little planning or forethought. Take your time and exercise your creative grey cells.</em></p>\r\n</blockquote>\r\n<p>As we yearn to reconnect with friends, family, and the world at large, I think that what we’ve gone through has also given many of us a chance to reflect on all the things we took for granted: the outdoors, community, neighborhood restaurants, and the arts.</p>\r\n<p>From flouting rules and refusing to wear a mask to hosting parties, coughing on others, and just generally being selfish, the pandemic has shown us that the world is filled with more assholes than we thought. But, despite all of that, when it comes to the future of travel, I think the pandemic is going to make it <em>better</em>.</p>', '1', '2', '2024-04-02 02:29:22', '123', '', '2024-05-07 02:49:33', '123', NULL, NULL, '2024-04-02 02:29:22', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"astroid_article_type\":\"gallery\",\"astroid_article_video_type\":\"youtube\",\"astroid_article_video_url\":\"\",\"astroid_article_gallery_width\":\"\",\"astroid_article_gallery_bullets\":\"1\",\"astroid_article_gallery_navigation\":\"1\",\"astroid_article_thumbnail\":\"1\",\"astroid_article_gallery_items\":{\"astroid_article_gallery_items0\":{\"title\":\"\",\"image\":\"images\\/drif-riadh-YpkuRn54y4w-unsplash.jpg#joomlaImage:\\/\\/local-images\\/drif-riadh-YpkuRn54y4w-unsplash.jpg?width=1380&height=900\",\"description\":\"\"},\"astroid_article_gallery_items1\":{\"title\":\"\",\"image\":\"images\\/felix-rostig-UmV2wr-Vbq8-unsplash.jpg#joomlaImage:\\/\\/local-images\\/felix-rostig-UmV2wr-Vbq8-unsplash.jpg?width=1380&height=900\",\"description\":\"\"},\"astroid_article_gallery_items2\":{\"title\":\"\",\"image\":\"images\\/kalen-emsley-7bwQXzbF6KE-unsplash.jpg#joomlaImage:\\/\\/local-images\\/kalen-emsley-7bwQXzbF6KE-unsplash.jpg?width=1380&height=900\",\"description\":\"\"}},\"astroid_article_audio_source\":\"soundcloud\",\"astroid_article_audio_soundcloud\":\"\",\"astroid_article_audio_spotify\":\"\",\"astroid_article_review_heading\":\"\",\"astroid_article_review_summery\":\"\",\"astroid_article_review_good\":\"\",\"astroid_article_review_bad\":\"\",\"astroid_article_review_rating\":\"5\",\"astroid_article_button_action\":\"\",\"astroid_article_button_link\":\"\",\"astroid_article_review_criterias\":[],\"astroid_article_quote_text\":\"\",\"astroid_article_quote_author\":\"\",\"astroid_article_content_position\":\"above-title\",\"astroid_article_badge\":\"0\",\"astroid_article_badge_type\":\"2\",\"astroid_article_badge_text\":\"\",\"astroid_article_badge_color\":\"\",\"astroid_article_badge_text_color\":\"\",\"astroid_authorinfo\":\"\",\"astroid_relatedposts\":\"\",\"article_relatedposts_count\":\"\",\"article_relatedposts_count_custom\":\"4\",\"article_relatedposts_posttype\":\"\",\"article_relatedposts_badge\":\"\",\"astroid_readtime\":\"\",\"astroid_socialshare\":\"\",\"astroid_comments\":\"\",\"astroid_og_title\":\"\",\"astroid_og_desc\":\"\",\"astroid_og_image\":\"\"}', '6', '3', '', '', '1', '17', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('4', '127', 'Whirlwind Trip To Historical Tunisia', 'whirlwind-trip-to-historical-tunisia', '<p>The capital Tunis’ main drag is the Avenue de France looking glorious with arcades modeled after those of Rivoli Street (rue de Rivoli) in Paris. </p>\r\n', '\r\n<p>The Avenue meets with Avenida Habib Bourguiba, named after Bourguiba considered the father of the nation loved for educating women and outlawing polygamy. The long stretch is abundant with flower sellers, while the central walkway, with its street musicians and vendors, has more than a whisper of France’s Champs Elysee.  </p>\r\n<h2 class=\"wp-block-heading\">Tunis, The Capital</h2>\r\n<p>Small bells hang on the wall perhaps in homage to the Abbey bells, behind a white reception while the rest of the room has funky artworks, as does most of the hotel. Sometimes it’s Regency-style, sometimes faces obscured by a primary colour and bizarrely even animals dressed in military costumes. In much of the communal area, carpets are decorated with butterflies; sometimes there are prints and maps. A lot is going on.</p>\r\n<blockquote>\r\n<p>Getting inspiration from other photographers through their online photography portfolios or social media posts only goes so far. </p>\r\n</blockquote>\r\n<p>Sure, there have always been tourists behaving badly ever since the first tourist existed. But, in an age where travel has become so easy and ubiquitous for so many for the first time, those problems have amplified a thousandfold. Destinations didn’t have the necessary infrastructure to handle the flood of tourists cheap travel brought.</p>\r\n<p>All rooms come with comfy Hypnos beds with luxury Egyptian cotton linen, spacious bathrooms, <strong>Nespresso coffee machines</strong>, highspeed Wi-Fi and several channels on a 40” flat-screen TV.  The mini-bar comes stocked with some drinks that are included in the room rate.</p>\r\n<h2>Historic National Theatre</h2>\r\n<p><img class=\"float-none\" src=\"images/garrett-parker-DlkF4-dbCOU-unsplash.jpg\" width=\"1380\" height=\"900\"></p>\r\n<ul>\r\n<li>World Nomads (for everyone below 70)</li>\r\n<li>Insure My Trip (for those over 70)</li>\r\n<li style=\"font-style: italic;\"><em>Medjet (for additional repatriation coverage)</em></li>\r\n</ul>\r\n<p>As we yearn to reconnect with friends, family, and the world at large, I think that what we’ve gone through has also given many of us a chance to reflect on all the things we took for granted: the outdoors, community, neighborhood restaurants, and the arts.</p>\r\n<p>From flouting rules and refusing to wear a mask to hosting parties, coughing on others, and just generally being selfish, the pandemic has shown us that the world is filled with more assholes than we thought. But, despite all of that, when it comes to the future of travel, I think the pandemic is going to make it <em>better</em>.</p>', '1', '2', '2024-04-02 02:29:22', '123', '', '2024-04-02 02:45:58', '123', NULL, NULL, '2024-04-02 02:29:22', NULL, '{\"image_intro\":\"images\\/hanson-lu-_8EFj6ISA08-unsplash.jpg#joomlaImage:\\/\\/local-images\\/hanson-lu-_8EFj6ISA08-unsplash.jpg?width=1380&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"astroid_article_type\":\"audio\",\"astroid_article_video_type\":\"youtube\",\"astroid_article_video_url\":\"\",\"astroid_article_gallery_width\":\"\",\"astroid_article_gallery_bullets\":\"1\",\"astroid_article_gallery_navigation\":\"1\",\"astroid_article_thumbnail\":\"1\",\"astroid_article_gallery_items\":[],\"astroid_article_audio_source\":\"soundcloud\",\"astroid_article_audio_soundcloud\":\"<iframe width=\\\"100%\\\" height=\\\"300\\\" scrolling=\\\"no\\\" frameborder=\\\"no\\\" allow=\\\"autoplay\\\" src=\\\"https:\\/\\/w.soundcloud.com\\/player\\/?url=https%3A\\/\\/api.soundcloud.com\\/tracks\\/218073744&color=%23ff5500&auto_play=false&hide_related=false&show_comments=true&show_user=true&show_reposts=false&show_teaser=true&visual=true\\\"><\\/iframe><div style=\\\"font-size: 10px; color: #cccccc;line-break: anywhere;word-break: normal;overflow: hidden;white-space: nowrap;text-overflow: ellipsis; font-family: Interstate,Lucida Grande,Lucida Sans Unicode,Lucida Sans,Garuda,Verdana,Tahoma,sans-serif;font-weight: 100;\\\"><a href=\\\"https:\\/\\/soundcloud.com\\/blakeshelton\\\" title=\\\"Blake Shelton\\\" target=\\\"_blank\\\" style=\\\"color: #cccccc; text-decoration: none;\\\">Blake Shelton<\\/a> \\u00b7 <a href=\\\"https:\\/\\/soundcloud.com\\/blakeshelton\\/home-feat-michael-buble-1\\\" title=\\\"Home (feat. Michael Buble)\\\" target=\\\"_blank\\\" style=\\\"color: #cccccc; text-decoration: none;\\\">Home (feat. Michael Buble)<\\/a><\\/div>\",\"astroid_article_audio_spotify\":\"\",\"astroid_article_review_heading\":\"\",\"astroid_article_review_summery\":\"\",\"astroid_article_review_good\":\"\",\"astroid_article_review_bad\":\"\",\"astroid_article_review_rating\":\"5\",\"astroid_article_button_action\":\"\",\"astroid_article_button_link\":\"\",\"astroid_article_review_criterias\":[],\"astroid_article_quote_text\":\"\",\"astroid_article_quote_author\":\"\",\"astroid_article_content_position\":\"above-title\",\"astroid_article_badge\":\"0\",\"astroid_article_badge_type\":\"2\",\"astroid_article_badge_text\":\"\",\"astroid_article_badge_color\":\"\",\"astroid_article_badge_text_color\":\"\",\"astroid_authorinfo\":\"\",\"astroid_relatedposts\":\"\",\"article_relatedposts_count\":\"\",\"article_relatedposts_count_custom\":\"4\",\"article_relatedposts_posttype\":\"\",\"article_relatedposts_badge\":\"\",\"astroid_readtime\":\"\",\"astroid_socialshare\":\"\",\"astroid_comments\":\"\",\"astroid_og_title\":\"\",\"astroid_og_desc\":\"\",\"astroid_og_image\":\"\"}', '5', '4', '', '', '1', '6', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('5', '128', '5 Things We Know About Flying This Summer', '5-things-we-know-about-flying-this-summer', '<p>Small bells hang on the wall perhaps in homage to the Abbey bells, behind a white reception while the rest of the room has funky artworks, as does most of the hotel.</p>\r\n', '\r\n<p>According to the airline industry group Airlines for America, passenger volume on U.S. carriers was down 53 percent in mid-March compared to pre-Covid-19 levels, but up from the darkest days of the pandemic, when it bottomed out below 90 percent.</p>\r\n<p>With the soft bounce, only Delta Air Lines has continued to block middle seats through April. It would not comment on an extension. (Alaska Airlines is keeping middle seats open in its Premium Class through May 31).</p>\r\n<h2>Headed Into Low-Cost Headwinds</h2>\r\n<p>Sometimes it’s Regency-style, sometimes faces obscured by a primary colour and bizarrely even animals dressed in military costumes. In much of the communal area, carpets are decorated with butterflies; sometimes there are prints and maps. A lot is going on.</p>\r\n<blockquote>\r\n<p>Getting inspiration from other photographers through their online photography portfolios or social media posts only goes so far. </p>\r\n</blockquote>\r\n<p>Sure, there have always been tourists behaving badly ever since the first tourist existed. But, in an age where travel has become so easy and ubiquitous for so many for the first time, those problems have amplified a thousandfold. Destinations didn’t have the necessary infrastructure to handle the flood of tourists cheap travel brought.</p>\r\n<p>All rooms come with comfy Hypnos beds with luxury Egyptian cotton linen, spacious bathrooms, Nespresso coffee machines, highspeed Wi-Fi and several channels on a 40” flat-screen TV.  The mini-bar comes stocked with some drinks that are included in the room rate.</p>\r\n<h2>The Skies Will Be Busier, The Planes Fuller</h2>\r\n<ul>\r\n<li>World Nomads (for everyone below 70)</li>\r\n<li>Insure My Trip (for those over 70)</li>\r\n<li style=\"font-style: italic;\"><em>Medjet (for additional repatriation coverage)</em></li>\r\n</ul>\r\n<p>As we yearn to reconnect with friends, family, and the world at large, I think that what we’ve gone through has also given many of us a chance to reflect on all the things we took for granted: the outdoors, community, neighborhood restaurants, and the arts.</p>\r\n<p>From flouting rules and refusing to wear a mask to hosting parties, coughing on others, and just generally being selfish, the pandemic has shown us that the world is filled with more assholes than we thought. But, despite all of that, when it comes to the future of travel, I think the pandemic is going to make it <em>better</em>.</p>', '1', '2', '2024-04-02 02:29:22', '123', '', '2024-04-02 02:51:54', '123', NULL, NULL, '2024-04-02 02:29:22', NULL, '{\"image_intro\":\"images\\/ibrahim-rifath-Y6tBl0pTe-g-unsplash.jpg#joomlaImage:\\/\\/local-images\\/ibrahim-rifath-Y6tBl0pTe-g-unsplash.jpg?width=1380&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"astroid_article_type\":\"quote\",\"astroid_article_video_type\":\"youtube\",\"astroid_article_video_url\":\"\",\"astroid_article_gallery_width\":\"\",\"astroid_article_gallery_bullets\":\"1\",\"astroid_article_gallery_navigation\":\"1\",\"astroid_article_thumbnail\":\"1\",\"astroid_article_gallery_items\":[],\"astroid_article_audio_source\":\"soundcloud\",\"astroid_article_audio_soundcloud\":\"\",\"astroid_article_audio_spotify\":\"\",\"astroid_article_review_heading\":\"\",\"astroid_article_review_summery\":\"\",\"astroid_article_review_good\":\"\",\"astroid_article_review_bad\":\"\",\"astroid_article_review_rating\":\"5\",\"astroid_article_button_action\":\"\",\"astroid_article_button_link\":\"\",\"astroid_article_review_criterias\":[],\"astroid_article_quote_text\":\"The biggest thing you can do to make your architecture photos stand out is to strive to make visually compelling images\",\"astroid_article_quote_author\":\"David Hension\",\"astroid_article_content_position\":\"above-title\",\"astroid_article_badge\":\"0\",\"astroid_article_badge_type\":\"2\",\"astroid_article_badge_text\":\"\",\"astroid_article_badge_color\":\"\",\"astroid_article_badge_text_color\":\"\",\"astroid_authorinfo\":\"\",\"astroid_relatedposts\":\"\",\"article_relatedposts_count\":\"\",\"article_relatedposts_count_custom\":\"4\",\"article_relatedposts_posttype\":\"\",\"article_relatedposts_badge\":\"\",\"astroid_readtime\":\"\",\"astroid_socialshare\":\"\",\"astroid_comments\":\"\",\"astroid_og_title\":\"\",\"astroid_og_desc\":\"\",\"astroid_og_image\":\"\"}', '4', '5', '', '', '1', '9', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('6', '129', 'A Beginner’s Guide To Architecture Photography', 'a-beginner-s-guide-to-architecture-photography', '<p>Architecture images grace the pages of magazines and fill travel albums all over the world. If architects do their job right, it only fits that their work would catch the eye of creative photographers.</p>\r\n', '\r\n<p>The villas are joined by the main lodge consisting of a dining room, bar, lounge area and sprawling outdoor terrace. The camp is entirely off-grid, <strong>self-generated all energy by a bespoke</strong>, 250m solar walkway.</p>\r\n<h2>Camera Equipment For Architecture</h2>\r\n<ul>\r\n<li>World Nomads (for everyone below 70)</li>\r\n<li>Insure My Trip (for those over 70)</li>\r\n<li>Medjet (for additional repatriation coverage)</li>\r\n</ul>\r\n<p>If you follow the tips below, you will avoid many of the most common mistakes while taking architecture photos. The biggest things to keep in mind are avoiding getting bogged down in technicalities and instead worry more about the basics of good photography like composition, lighting, and creating a connection with the viewer.</p>\r\n<p>When choosing lenses, think about the distortion that some of your lenses will cause and work to avoid it. Finally, be sure to spend some time considering how you want to present the building by thinking about the best time of day for the best light. </p>\r\n<h2>What Is Architecture Photography?</h2>\r\n<p><em>Small bells hang on the wall perhaps in homage to the Abbey bells</em>, behind a white reception while the rest of the room has funky artworks, as does most of the hotel. Sometimes it’s Regency-style, sometimes faces obscured by a primary colour and bizarrely even animals dressed in military costumes. In much of the communal area, carpets are decorated with butterflies; sometimes there are prints and maps. A lot is going on.</p>\r\n<blockquote>\r\n<p>Imagine sinking into some bubbles looking out across an azure sea, or enjoying a soak with a chilled glass of champagne over a cityscape.</p>\r\n</blockquote>\r\n<p>Sure, there have always been tourists behaving badly ever since the first tourist existed. But, in an age where travel has become so easy and ubiquitous for so many for the first time, those problems have amplified a thousandfold. Destinations didn’t have the necessary infrastructure to handle the flood of tourists cheap travel brought.</p>\r\n<p>All rooms come with comfy Hypnos beds with luxury Egyptian cotton linen, spacious bathrooms, Nespresso coffee machines, highspeed Wi-Fi and several channels on a 40” flat-screen TV.  The mini-bar comes stocked with some drinks that are included in the room rate.</p>', '1', '2', '2024-04-02 02:29:22', '123', '', '2024-04-02 02:56:53', '123', NULL, NULL, '2024-04-02 02:29:22', NULL, '{\"image_intro\":\"images\\/julian-timmerman-Fn27DlI8bZ8-unsplash.jpg#joomlaImage:\\/\\/local-images\\/julian-timmerman-Fn27DlI8bZ8-unsplash.jpg?width=1380&height=921\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/julian-timmerman-Fn27DlI8bZ8-unsplash.jpg#joomlaImage:\\/\\/local-images\\/julian-timmerman-Fn27DlI8bZ8-unsplash.jpg?width=1380&height=921\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"astroid_article_type\":\"regular\",\"astroid_article_video_type\":\"youtube\",\"astroid_article_video_url\":\"\",\"astroid_article_gallery_width\":\"\",\"astroid_article_gallery_bullets\":\"1\",\"astroid_article_gallery_navigation\":\"1\",\"astroid_article_thumbnail\":\"1\",\"astroid_article_gallery_items\":[],\"astroid_article_audio_source\":\"soundcloud\",\"astroid_article_audio_soundcloud\":\"\",\"astroid_article_audio_spotify\":\"\",\"astroid_article_review_heading\":\"\",\"astroid_article_review_summery\":\"\",\"astroid_article_review_good\":\"\",\"astroid_article_review_bad\":\"\",\"astroid_article_review_rating\":\"5\",\"astroid_article_button_action\":\"\",\"astroid_article_button_link\":\"\",\"astroid_article_review_criterias\":[],\"astroid_article_quote_text\":\"\",\"astroid_article_quote_author\":\"\",\"astroid_article_content_position\":\"above-title\",\"astroid_article_badge\":\"0\",\"astroid_article_badge_type\":\"2\",\"astroid_article_badge_text\":\"\",\"astroid_article_badge_color\":\"\",\"astroid_article_badge_text_color\":\"\",\"astroid_authorinfo\":\"\",\"astroid_relatedposts\":\"\",\"article_relatedposts_count\":\"\",\"article_relatedposts_count_custom\":\"4\",\"article_relatedposts_posttype\":\"\",\"article_relatedposts_badge\":\"\",\"astroid_readtime\":\"\",\"astroid_socialshare\":\"\",\"astroid_comments\":\"\",\"astroid_og_title\":\"\",\"astroid_og_desc\":\"\",\"astroid_og_image\":\"\"}', '5', '6', '', '', '1', '18', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('7', '130', 'What To Do On A Weekend In Istanbul, Türkiye', 'what-to-do-on-a-weekend-in-istanbul-tuerkiye', '<p>Lighting is dimmed, walls are in a shade of olive with simple artwork, with a feature wall on one side, floors and tables are of wood, with chairs with black or olive green upholstery.</p>\r\n', '\r\n<p>The villas are joined by the main lodge consisting of a dining room, bar, lounge area and sprawling outdoor terrace. The camp is entirely off-grid, <strong>self-generated all energy by a bespoke</strong>, 250m solar walkway.</p>\r\n<h2><strong>Mistake #1: Wildlife Baiting</strong> </h2>\r\n<ul>\r\n<li>World Nomads (for everyone below 70)</li>\r\n<li>Insure My Trip (for those over 70)</li>\r\n<li>Medjet (for additional repatriation coverage)</li>\r\n</ul>\r\n<p>This one is less about how you make the images and more about how you share them with the world. In the last couple of years, experts have expressed growing concerns over the consequences of geotagging photos on social media; in 2018, for instance, the Jackson Hole Travel &amp; Tourism Board urged visitors to stop tagging their locations.</p>\r\n<h2><strong>Mistake #2: Ill-Considered Use Of Flash </strong></h2>\r\n<p><em>Small bells hang on the wall perhaps in homage to the Abbey bells</em>, behind a white reception while the rest of the room has funky artworks, as does most of the hotel. </p>\r\n<blockquote>\r\n<p>In stylish Taksim looking dapper with its many art deco buildings, we popped into Kismet by Milka in Bebek whose quaint jewellery designs are worn by celebrities worldwide.</p>\r\n</blockquote>\r\n<p>Sure, there have always been tourists behaving badly ever since the first tourist existed. But, in an age where travel has become so easy and ubiquitous for so many for the first time, those problems have amplified a thousandfold. </p>\r\n<p>All rooms come with comfy Hypnos beds with luxury Egyptian cotton linen, spacious bathrooms, Nespresso coffee machines, highspeed Wi-Fi and several channels on a 40” flat-screen TV.  The mini-bar comes stocked with some drinks that are included in the room rate.</p>', '1', '2', '2024-04-02 02:29:22', '123', '', '2024-04-02 03:09:21', '123', NULL, NULL, '2024-04-02 02:29:22', NULL, '{\"image_intro\":\"images\\/raimond-klavins-kkJRyWGpQuw-unsplash.jpg#joomlaImage:\\/\\/local-images\\/raimond-klavins-kkJRyWGpQuw-unsplash.jpg?width=1380&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"astroid_article_type\":\"video\",\"astroid_article_video_type\":\"youtube\",\"astroid_article_video_url\":\"https:\\/\\/www.youtube.com\\/watch?v=UdB58PPZFW0\",\"astroid_article_gallery_width\":\"\",\"astroid_article_gallery_bullets\":\"1\",\"astroid_article_gallery_navigation\":\"1\",\"astroid_article_thumbnail\":\"1\",\"astroid_article_gallery_items\":[],\"astroid_article_audio_source\":\"soundcloud\",\"astroid_article_audio_soundcloud\":\"\",\"astroid_article_audio_spotify\":\"\",\"astroid_article_review_heading\":\"\",\"astroid_article_review_summery\":\"\",\"astroid_article_review_good\":\"\",\"astroid_article_review_bad\":\"\",\"astroid_article_review_rating\":\"5\",\"astroid_article_button_action\":\"\",\"astroid_article_button_link\":\"\",\"astroid_article_review_criterias\":[],\"astroid_article_quote_text\":\"\",\"astroid_article_quote_author\":\"\",\"astroid_article_content_position\":\"above-title\",\"astroid_article_badge\":\"0\",\"astroid_article_badge_type\":\"2\",\"astroid_article_badge_text\":\"\",\"astroid_article_badge_color\":\"\",\"astroid_article_badge_text_color\":\"\",\"astroid_authorinfo\":\"\",\"astroid_relatedposts\":\"\",\"article_relatedposts_count\":\"\",\"article_relatedposts_count_custom\":\"4\",\"article_relatedposts_posttype\":\"\",\"article_relatedposts_badge\":\"\",\"astroid_readtime\":\"\",\"astroid_socialshare\":\"\",\"astroid_comments\":\"\",\"astroid_og_title\":\"\",\"astroid_og_desc\":\"\",\"astroid_og_image\":\"\"}', '7', '7', '', '', '1', '6', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('8', '131', 'HOTEL Review: Hotel Indigo Bath, Somerset', 'hotel-review-hotel-indigo-bath-somerset', '<p>The decor is a departure from other themed hotel rooms; it has a four-poster bed with stylish bathrooms decorated with patterned tiling, a rainforest shower and a free-standing roll-top bath.</p>\r\n', '\r\n<p>The main entrance leads to the reception area where staff clad in jeans and a waistcoat are welcoming and efficient. The colourful area has comfortable sofas, armchairs and chandeliers making this a lovely place to hang out. It has a trendy vibe about it.</p>\r\n<h2>Facilities</h2>\r\n<p>Small bells hang on the wall perhaps in homage to the Abbey bells, behind a white reception while the rest of the room has funky artworks, as does most of the hotel. Sometimes it’s Regency-style, sometimes faces obscured by a primary colour and bizarrely even animals dressed in military costumes. </p>\r\n<blockquote>\r\n<p>Getting inspiration from other photographers through their online photography portfolios or social media posts only goes so far. </p>\r\n</blockquote>\r\n<p>Sure, there have always been tourists behaving badly ever since the first tourist existed. But, in an age where travel has become so easy and ubiquitous for so many for the first time, those problems have amplified a thousandfold. Destinations didn’t have the necessary infrastructure to handle the flood of tourists cheap travel brought.</p>\r\n<p>All rooms come with comfy Hypnos beds with luxury Egyptian cotton linen, spacious bathrooms, <strong>Nespresso coffee machines</strong>, highspeed Wi-Fi and several channels on a 40” flat-screen TV.  The mini-bar comes stocked with some drinks that are included in the room rate.</p>\r\n<h2>Nespresso coffee machines</h2>\r\n<p><img class=\"float-none\" src=\"images/garrett-parker-DlkF4-dbCOU-unsplash.jpg\" width=\"1380\" height=\"900\"></p>\r\n<ul>\r\n<li>World Nomads (for everyone below 70)</li>\r\n<li>Insure My Trip (for those over 70)</li>\r\n<li style=\"font-style: italic;\"><em>Medjet (for additional repatriation coverage)</em></li>\r\n</ul>\r\n<p>As we yearn to reconnect with friends, family, and the world at large, I think that what we’ve gone through has also given many of us a chance to reflect on all the things we took for granted: the outdoors, community, neighborhood restaurants, and the arts.</p>\r\n<p>From flouting rules and refusing to wear a mask to hosting parties, coughing on others, and just generally being selfish, the pandemic has shown us that the world is filled with more assholes than we thought. But, despite all of that, when it comes to the future of travel, I think the pandemic is going to make it <em>better</em>.</p>', '1', '2', '2024-04-02 02:29:22', '123', '', '2024-05-07 02:48:22', '123', NULL, NULL, '2024-04-02 02:29:22', NULL, '{\"image_intro\":\"images\\/pietro-de-grandi-T7K4aEPoGGk-unsplash.jpg#joomlaImage:\\/\\/local-images\\/pietro-de-grandi-T7K4aEPoGGk-unsplash.jpg?width=1380&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"astroid_article_type\":\"audio\",\"astroid_article_video_type\":\"youtube\",\"astroid_article_video_url\":\"\",\"astroid_article_gallery_width\":\"\",\"astroid_article_gallery_bullets\":\"1\",\"astroid_article_gallery_navigation\":\"1\",\"astroid_article_thumbnail\":\"1\",\"astroid_article_gallery_items\":[],\"astroid_article_audio_source\":\"soundcloud\",\"astroid_article_audio_soundcloud\":\"<iframe width=\\\"100%\\\" height=\\\"300\\\" scrolling=\\\"no\\\" frameborder=\\\"no\\\" allow=\\\"autoplay\\\" src=\\\"https:\\/\\/w.soundcloud.com\\/player\\/?url=https%3A\\/\\/api.soundcloud.com\\/tracks\\/206722679&color=%23ff5500&auto_play=false&hide_related=false&show_comments=true&show_user=true&show_reposts=false&show_teaser=true&visual=true\\\"><\\/iframe><div style=\\\"font-size: 10px; color: #cccccc;line-break: anywhere;word-break: normal;overflow: hidden;white-space: nowrap;text-overflow: ellipsis; font-family: Interstate,Lucida Grande,Lucida Sans Unicode,Lucida Sans,Garuda,Verdana,Tahoma,sans-serif;font-weight: 100;\\\"><a href=\\\"https:\\/\\/soundcloud.com\\/fkj-2\\\" title=\\\"FKJ\\\" target=\\\"_blank\\\" style=\\\"color: #cccccc; text-decoration: none;\\\">FKJ<\\/a> \\u00b7 <a href=\\\"https:\\/\\/soundcloud.com\\/fkj-2\\/lianne-la-havas-unstoppable-fkj-remix\\\" title=\\\"Lianne La Havas  - Unstoppable (FKJ Remix)\\\" target=\\\"_blank\\\" style=\\\"color: #cccccc; text-decoration: none;\\\">Lianne La Havas  - Unstoppable (FKJ Remix)<\\/a><\\/div>\",\"astroid_article_audio_spotify\":\"\",\"astroid_article_review_heading\":\"\",\"astroid_article_review_summery\":\"\",\"astroid_article_review_good\":\"\",\"astroid_article_review_bad\":\"\",\"astroid_article_review_rating\":\"5\",\"astroid_article_button_action\":\"\",\"astroid_article_button_link\":\"\",\"astroid_article_review_criterias\":[],\"astroid_article_quote_text\":\"\",\"astroid_article_quote_author\":\"\",\"astroid_article_content_position\":\"above-title\",\"astroid_article_badge\":\"0\",\"astroid_article_badge_type\":\"2\",\"astroid_article_badge_text\":\"\",\"astroid_article_badge_color\":\"\",\"astroid_article_badge_text_color\":\"\",\"astroid_authorinfo\":\"\",\"astroid_relatedposts\":\"\",\"article_relatedposts_count\":\"\",\"article_relatedposts_count_custom\":\"4\",\"article_relatedposts_posttype\":\"\",\"article_relatedposts_badge\":\"\",\"astroid_readtime\":\"\",\"astroid_socialshare\":\"\",\"astroid_comments\":\"\",\"astroid_og_title\":\"\",\"astroid_og_desc\":\"\",\"astroid_og_image\":\"\"}', '4', '8', '', '', '1', '5', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('9', '132', 'Where Music Lovers Should Travel In 2024', 'where-music-lovers-should-travel-in-2024', '<p> It’s also a chance to hear up and coming jazz artists, such as the National Youth Jazz Orchestra (NYJO), as the festival has an active talent development programme. </p>\r\n', '\r\n<p>A trip to Cheltenham is a pleasure at any time of the year, but the Georgian spa town is particularly buzzing during Cheltenham Jazz Festival when 20,000 music fans descend on Montpellier Gardens over the week.</p>\r\n<p>This year Gregory Porter, the festival’s Artistic Curator, will be headlining, and other acts not to miss include Dionne Warwick, Sophie Ellis Bextor, Ronnie Scott’s Jazz Orchestra, Morcheeba, and Courtney Pine.</p>\r\n<h2>Headed Into Low-Cost Headwinds</h2>\r\n<p>Sometimes it’s Regency-style, sometimes faces obscured by a primary colour and bizarrely even animals dressed in military costumes. In much of the communal area, carpets are decorated with butterflies; sometimes there are prints and maps. A lot is going on.</p>\r\n<blockquote>\r\n<p>Getting inspiration from other photographers through their online photography portfolios or social media posts only goes so far. </p>\r\n</blockquote>\r\n<p>Most musical genres are represented in the programme, so whether it is blues, soul, rock, folk, or electronic music that gets you up on the dance floor, there will be plenty to keep you entertained until late at night</p>\r\n<p>All rooms come with comfy Hypnos beds with luxury Egyptian cotton linen, spacious bathrooms, Nespresso coffee machines, highspeed Wi-Fi and several channels on a 40” flat-screen TV.  The mini-bar comes stocked with some drinks that are included in the room rate.</p>\r\n<h2>The Skies Will Be Busier, The Planes Fuller</h2>\r\n<ul>\r\n<li>World Nomads (for everyone below 70)</li>\r\n<li>Insure My Trip (for those over 70)</li>\r\n<li style=\"font-style: italic;\"><em>Medjet (for additional repatriation coverage)</em></li>\r\n</ul>\r\n<p>As we yearn to reconnect with friends, family, and the world at large, I think that what we’ve gone through has also given many of us a chance to reflect on all the things we took for granted: the outdoors, community, neighborhood restaurants, and the arts.</p>\r\n<p>From flouting rules and refusing to <em>wear a mask to hosting parties</em>, coughing on others, and just generally being selfish, the pandemic has shown us that the world is filled with more assholes than we thought. </p>', '1', '2', '2024-04-02 02:29:22', '123', '', '2024-04-02 03:21:49', '123', NULL, NULL, '2024-04-02 02:29:22', NULL, '{\"image_intro\":\"images\\/ibrahim-rifath-Y6tBl0pTe-g-unsplash.jpg#joomlaImage:\\/\\/local-images\\/ibrahim-rifath-Y6tBl0pTe-g-unsplash.jpg?width=1380&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"astroid_article_type\":\"quote\",\"astroid_article_video_type\":\"youtube\",\"astroid_article_video_url\":\"\",\"astroid_article_gallery_width\":\"\",\"astroid_article_gallery_bullets\":\"1\",\"astroid_article_gallery_navigation\":\"1\",\"astroid_article_thumbnail\":\"1\",\"astroid_article_gallery_items\":[],\"astroid_article_audio_source\":\"soundcloud\",\"astroid_article_audio_soundcloud\":\"\",\"astroid_article_audio_spotify\":\"\",\"astroid_article_review_heading\":\"\",\"astroid_article_review_summery\":\"\",\"astroid_article_review_good\":\"\",\"astroid_article_review_bad\":\"\",\"astroid_article_review_rating\":\"5\",\"astroid_article_button_action\":\"\",\"astroid_article_button_link\":\"\",\"astroid_article_review_criterias\":[],\"astroid_article_quote_text\":\"There are concerts here throughout the year, but the highlight is the summer opera festival, which has itself run for more than a century. \",\"astroid_article_quote_author\":\"David Poutays\",\"astroid_article_content_position\":\"above-title\",\"astroid_article_badge\":\"0\",\"astroid_article_badge_type\":\"2\",\"astroid_article_badge_text\":\"\",\"astroid_article_badge_color\":\"\",\"astroid_article_badge_text_color\":\"\",\"astroid_authorinfo\":\"\",\"astroid_relatedposts\":\"\",\"article_relatedposts_count\":\"\",\"article_relatedposts_count_custom\":\"4\",\"article_relatedposts_posttype\":\"\",\"article_relatedposts_badge\":\"\",\"astroid_readtime\":\"\",\"astroid_socialshare\":\"\",\"astroid_comments\":\"\",\"astroid_og_title\":\"\",\"astroid_og_desc\":\"\",\"astroid_og_image\":\"\"}', '4', '9', '', '', '1', '1', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('10', '133', '10 European Ski Destinations You Should Visit', '10-european-ski-destinations-you-should-visit', '<p>The attractive neo-classical opera house dates from the early 1940s, and forthcoming productions are advertised outside. Pop into the box office to book tickets.</p>\r\n', '\r\n<p>It’s an easy yet slightly poised ambiance at The Olive Tree restaurant. Diners talk in hushed voices while their facial grimaces show reverence and subdued delight. Lighting is dimmed, walls are in a shade of olive with simple artwork, with a feature wall on one side, floors and tables are of wood, with chairs with black or olive green upholstery.</p>\r\n<h2>Ambience At The Olive Tree Restaurant</h2>\r\n<p>Small bells hang on the wall perhaps in homage to the Abbey bells, behind a white reception while the rest of the room has funky artworks, as does most of the hotel. Sometimes it’s Regency-style, sometimes faces obscured by a primary colour and bizarrely even animals dressed in military costumes. </p>\r\n<ul>\r\n<li>Always Use a Tripod</li>\r\n<li>Composition for Building Photography</li>\r\n<li>Control Perspective</li>\r\n</ul>\r\n<p>Whether you are a hobbyist strolling a new city, a travel blogger looking to share spectacular sights with your readers, or a professional photographer looking for a new niche, the architecture around us all the time is an exciting and varied subject.</p>\r\n<h2>Food &amp; Drink</h2>\r\n<blockquote>\r\n<p><em>The biggest mistake you can make in architecture photos is to snap and go, with little planning or forethought. Take your time and exercise your creative grey cells.</em></p>\r\n</blockquote>\r\n<p>As we yearn to reconnect with friends, family, and the world at large, I think that what we’ve gone through has also given many of us a chance to reflect on all the things we took for granted: the outdoors, community, neighborhood restaurants, and the arts.</p>\r\n<p>From flouting rules and refusing to wear a mask to hosting parties, coughing on others, and just generally being selfish, the pandemic has shown us that the world is filled with more assholes than we thought. </p>', '1', '2', '2024-04-02 02:29:22', '123', '', '2024-04-02 03:27:03', '123', NULL, NULL, '2024-04-02 02:29:22', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"astroid_article_type\":\"gallery\",\"astroid_article_video_type\":\"youtube\",\"astroid_article_video_url\":\"\",\"astroid_article_gallery_width\":\"\",\"astroid_article_gallery_bullets\":\"1\",\"astroid_article_gallery_navigation\":\"1\",\"astroid_article_thumbnail\":\"1\",\"astroid_article_gallery_items\":{\"astroid_article_gallery_items0\":{\"title\":\"\",\"image\":\"images\\/luca-bravo-VowIFDxogG4-unsplash.jpg#joomlaImage:\\/\\/local-images\\/luca-bravo-VowIFDxogG4-unsplash.jpg?width=1380&height=900\",\"description\":\"\"},\"astroid_article_gallery_items1\":{\"title\":\"\",\"image\":\"images\\/david-edelstein-N4DbvTUDikw-unsplash.jpg#joomlaImage:\\/\\/local-images\\/david-edelstein-N4DbvTUDikw-unsplash.jpg?width=1380&height=900\",\"description\":\"\"},\"astroid_article_gallery_items2\":{\"title\":\"\",\"image\":\"images\\/kalen-emsley-7bwQXzbF6KE-unsplash.jpg#joomlaImage:\\/\\/local-images\\/kalen-emsley-7bwQXzbF6KE-unsplash.jpg?width=1380&height=900\",\"description\":\"\"}},\"astroid_article_audio_source\":\"soundcloud\",\"astroid_article_audio_soundcloud\":\"\",\"astroid_article_audio_spotify\":\"\",\"astroid_article_review_heading\":\"\",\"astroid_article_review_summery\":\"\",\"astroid_article_review_good\":\"\",\"astroid_article_review_bad\":\"\",\"astroid_article_review_rating\":\"5\",\"astroid_article_button_action\":\"\",\"astroid_article_button_link\":\"\",\"astroid_article_review_criterias\":[],\"astroid_article_quote_text\":\"\",\"astroid_article_quote_author\":\"\",\"astroid_article_content_position\":\"before-content\",\"astroid_article_badge\":\"0\",\"astroid_article_badge_type\":\"2\",\"astroid_article_badge_text\":\"\",\"astroid_article_badge_color\":\"\",\"astroid_article_badge_text_color\":\"\",\"astroid_authorinfo\":\"\",\"astroid_relatedposts\":\"\",\"article_relatedposts_count\":\"\",\"article_relatedposts_count_custom\":\"4\",\"article_relatedposts_posttype\":\"\",\"article_relatedposts_badge\":\"\",\"astroid_readtime\":\"\",\"astroid_socialshare\":\"\",\"astroid_comments\":\"\",\"astroid_og_title\":\"\",\"astroid_og_desc\":\"\",\"astroid_og_image\":\"\"}', '6', '10', '', '', '1', '4', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('11', '149', 'High-Speed Thames River RIB Cruise in London', 'high-speed-thames-river-rib-cruise-in-london', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque consequat odio turpis, eu finibus odio varius non. Suspendisse commodo lobortis dapibus.</p>\r\n', '\r\n<p>Morbi eu rhoncus risus. Praesent blandit efficitur eros ac rhoncus. In sit amet fermentum sem. Nunc nisi turpis, faucibus in arcu aliquam, tempus semper augue. Ut interdum erat neque, vitae facilisis leo convallis ut. Ut tempus placerat nisi, eget dapibus elit consectetur vel.</p>', '1', '8', '2024-04-12 03:11:28', '123', '', '2024-04-12 08:36:29', '123', NULL, NULL, '2024-04-12 03:11:28', NULL, '{\"image_intro\":\"images\\/charles-postiaux-Q6UehpkBSnQ-unsplash.jpg#joomlaImage:\\/\\/local-images\\/charles-postiaux-Q6UehpkBSnQ-unsplash.jpg?width=1920&height=1280\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"astroid_article_type\":\"gallery\",\"astroid_article_video_type\":\"youtube\",\"astroid_article_video_url\":\"\",\"astroid_article_gallery_width\":\"\",\"astroid_article_gallery_bullets\":\"1\",\"astroid_article_gallery_navigation\":\"1\",\"astroid_article_thumbnail\":\"1\",\"astroid_article_gallery_items\":{\"astroid_article_gallery_items0\":{\"title\":\"\",\"image\":\"images\\/charles-postiaux-Q6UehpkBSnQ-unsplash.jpg#joomlaImage:\\/\\/local-images\\/charles-postiaux-Q6UehpkBSnQ-unsplash.jpg?width=1920&height=1280\",\"description\":\"\"},\"astroid_article_gallery_items1\":{\"title\":\"\",\"image\":\"images\\/benjamin-davies-Oja2ty_9ZLM-unsplash.jpg#joomlaImage:\\/\\/local-images\\/benjamin-davies-Oja2ty_9ZLM-unsplash.jpg?width=1920&height=1280\",\"description\":\"\"},\"astroid_article_gallery_items2\":{\"title\":\"\",\"image\":\"images\\/lucas-davies-iP8ElEhqHeY-unsplash.jpg#joomlaImage:\\/\\/local-images\\/lucas-davies-iP8ElEhqHeY-unsplash.jpg?width=1920&height=1280\",\"description\":\"\"}},\"astroid_article_audio_source\":\"soundcloud\",\"astroid_article_audio_soundcloud\":\"\",\"astroid_article_audio_spotify\":\"\",\"astroid_article_review_heading\":\"\",\"astroid_article_review_summery\":\"\",\"astroid_article_review_good\":\"\",\"astroid_article_review_bad\":\"\",\"astroid_article_review_rating\":\"5\",\"astroid_article_button_action\":\"\",\"astroid_article_button_link\":\"\",\"astroid_article_review_criterias\":[],\"astroid_article_quote_text\":\"\",\"astroid_article_quote_author\":\"\",\"astroid_article_content_position\":\"above-title\",\"astroid_article_badge\":\"0\",\"astroid_article_badge_type\":\"2\",\"astroid_article_badge_text\":\"\",\"astroid_article_badge_color\":\"\",\"astroid_article_badge_text_color\":\"\",\"astroid_authorinfo\":\"\",\"astroid_relatedposts\":\"\",\"article_relatedposts_count\":\"\",\"article_relatedposts_count_custom\":\"4\",\"article_relatedposts_posttype\":\"\",\"article_relatedposts_badge\":\"\",\"astroid_readtime\":\"\",\"astroid_socialshare\":\"\",\"astroid_comments\":\"\",\"astroid_og_title\":\"\",\"astroid_og_desc\":\"\",\"astroid_og_image\":\"\"}', '4', '0', '', '', '1', '11', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', '');/**ABDB**/
/**ABDB**/CREATE TABLE `#__assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set rgt.',
  `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=181 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__assets`  VALUES 
('1', '0', '0', '339', '0', 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.api\":{\"8\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
('2', '1', '1', '2', '1', 'com_admin', 'com_admin', '{}'),
('3', '1', '3', '6', '1', 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('4', '1', '7', '8', '1', 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('5', '1', '9', '10', '1', 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('6', '1', '11', '12', '1', 'com_config', 'com_config', '{}'),
('7', '1', '13', '16', '1', 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('8', '1', '17', '72', '1', 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.execute.transition\":{\"6\":1,\"5\":1}}'),
('9', '1', '73', '74', '1', 'com_cpanel', 'com_cpanel', '{}'),
('10', '1', '75', '76', '1', 'com_installer', 'com_installer', '{\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}'),
('11', '1', '77', '80', '1', 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1}}'),
('12', '11', '78', '79', '2', 'com_languages.language.1', 'English (en-GB)', '{}'),
('13', '1', '81', '82', '1', 'com_login', 'com_login', '{}'),
('14', '1', '83', '84', '1', 'com_mails', 'com_mails', '{}'),
('15', '1', '85', '86', '1', 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'),
('16', '1', '87', '90', '1', 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1}}'),
('17', '1', '91', '92', '1', 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('18', '1', '93', '202', '1', 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1}}'),
('19', '1', '203', '206', '1', 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('20', '1', '207', '208', '1', 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1}}'),
('21', '1', '209', '210', '1', 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1}}'),
('23', '1', '211', '212', '1', 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1}}'),
('24', '1', '217', '220', '1', 'com_users', 'com_users', '{\"core.admin\":{\"7\":1}}'),
('26', '1', '221', '222', '1', 'com_wrapper', 'com_wrapper', '{}'),
('27', '8', '18', '39', '2', 'com_content.category.2', 'Uncategorised', '{}'),
('28', '3', '4', '5', '2', 'com_banners.category.3', 'Uncategorised', '{}'),
('29', '7', '14', '15', '2', 'com_contact.category.4', 'Uncategorised', '{}'),
('30', '19', '204', '205', '2', 'com_newsfeeds.category.5', 'Uncategorised', '{}'),
('32', '24', '218', '219', '2', 'com_users.category.7', 'Uncategorised', '{}'),
('33', '1', '223', '224', '1', 'com_finder', 'com_finder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('34', '1', '225', '226', '1', 'com_joomlaupdate', 'com_joomlaupdate', '{}'),
('35', '1', '227', '228', '1', 'com_tags', 'com_tags', '{}'),
('36', '1', '229', '230', '1', 'com_contenthistory', 'com_contenthistory', '{}'),
('37', '1', '231', '232', '1', 'com_ajax', 'com_ajax', '{}'),
('38', '1', '233', '234', '1', 'com_postinstall', 'com_postinstall', '{}'),
('39', '18', '94', '95', '2', 'com_modules.module.1', 'Main Menu', '{}'),
('40', '18', '96', '97', '2', 'com_modules.module.2', 'Login', '{}'),
('41', '18', '98', '99', '2', 'com_modules.module.3', 'Popular Articles', '{}'),
('42', '18', '100', '101', '2', 'com_modules.module.4', 'Recently Added Articles', '{}'),
('43', '18', '102', '103', '2', 'com_modules.module.8', 'Toolbar', '{}'),
('44', '18', '104', '105', '2', 'com_modules.module.9', 'Notifications', '{}'),
('45', '18', '106', '107', '2', 'com_modules.module.10', 'Logged-in Users', '{}'),
('46', '18', '108', '109', '2', 'com_modules.module.12', 'Admin Menu', '{}'),
('49', '18', '114', '115', '2', 'com_modules.module.15', 'Title', '{}'),
('50', '18', '116', '117', '2', 'com_modules.module.16', 'Login Form', '{}'),
('51', '18', '118', '119', '2', 'com_modules.module.17', 'Breadcrumbs', '{}'),
('52', '18', '120', '121', '2', 'com_modules.module.79', 'Multilanguage status', '{}'),
('53', '18', '124', '125', '2', 'com_modules.module.86', 'Joomla Version', '{}'),
('54', '16', '88', '89', '2', 'com_menus.menu.1', 'Main Menu', '{}'),
('55', '18', '128', '129', '2', 'com_modules.module.87', 'Sample Data', '{}'),
('56', '8', '40', '57', '2', 'com_content.workflow.1', 'COM_WORKFLOW_BASIC_WORKFLOW', '{}'),
('57', '56', '41', '42', '3', 'com_content.stage.1', 'COM_WORKFLOW_BASIC_STAGE', '{}'),
('58', '56', '43', '44', '3', 'com_content.transition.1', 'UNPUBLISH', '{}'),
('59', '56', '45', '46', '3', 'com_content.transition.2', 'PUBLISH', '{}'),
('60', '56', '47', '48', '3', 'com_content.transition.3', 'TRASH', '{}'),
('61', '56', '49', '50', '3', 'com_content.transition.4', 'ARCHIVE', '{}'),
('62', '56', '51', '52', '3', 'com_content.transition.5', 'FEATURE', '{}'),
('63', '56', '53', '54', '3', 'com_content.transition.6', 'UNFEATURE', '{}'),
('64', '56', '55', '56', '3', 'com_content.transition.7', 'PUBLISH_AND_FEATURE', '{}'),
('65', '1', '213', '214', '1', 'com_privacy', 'com_privacy', '{}'),
('66', '1', '215', '216', '1', 'com_actionlogs', 'com_actionlogs', '{}'),
('67', '18', '110', '111', '2', 'com_modules.module.88', 'Latest Actions', '{}'),
('68', '18', '112', '113', '2', 'com_modules.module.89', 'Privacy Dashboard', '{}'),
('70', '18', '122', '123', '2', 'com_modules.module.103', 'Site', '{}'),
('71', '18', '126', '127', '2', 'com_modules.module.104', 'System', '{}'),
('72', '18', '130', '131', '2', 'com_modules.module.91', 'System Dashboard', '{}'),
('73', '18', '132', '133', '2', 'com_modules.module.92', 'Content Dashboard', '{}'),
('74', '18', '134', '135', '2', 'com_modules.module.93', 'Menus Dashboard', '{}'),
('75', '18', '136', '137', '2', 'com_modules.module.94', 'Components Dashboard', '{}'),
('76', '18', '138', '139', '2', 'com_modules.module.95', 'Users Dashboard', '{}'),
('77', '18', '140', '141', '2', 'com_modules.module.99', 'Frontend Link', '{}'),
('78', '18', '142', '143', '2', 'com_modules.module.100', 'Messages', '{}'),
('79', '18', '144', '145', '2', 'com_modules.module.101', 'Post Install Messages', '{}'),
('80', '18', '146', '147', '2', 'com_modules.module.102', 'User Status', '{}'),
('82', '18', '148', '149', '2', 'com_modules.module.105', '3rd Party', '{}'),
('83', '18', '150', '151', '2', 'com_modules.module.106', 'Help Dashboard', '{}'),
('84', '18', '152', '153', '2', 'com_modules.module.107', 'Privacy Requests', '{}'),
('85', '18', '154', '155', '2', 'com_modules.module.108', 'Privacy Status', '{}'),
('86', '18', '156', '157', '2', 'com_modules.module.96', 'Popular Articles', '{}'),
('87', '18', '158', '159', '2', 'com_modules.module.97', 'Recently Added Articles', '{}'),
('88', '18', '160', '161', '2', 'com_modules.module.98', 'Logged-in Users', '{}'),
('89', '18', '162', '163', '2', 'com_modules.module.90', 'Login Support', '{}'),
('90', '1', '235', '236', '1', 'com_scheduler', 'com_scheduler', '{}'),
('91', '1', '237', '238', '1', 'com_associations', 'com_associations', '{}'),
('92', '1', '239', '240', '1', 'com_categories', 'com_categories', '{}'),
('93', '1', '241', '242', '1', 'com_fields', 'com_fields', '{}'),
('94', '1', '243', '244', '1', 'com_workflow', 'com_workflow', '{}'),
('95', '1', '245', '246', '1', 'com_guidedtours', 'com_guidedtours', '{}'),
('96', '18', '164', '165', '2', 'com_modules.module.109', 'Guided Tours', '{}'),
('97', '1', '247', '248', '1', 'com_scheduler.task.1', 'com_scheduler.task.1', '{}'),
('98', '1', '249', '250', '1', 'com_scheduler.task.2', 'com_scheduler.task.2', '{}'),
('99', '1', '251', '252', '1', 'com_scheduler.task.3', 'com_scheduler.task.3', '{}'),
('100', '18', '166', '167', '2', 'com_modules.module.110', 'Astroid Clear Cache', '{}'),
('101', '18', '168', '169', '2', 'com_modules.module.111', 'Astroid Menu', '{}'),
('102', '1', '253', '336', '1', 'com_tz_portfolio_plus', 'com_tz_portfolio_plus', '{}'),
('103', '102', '254', '255', '2', 'com_tz_portfolio_plus.category', 'Categories', '{}'),
('104', '102', '256', '297', '2', 'com_tz_portfolio_plus.group', 'Field Groups', '{}'),
('105', '102', '298', '299', '2', 'com_tz_portfolio_plus.tag', 'Tags', '{}'),
('106', '102', '300', '331', '2', 'com_tz_portfolio_plus.addon', 'Addons', '{}'),
('107', '102', '332', '333', '2', 'com_tz_portfolio_plus.template', 'Styles', '{}'),
('108', '102', '334', '335', '2', 'com_tz_portfolio_plus.style', 'Layouts', '{}'),
('109', '103', '255', '282', '2', 'com_tz_portfolio_plus.category.2', 'Tours', '{}'),
('110', '18', '170', '171', '2', 'com_modules.module.112', 'TZ Portfolio Plus Archived Articles', '{}'),
('111', '18', '172', '173', '2', 'com_modules.module.113', 'TZ Portfolio Plus Categories', '{}'),
('112', '18', '174', '175', '2', 'com_modules.module.114', 'TZ Portfolio Plus Filter', '{}'),
('113', '18', '176', '177', '2', 'com_modules.module.115', 'TZ Portfolio Plus Portfolio', '{}'),
('114', '18', '178', '179', '2', 'com_modules.module.116', 'TZ Portfolio Plus Tags', '{}'),
('115', '106', '301', '302', '3', 'com_tz_portfolio_plus.addon.2', 'Content - Vote', '{}'),
('116', '106', '303', '304', '3', 'com_tz_portfolio_plus.addon.6', 'Extrafields - Checkboxes', '{}'),
('117', '106', '305', '306', '3', 'com_tz_portfolio_plus.addon.7', 'Extrafields - Dropdown List', '{}'),
('118', '106', '307', '308', '3', 'com_tz_portfolio_plus.addon.8', 'Extrafields - Multiple Select', '{}'),
('119', '106', '309', '310', '3', 'com_tz_portfolio_plus.addon.9', 'Extrafields - Radio', '{}'),
('120', '106', '311', '312', '3', 'com_tz_portfolio_plus.addon.4', 'Extrafields - Text', '{}'),
('121', '106', '313', '314', '3', 'com_tz_portfolio_plus.addon.5', 'Extrafields - Textarea', '{}'),
('122', '106', '315', '316', '3', 'com_tz_portfolio_plus.addon.3', 'Media Type - Image', '{}'),
('123', '106', '317', '318', '3', 'com_tz_portfolio_plus.addon.10', 'User - Profile', '{}'),
('124', '27', '19', '20', '3', 'com_content.article.1', '10 Sensational Hotel Baths With A View', '{}'),
('125', '27', '21', '22', '3', 'com_content.article.2', 'Travel Guide: 48 Hours In Dushanbe, Tajikstan ', '{}'),
('126', '27', '23', '24', '3', 'com_content.article.3', 'Restaurant Review: The Olive Tree, Bath, Somerset, England', '{}'),
('127', '27', '25', '26', '3', 'com_content.article.4', 'Whirlwind Trip To Historical Tunisia', '{}'),
('128', '27', '27', '28', '3', 'com_content.article.5', '5 Things We Know About Flying This Summer', '{}'),
('129', '27', '29', '30', '3', 'com_content.article.6', 'A Beginner’s Guide To Architecture Photography', '{}'),
('130', '27', '31', '32', '3', 'com_content.article.7', 'What To Do On A Weekend In Istanbul, Türkiye', '{}'),
('131', '27', '33', '34', '3', 'com_content.article.8', 'HOTEL Review: Hotel Indigo Bath, Somerset', '{}'),
('132', '27', '35', '36', '3', 'com_content.article.9', 'Where Music Lovers Should Travel In 2024', '{}'),
('133', '27', '37', '38', '3', 'com_content.article.10', '10 European Ski Destinations You Should Visit', '{}'),
('134', '109', '256', '257', '3', 'com_tz_portfolio_plus.article.1', 'Ancient Trails Of Lycia', '{}'),
('135', '104', '283', '284', '3', 'com_tz_portfolio_plus.group.1', 'Tour', '{}'),
('136', '104', '285', '286', '3', 'com_tz_portfolio_plus.field.1', 'Destination', '{}'),
('137', '104', '287', '288', '3', 'com_tz_portfolio_plus.field.2', 'Language', '{}'),
('138', '104', '289', '290', '3', 'com_tz_portfolio_plus.field.3', 'Time to Travel', '{}'),
('140', '106', '319', '320', '3', 'com_tz_portfolio_plus.addon.21', 'Content - Form Builder', '{}'),
('141', '106', '321', '322', '3', 'com_tz_portfolio_plus.addon.22', 'Content - Video', '{}'),
('142', '106', '323', '324', '3', 'com_tz_portfolio_plus.addon.23', 'Content - Google Map', '{}'),
('143', '106', '325', '326', '3', 'com_tz_portfolio_plus.addon.24', 'Media Type - Image Gallery', '{}'),
('144', '8', '58', '67', '2', 'com_content.fieldgroup.1', 'Tour Information', '{}'),
('145', '144', '59', '60', '3', 'com_content.field.1', 'Destination', '{}'),
('146', '144', '61', '62', '3', 'com_content.field.2', 'Language', '{}'),
('147', '144', '63', '64', '3', 'com_content.field.3', 'Time to Travel', '{}'),
('148', '8', '68', '71', '2', 'com_content.category.8', 'Tours', '{}'),
('149', '148', '69', '70', '3', 'com_content.article.11', 'High-Speed Thames River RIB Cruise in London', '{}'),
('150', '144', '65', '66', '3', 'com_content.field.4', 'Type', '{}'),
('151', '18', '180', '181', '2', 'com_modules.module.117', 'Search', '{}'),
('152', '106', '327', '328', '3', 'com_tz_portfolio_plus.addon.25', 'Content - Gallery', '{}'),
('153', '104', '291', '292', '3', 'com_tz_portfolio_plus.field.4', 'Duration', '{}'),
('154', '104', '293', '294', '3', 'com_tz_portfolio_plus.field.5', 'Budget', '{}'),
('155', '104', '295', '296', '3', 'com_tz_portfolio_plus.field.6', 'Type', '{}'),
('156', '18', '182', '183', '2', 'com_modules.module.118', 'Search', '{}'),
('157', '106', '329', '330', '3', 'com_tz_portfolio_plus.addon.26', 'Content - Accordion', '{}'),
('158', '109', '258', '259', '3', 'com_tz_portfolio_plus.article.2', 'Cross-Country Skiing', '{}'),
('159', '109', '260', '261', '3', 'com_tz_portfolio_plus.article.3', 'Cross-Country Skiing In Valdres (2)', '{}'),
('160', '109', '262', '263', '3', 'com_tz_portfolio_plus.article.4', 'Mount Toubkal Trek', '{}'),
('161', '109', '264', '265', '3', 'com_tz_portfolio_plus.article.5', 'Jomolhari Base Camp', '{}'),
('162', '109', '266', '267', '3', 'com_tz_portfolio_plus.article.6', 'Faroe Islands Break', '{}'),
('163', '109', '268', '269', '3', 'com_tz_portfolio_plus.article.7', 'Faroe Islands Drive', '{}'),
('164', '109', '270', '271', '3', 'com_tz_portfolio_plus.article.8', 'Cycling theTulip Fields', '{}'),
('165', '18', '184', '185', '2', 'com_modules.module.119', 'Tags', '{}'),
('166', '18', '186', '187', '2', 'com_modules.module.120', 'About Travelami', '{}'),
('167', '109', '272', '273', '3', 'com_tz_portfolio_plus.article.9', 'Shikoku Pilgrim Trail', '{}'),
('168', '109', '274', '275', '3', 'com_tz_portfolio_plus.article.10', 'Walking In East Crete', '{}'),
('169', '109', '276', '277', '3', 'com_tz_portfolio_plus.article.11', 'Ultimate Northern Greece', '{}'),
('170', '109', '278', '279', '3', 'com_tz_portfolio_plus.article.12', 'Danube By Bike And Boat', '{}'),
('171', '18', '188', '189', '2', 'com_modules.module.121', 'Filter - Main Top - Dark bg', '{}'),
('172', '109', '280', '281', '3', 'com_tz_portfolio_plus.article.13', 'Milngavie To Inverarnan', '{}'),
('173', '18', '190', '191', '2', 'com_modules.module.122', 'mod_tz_portfolio_plus_carousel', '{}'),
('174', '18', '192', '193', '2', 'com_modules.module.123', 'Most Popular Tour', '{}'),
('175', '18', '194', '195', '2', 'com_modules.module.124', 'Astroid Menu - Mobile', '{}'),
('176', '18', '196', '197', '2', 'com_modules.module.125', 'Filter - Main Top - Light Bg', '{}'),
('177', '1', '337', '338', '1', 'com_akeebabackup', 'com_akeebabackup', '{}'),
('178', '18', '198', '199', '2', 'com_modules.module.126', 'Travelami Ltd', '{}'),
('180', '18', '200', '201', '2', 'com_modules.module.127', 'Astroid Layout Module', '{}');
/**ABDB**/CREATE TABLE `#__update_sites_extensions` (
  `update_site_id` int(11) NOT NULL DEFAULT 0,
  `extension_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`update_site_id`,`extension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Links extensions to update sites';
/**ABDB**/INSERT INTO `#__update_sites_extensions`  VALUES 
('1', '237'),
('2', '238'),
('3', '24'),
('5', '246'),
('7', '249'),
('19', '270'),
('20', '273'),
('23', '243'),
('23', '244'),
('23', '245'),
('23', '278'),
('23', '279'),
('23', '282');
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupid` int(11) NOT NULL DEFAULT 0,
  `images` text DEFAULT NULL,
  `template_id` int(10) unsigned NOT NULL DEFAULT 0,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0,
  `lft` int(11) NOT NULL DEFAULT 0,
  `rgt` int(11) NOT NULL DEFAULT 0,
  `level` int(10) unsigned NOT NULL DEFAULT 0,
  `path` varchar(255) NOT NULL DEFAULT '',
  `extension` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `params` text DEFAULT NULL,
  `metadesc` varchar(1024) NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) NOT NULL COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL DEFAULT '',
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/**ABDB**/INSERT INTO `#__tz_portfolio_plus_categories`  VALUES 
('1', '0', '', '0', '0', '0', '0', '3', '0', '', 'system', 'ROOT', 'root', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{}', '', '', '', '123', '2011-01-01 00:00:01', '0', '0000-00-00 00:00:00', '0', '*', '1'),
('2', '1', '', '0', '109', '1', '1', '2', '1', 'tours', 'com_tz_portfolio_plus', 'Tours', 'tours', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"inheritFrom\":\"0\",\"show_cat_title\":\"1\",\"cat_link_titles\":\"1\",\"show_cat_intro\":\"1\",\"show_cat_category\":\"0\",\"cat_link_category\":\"1\",\"show_cat_parent_category\":\"0\",\"cat_link_parent_category\":\"1\",\"show_cat_author\":\"0\",\"cat_link_author\":\"1\",\"show_cat_create_date\":\"0\",\"show_cat_modify_date\":\"0\",\"show_cat_publish_date\":\"0\",\"show_cat_readmore\":\"0\",\"show_cat_hits\":\"0\",\"show_cat_tags\":\"0\",\"cat_link_tag\":\"1\",\"show_cat_icons\":\"1\",\"show_cat_print_icon\":\"0\",\"show_cat_field_image\":\"\",\"show_title\":\"1\",\"show_intro\":\"1\",\"show_category\":\"1\",\"link_category\":\"1\",\"show_parent_category\":\"1\",\"link_parent_category\":\"1\",\"show_author\":\"1\",\"link_author\":\"1\",\"show_create_date\":\"1\",\"show_modify_date\":\"1\",\"show_publish_date\":\"1\",\"show_hits\":\"1\",\"show_tags\":\"1\",\"link_tag\":\"1\",\"show_icons\":\"1\",\"show_print_icon\":\"1\",\"show_noauth\":\"0\",\"show_field_image\":\"\",\"show_about_author\":\"1\",\"show_gender_user\":\"1\",\"show_email_user\":\"1\",\"show_url_user\":\"1\",\"show_description_user\":\"1\",\"show_related_article\":\"1\",\"related_article_by\":\"tag\",\"related_limit\":\"5\",\"show_related_heading\":\"1\",\"related_heading\":\"\",\"show_related_title\":\"1\",\"show_related_featured\":\"1\",\"related_orderby\":\"rdate\",\"show_cat_vote\":\"\",\"show_vote\":\"\",\"form_builder_show\":\"\",\"mt_video_show\":\"\",\"mt_gallery_show\":\"\",\"mt_gallery_size\":\"\",\"mt_gallery_type\":\"\",\"mt_gallery_width\":\"\",\"mt_gallery_height\":\"\",\"mt_grid_image_title_position\":\"\",\"accordion_show\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\",\"mt_image_watermark_admin_options\":{\"mt_image_watermark\":\"\",\"mt_image_wtm_original_image\":\"\",\"mt_image_watermark_img_detail\":\"\",\"mt_image_watermark_stype\":\"\"},\"mt_cat_img_gallery_size\":\"\",\"mt_img_gallery_size\":\"\",\"mt_img_gallery_thumb_size\":\"\",\"mt_img_gallery_related_show_image\":\"\",\"mt_img_gallery_related_size\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '123', '2015-12-12 14:42:28', '123', '2024-05-06 08:47:00', '0', '*', '1');
/**ABDB**/CREATE TABLE `#__finder_links` (
  `link_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `route` varchar(400) NOT NULL,
  `title` varchar(400) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `indexdate` datetime NOT NULL,
  `md5sum` varchar(32) DEFAULT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 1,
  `state` int(11) NOT NULL DEFAULT 1,
  `access` int(11) NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL DEFAULT '',
  `publish_start_date` datetime DEFAULT NULL,
  `publish_end_date` datetime DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `list_price` double unsigned NOT NULL DEFAULT 0,
  `sale_price` double unsigned NOT NULL DEFAULT 0,
  `type_id` int(11) NOT NULL,
  `object` mediumblob DEFAULT NULL,
  PRIMARY KEY (`link_id`),
  KEY `idx_type` (`type_id`),
  KEY `idx_title` (`title`(100)),
  KEY `idx_md5` (`md5sum`),
  KEY `idx_url` (`url`(75)),
  KEY `idx_language` (`language`),
  KEY `idx_published_list` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`list_price`),
  KEY `idx_published_sale` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`sale_price`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__finder_links`  VALUES 
('1', 'index.php?option=com_content&view=article&id=1', 'index.php?option=com_content&view=article&id=1:10-sensational-hotel-baths-with-a-view&catid=2', '10 Sensational Hotel Baths With A View', ' Noka Camp’s five stilted villas, including one villa specially designed for families, are perched atop a 100ft cliff, overlooking the winding Palala River below and the endless bush ahead. ', '2024-04-02 02:31:06', '635c1ed7acbe2381fd7ad5cfccc24ad7', '1', '1', '1', '*', '2024-04-02 02:29:22', NULL, '2024-04-02 02:29:22', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:192:\" Noka Camp’s five stilted villas, including one villa specially designed for families, are perched atop a 100ft cliff, overlooking the winding Palala River below and the endless bush ahead. \";i:3;a:27:{s:2:\"id\";i:1;s:5:\"alias\";s:38:\"10 sensational hotel baths with a view\";s:7:\"summary\";s:199:\"<p>Noka Camp’s five stilted villas, including one villa specially designed for families, are perched atop a 100ft cliff, overlooking the winding Palala River below and the endless bush ahead.</p>\r\n\";s:4:\"body\";s:2324:\"\r\n<p>The villas are joined by the main lodge consisting of a dining room, bar, lounge area and sprawling outdoor terrace. The camp is entirely off-grid, self-generated all energy by a bespoke, 250m solar walkway.</p>\r\n<h2>The Olive Tree, Bath, Somerset, England</h2>\r\n<p>Small bells hang on the wall perhaps in homage to the Abbey bells, behind a white reception while the rest of the room has funky artworks, as does most of the hotel. Sometimes it’s Regency-style, sometimes faces obscured by a primary colour and bizarrely even animals dressed in military costumes. In much of the communal area, carpets are decorated with butterflies; sometimes there are prints and maps. A lot is going on.</p>\r\n<blockquote>\r\n<p>Imagine sinking into some bubbles looking out across an azure sea, or enjoying a soak with a chilled glass of champagne over a cityscape.</p>\r\n</blockquote>\r\n<p>Sure, there have always been tourists behaving badly ever since the first tourist existed. But, in an age where travel has become so easy and ubiquitous for so many for the first time, those problems have amplified a thousandfold. Destinations didn’t have the necessary infrastructure to handle the flood of tourists cheap travel brought.</p>\r\n<p>All rooms come with comfy Hypnos beds with luxury Egyptian cotton linen, spacious bathrooms, Nespresso coffee machines, highspeed Wi-Fi and several channels on a 40” flat-screen TV.  The mini-bar comes stocked with some drinks that are included in the room rate.</p>\r\n<h2>12 Apostles Hotel &amp; Spa, South Africa</h2>\r\n<ul>\r\n<li>World Nomads (for everyone below 70)</li>\r\n<li>Insure My Trip (for those over 70)</li>\r\n<li>Medjet (for additional repatriation coverage)</li>\r\n</ul>\r\n<p>As we yearn to reconnect with friends, family, and the world at large, I think that what we’ve gone through has also given many of us a chance to reflect on all the things we took for granted: the outdoors, community, neighborhood restaurants, and the arts.</p>\r\n<p>From flouting rules and refusing to wear a mask to hosting parties, coughing on others, and just generally being selfish, the pandemic has shown us that the world is filled with more assholes than we thought. But, despite all of that, when it comes to the future of travel, I think the pandemic is going to make it <em>better</em>.</p>\";s:6:\"images\";s:459:\"{\"image_intro\":\"images\\/alexander-ramsey-dBtWLliLt5k-unsplash.jpg#joomlaImage:\\/\\/local-images\\/alexander-ramsey-dBtWLliLt5k-unsplash.jpg?width=1380&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/alexander-ramsey-dBtWLliLt5k-unsplash.jpg#joomlaImage:\\/\\/local-images\\/alexander-ramsey-dBtWLliLt5k-unsplash.jpg?width=1380&height=900\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:2;s:10:\"created_by\";i:123;s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2024-04-02 02:31:06\";s:11:\"modified_by\";i:123;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":99:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"1\";s:9:\"show_hits\";s:1:\"1\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";s:20:\"astroid_article_type\";s:7:\"regular\";s:26:\"astroid_article_video_type\";s:7:\"youtube\";s:31:\"astroid_article_gallery_bullets\";s:1:\"1\";s:34:\"astroid_article_gallery_navigation\";s:1:\"1\";s:25:\"astroid_article_thumbnail\";s:1:\"1\";s:29:\"astroid_article_gallery_items\";a:0:{}s:28:\"astroid_article_audio_source\";s:10:\"soundcloud\";s:29:\"astroid_article_review_rating\";s:1:\"5\";s:32:\"astroid_article_review_criterias\";a:0:{}s:32:\"astroid_article_content_position\";s:11:\"above-title\";s:21:\"astroid_article_badge\";s:1:\"0\";s:26:\"astroid_article_badge_type\";s:1:\"2\";s:33:\"article_relatedposts_count_custom\";s:1:\"4\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"version\";i:4;s:8:\"ordering\";i:0;s:8:\"category\";s:13:\"Uncategorised\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:40:\"1:10-sensational-hotel-baths-with-a-view\";s:7:\"catslug\";s:15:\"2:uncategorised\";s:6:\"author\";s:13:\"Violet Michel\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:8:\"imageUrl\";s:139:\"images/alexander-ramsey-dBtWLliLt5k-unsplash.jpg#joomlaImage://local-images/alexander-ramsey-dBtWLliLt5k-unsplash.jpg?width=1380&height=900\";s:8:\"imageAlt\";s:0:\"\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2024-04-02 02:29:22\";i:10;N;i:11;s:93:\"index.php?option=com_content&view=article&id=1:10-sensational-hotel-baths-with-a-view&catid=2\";i:12;N;i:13;s:19:\"2024-04-02 02:29:22\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:3;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:13:\"Violet Michel\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:13:\"Uncategorised\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:7;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}}i:16;s:38:\"10 Sensational Hotel Baths With A View\";i:17;i:3;i:18;s:46:\"index.php?option=com_content&view=article&id=1\";}'),
('2', 'index.php?option=com_content&view=article&id=2', 'index.php?option=com_content&view=article&id=2:travel-guide-48-hours-in-dushanbe-tajikstan&catid=2', 'Travel Guide: 48 Hours In Dushanbe, Tajikstan ', ' Many travellers arrive in Dushanbe, the capital and gateway of Tajikistan, and dash off for an adventure, perhaps hiking in the Fann Mountains or driving along the famously dramatic Pamir Highway. ', '2024-05-07 02:49:00', '681b96bed76606d578b682ec84ec31c1', '1', '1', '1', '*', '2024-04-02 02:29:22', NULL, '2024-04-02 02:29:22', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:198:\" Many travellers arrive in Dushanbe, the capital and gateway of Tajikistan, and dash off for an adventure, perhaps hiking in the Fann Mountains or driving along the famously dramatic Pamir Highway. \";i:3;a:27:{s:2:\"id\";i:2;s:5:\"alias\";s:43:\"travel guide 48 hours in dushanbe tajikstan\";s:7:\"summary\";s:205:\"<p>Many travellers arrive in Dushanbe, the capital and gateway of Tajikistan, and dash off for an adventure, perhaps hiking in the Fann Mountains or driving along the famously dramatic Pamir Highway.</p>\r\n\";s:4:\"body\";s:2754:\"\r\n<p>Yet this vibrant city along the Varzob (Dushanbinka) River in the Gissar valley, in the southwest of the republic offers plenty to see in just 48 hours.</p>\r\n<p>Whether you are a hobbyist strolling a new city, a travel blogger looking to share spectacular sights with your readers, or a professional photographer looking for a new niche, the architecture around us all the time is exciting and varied subject.</p>\r\n<h2 class=\"wp-block-heading\"><strong>Take A Walk In A Park</strong></h2>\r\n<p>Small bells hang on the wall perhaps in homage to the Abbey bells, behind a white reception while the rest of the room has funky artworks, as does most of the hotel. Sometimes it’s Regency-style, sometimes faces obscured by a primary colour and bizarrely even animals dressed in military costumes. In much of the communal area, carpets are decorated with butterflies; sometimes there are prints and maps. A lot is going on.</p>\r\n<blockquote>\r\n<p>Look out in particular for the red and white parliament building and the iconic Rokhat Teahouse, which is a good spot to stop for a cuppa whilst you admire the intricately painted interior.  </p>\r\n</blockquote>\r\n<p>Sure, there have always been tourists behaving badly ever since the first tourist existed. But, in an age where travel has become so easy and ubiquitous for so many for the first time, those problems have amplified a thousandfold. Destinations didn’t have the necessary infrastructure to handle the flood of tourists cheap travel brought.</p>\r\n<p>All rooms come with comfy Hypnos beds with luxury Egyptian cotton linen, spacious bathrooms, Nespresso coffee machines, highspeed Wi-Fi and several channels on a 40” flat-screen TV.  The mini-bar comes stocked with some drinks that are included in the room rate.</p>\r\n<h2 class=\"wp-block-heading\"><strong>Discover The Past</strong></h2>\r\n<p><strong><img class=\"float-none\" src=\"images/david-edelstein-N4DbvTUDikw-unsplash.jpg\" width=\"1380\" height=\"900\"></strong></p>\r\n<ul>\r\n<li>World Nomads (for everyone below 70)</li>\r\n<li>Insure My Trip (for those over 70)</li>\r\n<li>Medjet (for additional repatriation coverage)</li>\r\n</ul>\r\n<p>As we yearn to reconnect with friends, family, and the world at large, I think that what we’ve gone through has also given many of us a chance to reflect on all the things we took for granted: the outdoors, community, neighborhood restaurants, and the arts.</p>\r\n<p>From flouting rules and refusing to wear a mask to hosting parties, coughing on others, and just generally being selfish, the pandemic has shown us that the world is filled with more assholes than we thought. But, despite all of that, when it comes to the future of travel, I think the pandemic is going to make it <em>better</em>.</p>\";s:6:\"images\";s:312:\"{\"image_intro\":\"images\\/daniela-cuevas-t7YycgAoVSw-unsplash.jpg#joomlaImage:\\/\\/local-images\\/daniela-cuevas-t7YycgAoVSw-unsplash.jpg?width=1380&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:2;s:10:\"created_by\";i:123;s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2024-05-07 02:49:00\";s:11:\"modified_by\";i:123;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":100:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"1\";s:9:\"show_hits\";s:1:\"1\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";s:20:\"astroid_article_type\";s:5:\"video\";s:26:\"astroid_article_video_type\";s:7:\"youtube\";s:25:\"astroid_article_video_url\";s:43:\"https://www.youtube.com/watch?v=mNzenfB3OuY\";s:31:\"astroid_article_gallery_bullets\";s:1:\"1\";s:34:\"astroid_article_gallery_navigation\";s:1:\"1\";s:25:\"astroid_article_thumbnail\";s:1:\"1\";s:29:\"astroid_article_gallery_items\";a:0:{}s:28:\"astroid_article_audio_source\";s:10:\"soundcloud\";s:29:\"astroid_article_review_rating\";s:1:\"5\";s:32:\"astroid_article_review_criterias\";a:0:{}s:32:\"astroid_article_content_position\";s:11:\"above-title\";s:21:\"astroid_article_badge\";s:1:\"0\";s:26:\"astroid_article_badge_type\";s:1:\"2\";s:33:\"article_relatedposts_count_custom\";s:1:\"4\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"version\";i:6;s:8:\"ordering\";i:2;s:8:\"category\";s:13:\"Uncategorised\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:45:\"2:travel-guide-48-hours-in-dushanbe-tajikstan\";s:7:\"catslug\";s:15:\"2:uncategorised\";s:6:\"author\";s:9:\"Leo Ethan\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:8:\"imageUrl\";s:135:\"images/daniela-cuevas-t7YycgAoVSw-unsplash.jpg#joomlaImage://local-images/daniela-cuevas-t7YycgAoVSw-unsplash.jpg?width=1380&height=900\";s:8:\"imageAlt\";s:0:\"\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2024-04-02 02:29:22\";i:10;N;i:11;s:98:\"index.php?option=com_content&view=article&id=2:travel-guide-48-hours-in-dushanbe-tajikstan&catid=2\";i:12;N;i:13;s:19:\"2024-04-02 02:29:22\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:3;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:9:\"Leo Ethan\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:12;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:13:\"Uncategorised\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:7;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}}i:16;s:46:\"Travel Guide: 48 Hours In Dushanbe, Tajikstan \";i:17;i:3;i:18;s:46:\"index.php?option=com_content&view=article&id=2\";}'),
('3', 'index.php?option=com_content&view=article&id=3', 'index.php?option=com_content&view=article&id=3:restaurant-review-the-olive-tree-bath-somerset-england&catid=2', 'Restaurant Review: The Olive Tree, Bath, Somerset, England', ' The Olive Tree restaurant in Bath is in a basement on Russell Street. That sounds eerie, but actually, this hidden-away restaurant has a fine provenance, on at least two counts. ', '2024-05-07 02:49:33', 'a28035edc167baaaba259a60d5ecfa39', '1', '1', '1', '*', '2024-04-02 02:29:22', NULL, '2024-04-02 02:29:22', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:179:\" The Olive Tree restaurant in Bath is in a basement on Russell Street. That sounds eerie, but actually, this hidden-away restaurant has a fine provenance, on at least two counts. \";i:3;a:25:{s:2:\"id\";i:3;s:5:\"alias\";s:54:\"restaurant review the olive tree bath somerset england\";s:7:\"summary\";s:186:\"<p>The Olive Tree restaurant in Bath is in a basement on Russell Street. That sounds eerie, but actually, this hidden-away restaurant has a fine provenance, on at least two counts.</p>\r\n\";s:4:\"body\";s:2070:\"\r\n<p>It’s an easy yet slightly poised ambiance at The Olive Tree restaurant. Diners talk in hushed voices while their facial grimaces show reverence and subdued delight. Lighting is dimmed, walls are in a shade of olive with simple artwork, with a feature wall on one side, floors and tables are of wood, with chairs with black or olive green upholstery.</p>\r\n<h2>Ambience At The Olive Tree Restaurant</h2>\r\n<p>Small bells hang on the wall perhaps in homage to the Abbey bells, behind a white reception while the rest of the room has funky artworks, as does most of the hotel. Sometimes it’s Regency-style, sometimes faces obscured by a primary colour and bizarrely even animals dressed in military costumes. In much of the communal area, carpets are decorated with butterflies; sometimes there are prints and maps. A lot is going on.</p>\r\n<ul>\r\n<li>Always Use a Tripod</li>\r\n<li>Composition for Building Photography</li>\r\n<li>Control Perspective</li>\r\n</ul>\r\n<p>Whether you are a hobbyist strolling a new city, a travel blogger looking to share spectacular sights with your readers, or a professional photographer looking for a new niche, the architecture around us all the time is an exciting and varied subject.</p>\r\n<h2>Food &amp; Drink</h2>\r\n<blockquote>\r\n<p><em>The biggest mistake you can make in architecture photos is to snap and go, with little planning or forethought. Take your time and exercise your creative grey cells.</em></p>\r\n</blockquote>\r\n<p>As we yearn to reconnect with friends, family, and the world at large, I think that what we’ve gone through has also given many of us a chance to reflect on all the things we took for granted: the outdoors, community, neighborhood restaurants, and the arts.</p>\r\n<p>From flouting rules and refusing to wear a mask to hosting parties, coughing on others, and just generally being selfish, the pandemic has shown us that the world is filled with more assholes than we thought. But, despite all of that, when it comes to the future of travel, I think the pandemic is going to make it <em>better</em>.</p>\";s:6:\"images\";s:173:\"{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:2;s:10:\"created_by\";i:123;s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2024-05-07 02:49:33\";s:11:\"modified_by\";i:123;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":99:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"1\";s:9:\"show_hits\";s:1:\"1\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";s:20:\"astroid_article_type\";s:7:\"gallery\";s:26:\"astroid_article_video_type\";s:7:\"youtube\";s:31:\"astroid_article_gallery_bullets\";s:1:\"1\";s:34:\"astroid_article_gallery_navigation\";s:1:\"1\";s:25:\"astroid_article_thumbnail\";s:1:\"1\";s:29:\"astroid_article_gallery_items\";a:3:{s:30:\"astroid_article_gallery_items0\";a:3:{s:5:\"title\";s:0:\"\";s:5:\"image\";s:127:\"images/drif-riadh-YpkuRn54y4w-unsplash.jpg#joomlaImage://local-images/drif-riadh-YpkuRn54y4w-unsplash.jpg?width=1380&height=900\";s:11:\"description\";s:0:\"\";}s:30:\"astroid_article_gallery_items1\";a:3:{s:5:\"title\";s:0:\"\";s:5:\"image\";s:131:\"images/felix-rostig-UmV2wr-Vbq8-unsplash.jpg#joomlaImage://local-images/felix-rostig-UmV2wr-Vbq8-unsplash.jpg?width=1380&height=900\";s:11:\"description\";s:0:\"\";}s:30:\"astroid_article_gallery_items2\";a:3:{s:5:\"title\";s:0:\"\";s:5:\"image\";s:131:\"images/kalen-emsley-7bwQXzbF6KE-unsplash.jpg#joomlaImage://local-images/kalen-emsley-7bwQXzbF6KE-unsplash.jpg?width=1380&height=900\";s:11:\"description\";s:0:\"\";}}s:28:\"astroid_article_audio_source\";s:10:\"soundcloud\";s:29:\"astroid_article_review_rating\";s:1:\"5\";s:32:\"astroid_article_review_criterias\";a:0:{}s:32:\"astroid_article_content_position\";s:11:\"above-title\";s:21:\"astroid_article_badge\";s:1:\"0\";s:26:\"astroid_article_badge_type\";s:1:\"2\";s:33:\"article_relatedposts_count_custom\";s:1:\"4\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"version\";i:6;s:8:\"ordering\";i:3;s:8:\"category\";s:13:\"Uncategorised\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:56:\"3:restaurant-review-the-olive-tree-bath-somerset-england\";s:7:\"catslug\";s:15:\"2:uncategorised\";s:6:\"author\";s:9:\"Leo Ethan\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2024-04-02 02:29:22\";i:10;N;i:11;s:109:\"index.php?option=com_content&view=article&id=3:restaurant-review-the-olive-tree-bath-somerset-england&catid=2\";i:12;N;i:13;s:19:\"2024-04-02 02:29:22\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:3;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:9:\"Leo Ethan\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:12;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:13:\"Uncategorised\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:7;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}}i:16;s:58:\"Restaurant Review: The Olive Tree, Bath, Somerset, England\";i:17;i:3;i:18;s:46:\"index.php?option=com_content&view=article&id=3\";}'),
('4', 'index.php?option=com_content&view=article&id=4', 'index.php?option=com_content&view=article&id=4:whirlwind-trip-to-historical-tunisia&catid=2', 'Whirlwind Trip To Historical Tunisia', ' The capital Tunis’ main drag is the Avenue de France looking glorious with arcades modeled after those of Rivoli Street (rue de Rivoli) in Paris. ', '2024-04-02 02:45:58', '094c89f5d7d6a377213fb4dd1addd8a5', '1', '1', '1', '*', '2024-04-02 02:29:22', NULL, '2024-04-02 02:29:22', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:149:\" The capital Tunis’ main drag is the Avenue de France looking glorious with arcades modeled after those of Rivoli Street (rue de Rivoli) in Paris. \";i:3;a:27:{s:2:\"id\";i:4;s:5:\"alias\";s:36:\"whirlwind trip to historical tunisia\";s:7:\"summary\";s:158:\"<p>The capital Tunis’ main drag is the Avenue de France looking glorious with arcades modeled after those of Rivoli Street (rue de Rivoli) in Paris. </p>\r\n\";s:4:\"body\";s:2590:\"\r\n<p>The Avenue meets with Avenida Habib Bourguiba, named after Bourguiba considered the father of the nation loved for educating women and outlawing polygamy. The long stretch is abundant with flower sellers, while the central walkway, with its street musicians and vendors, has more than a whisper of France’s Champs Elysee.  </p>\r\n<h2 class=\"wp-block-heading\">Tunis, The Capital</h2>\r\n<p>Small bells hang on the wall perhaps in homage to the Abbey bells, behind a white reception while the rest of the room has funky artworks, as does most of the hotel. Sometimes it’s Regency-style, sometimes faces obscured by a primary colour and bizarrely even animals dressed in military costumes. In much of the communal area, carpets are decorated with butterflies; sometimes there are prints and maps. A lot is going on.</p>\r\n<blockquote>\r\n<p>Getting inspiration from other photographers through their online photography portfolios or social media posts only goes so far. </p>\r\n</blockquote>\r\n<p>Sure, there have always been tourists behaving badly ever since the first tourist existed. But, in an age where travel has become so easy and ubiquitous for so many for the first time, those problems have amplified a thousandfold. Destinations didn’t have the necessary infrastructure to handle the flood of tourists cheap travel brought.</p>\r\n<p>All rooms come with comfy Hypnos beds with luxury Egyptian cotton linen, spacious bathrooms, <strong>Nespresso coffee machines</strong>, highspeed Wi-Fi and several channels on a 40” flat-screen TV.  The mini-bar comes stocked with some drinks that are included in the room rate.</p>\r\n<h2>Historic National Theatre</h2>\r\n<p><img class=\"float-none\" src=\"images/garrett-parker-DlkF4-dbCOU-unsplash.jpg\" width=\"1380\" height=\"900\"></p>\r\n<ul>\r\n<li>World Nomads (for everyone below 70)</li>\r\n<li>Insure My Trip (for those over 70)</li>\r\n<li style=\"font-style: italic;\"><em>Medjet (for additional repatriation coverage)</em></li>\r\n</ul>\r\n<p>As we yearn to reconnect with friends, family, and the world at large, I think that what we’ve gone through has also given many of us a chance to reflect on all the things we took for granted: the outdoors, community, neighborhood restaurants, and the arts.</p>\r\n<p>From flouting rules and refusing to wear a mask to hosting parties, coughing on others, and just generally being selfish, the pandemic has shown us that the world is filled with more assholes than we thought. But, despite all of that, when it comes to the future of travel, I think the pandemic is going to make it <em>better</em>.</p>\";s:6:\"images\";s:302:\"{\"image_intro\":\"images\\/hanson-lu-_8EFj6ISA08-unsplash.jpg#joomlaImage:\\/\\/local-images\\/hanson-lu-_8EFj6ISA08-unsplash.jpg?width=1380&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:2;s:10:\"created_by\";i:123;s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2024-04-02 02:45:58\";s:11:\"modified_by\";i:123;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":100:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"1\";s:9:\"show_hits\";s:1:\"1\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";s:20:\"astroid_article_type\";s:5:\"audio\";s:26:\"astroid_article_video_type\";s:7:\"youtube\";s:31:\"astroid_article_gallery_bullets\";s:1:\"1\";s:34:\"astroid_article_gallery_navigation\";s:1:\"1\";s:25:\"astroid_article_thumbnail\";s:1:\"1\";s:29:\"astroid_article_gallery_items\";a:0:{}s:28:\"astroid_article_audio_source\";s:10:\"soundcloud\";s:32:\"astroid_article_audio_soundcloud\";s:940:\"<iframe width=\"100%\" height=\"300\" scrolling=\"no\" frameborder=\"no\" allow=\"autoplay\" src=\"https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/218073744&color=%23ff5500&auto_play=false&hide_related=false&show_comments=true&show_user=true&show_reposts=false&show_teaser=true&visual=true\"></iframe><div style=\"font-size: 10px; color: #cccccc;line-break: anywhere;word-break: normal;overflow: hidden;white-space: nowrap;text-overflow: ellipsis; font-family: Interstate,Lucida Grande,Lucida Sans Unicode,Lucida Sans,Garuda,Verdana,Tahoma,sans-serif;font-weight: 100;\"><a href=\"https://soundcloud.com/blakeshelton\" title=\"Blake Shelton\" target=\"_blank\" style=\"color: #cccccc; text-decoration: none;\">Blake Shelton</a> · <a href=\"https://soundcloud.com/blakeshelton/home-feat-michael-buble-1\" title=\"Home (feat. Michael Buble)\" target=\"_blank\" style=\"color: #cccccc; text-decoration: none;\">Home (feat. Michael Buble)</a></div>\";s:29:\"astroid_article_review_rating\";s:1:\"5\";s:32:\"astroid_article_review_criterias\";a:0:{}s:32:\"astroid_article_content_position\";s:11:\"above-title\";s:21:\"astroid_article_badge\";s:1:\"0\";s:26:\"astroid_article_badge_type\";s:1:\"2\";s:33:\"article_relatedposts_count_custom\";s:1:\"4\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"version\";i:5;s:8:\"ordering\";i:0;s:8:\"category\";s:13:\"Uncategorised\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:38:\"4:whirlwind-trip-to-historical-tunisia\";s:7:\"catslug\";s:15:\"2:uncategorised\";s:6:\"author\";s:13:\"Violet Michel\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:8:\"imageUrl\";s:125:\"images/hanson-lu-_8EFj6ISA08-unsplash.jpg#joomlaImage://local-images/hanson-lu-_8EFj6ISA08-unsplash.jpg?width=1380&height=900\";s:8:\"imageAlt\";s:0:\"\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2024-04-02 02:29:22\";i:10;N;i:11;s:91:\"index.php?option=com_content&view=article&id=4:whirlwind-trip-to-historical-tunisia&catid=2\";i:12;N;i:13;s:19:\"2024-04-02 02:29:22\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:3;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:13:\"Violet Michel\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:13:\"Uncategorised\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:7;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}}i:16;s:36:\"Whirlwind Trip To Historical Tunisia\";i:17;i:3;i:18;s:46:\"index.php?option=com_content&view=article&id=4\";}'),
('5', 'index.php?option=com_content&view=article&id=5', 'index.php?option=com_content&view=article&id=5:5-things-we-know-about-flying-this-summer&catid=2', '5 Things We Know About Flying This Summer', ' Small bells hang on the wall perhaps in homage to the Abbey bells, behind a white reception while the rest of the room has funky artworks, as does most of the hotel. ', '2024-04-02 02:51:54', '62f0928225d5b4259b36dfa0056cb1c3', '1', '1', '1', '*', '2024-04-02 02:29:22', NULL, '2024-04-02 02:29:22', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:167:\" Small bells hang on the wall perhaps in homage to the Abbey bells, behind a white reception while the rest of the room has funky artworks, as does most of the hotel. \";i:3;a:27:{s:2:\"id\";i:5;s:5:\"alias\";s:41:\"5 things we know about flying this summer\";s:7:\"summary\";s:174:\"<p>Small bells hang on the wall perhaps in homage to the Abbey bells, behind a white reception while the rest of the room has funky artworks, as does most of the hotel.</p>\r\n\";s:4:\"body\";s:2444:\"\r\n<p>According to the airline industry group Airlines for America, passenger volume on U.S. carriers was down 53 percent in mid-March compared to pre-Covid-19 levels, but up from the darkest days of the pandemic, when it bottomed out below 90 percent.</p>\r\n<p>With the soft bounce, only Delta Air Lines has continued to block middle seats through April. It would not comment on an extension. (Alaska Airlines is keeping middle seats open in its Premium Class through May 31).</p>\r\n<h2>Headed Into Low-Cost Headwinds</h2>\r\n<p>Sometimes it’s Regency-style, sometimes faces obscured by a primary colour and bizarrely even animals dressed in military costumes. In much of the communal area, carpets are decorated with butterflies; sometimes there are prints and maps. A lot is going on.</p>\r\n<blockquote>\r\n<p>Getting inspiration from other photographers through their online photography portfolios or social media posts only goes so far. </p>\r\n</blockquote>\r\n<p>Sure, there have always been tourists behaving badly ever since the first tourist existed. But, in an age where travel has become so easy and ubiquitous for so many for the first time, those problems have amplified a thousandfold. Destinations didn’t have the necessary infrastructure to handle the flood of tourists cheap travel brought.</p>\r\n<p>All rooms come with comfy Hypnos beds with luxury Egyptian cotton linen, spacious bathrooms, Nespresso coffee machines, highspeed Wi-Fi and several channels on a 40” flat-screen TV.  The mini-bar comes stocked with some drinks that are included in the room rate.</p>\r\n<h2>The Skies Will Be Busier, The Planes Fuller</h2>\r\n<ul>\r\n<li>World Nomads (for everyone below 70)</li>\r\n<li>Insure My Trip (for those over 70)</li>\r\n<li style=\"font-style: italic;\"><em>Medjet (for additional repatriation coverage)</em></li>\r\n</ul>\r\n<p>As we yearn to reconnect with friends, family, and the world at large, I think that what we’ve gone through has also given many of us a chance to reflect on all the things we took for granted: the outdoors, community, neighborhood restaurants, and the arts.</p>\r\n<p>From flouting rules and refusing to wear a mask to hosting parties, coughing on others, and just generally being selfish, the pandemic has shown us that the world is filled with more assholes than we thought. But, despite all of that, when it comes to the future of travel, I think the pandemic is going to make it <em>better</em>.</p>\";s:6:\"images\";s:312:\"{\"image_intro\":\"images\\/ibrahim-rifath-Y6tBl0pTe-g-unsplash.jpg#joomlaImage:\\/\\/local-images\\/ibrahim-rifath-Y6tBl0pTe-g-unsplash.jpg?width=1380&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:2;s:10:\"created_by\";i:123;s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2024-04-02 02:51:54\";s:11:\"modified_by\";i:123;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":101:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"1\";s:9:\"show_hits\";s:1:\"1\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";s:20:\"astroid_article_type\";s:5:\"quote\";s:26:\"astroid_article_video_type\";s:7:\"youtube\";s:31:\"astroid_article_gallery_bullets\";s:1:\"1\";s:34:\"astroid_article_gallery_navigation\";s:1:\"1\";s:25:\"astroid_article_thumbnail\";s:1:\"1\";s:29:\"astroid_article_gallery_items\";a:0:{}s:28:\"astroid_article_audio_source\";s:10:\"soundcloud\";s:29:\"astroid_article_review_rating\";s:1:\"5\";s:32:\"astroid_article_review_criterias\";a:0:{}s:26:\"astroid_article_quote_text\";s:119:\"The biggest thing you can do to make your architecture photos stand out is to strive to make visually compelling images\";s:28:\"astroid_article_quote_author\";s:13:\"David Hension\";s:32:\"astroid_article_content_position\";s:11:\"above-title\";s:21:\"astroid_article_badge\";s:1:\"0\";s:26:\"astroid_article_badge_type\";s:1:\"2\";s:33:\"article_relatedposts_count_custom\";s:1:\"4\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"version\";i:4;s:8:\"ordering\";i:0;s:8:\"category\";s:13:\"Uncategorised\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:43:\"5:5-things-we-know-about-flying-this-summer\";s:7:\"catslug\";s:15:\"2:uncategorised\";s:6:\"author\";s:13:\"Violet Michel\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:8:\"imageUrl\";s:135:\"images/ibrahim-rifath-Y6tBl0pTe-g-unsplash.jpg#joomlaImage://local-images/ibrahim-rifath-Y6tBl0pTe-g-unsplash.jpg?width=1380&height=900\";s:8:\"imageAlt\";s:0:\"\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2024-04-02 02:29:22\";i:10;N;i:11;s:96:\"index.php?option=com_content&view=article&id=5:5-things-we-know-about-flying-this-summer&catid=2\";i:12;N;i:13;s:19:\"2024-04-02 02:29:22\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:3;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:13:\"Violet Michel\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:13:\"Uncategorised\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:7;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}}i:16;s:41:\"5 Things We Know About Flying This Summer\";i:17;i:3;i:18;s:46:\"index.php?option=com_content&view=article&id=5\";}'),
('6', 'index.php?option=com_content&view=article&id=6', 'index.php?option=com_content&view=article&id=6:a-beginner-s-guide-to-architecture-photography&catid=2', 'A Beginner’s Guide To Architecture Photography', ' Architecture images grace the pages of magazines and fill travel albums all over the world. If architects do their job right, it only fits that their work would catch the eye of creative photographers. ', '2024-04-02 02:56:53', '69bc22448d27b3d4c466b54436f00b7d', '1', '1', '1', '*', '2024-04-02 02:29:22', NULL, '2024-04-02 02:29:22', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:203:\" Architecture images grace the pages of magazines and fill travel albums all over the world. If architects do their job right, it only fits that their work would catch the eye of creative photographers. \";i:3;a:27:{s:2:\"id\";i:6;s:5:\"alias\";s:46:\"a beginner s guide to architecture photography\";s:7:\"summary\";s:210:\"<p>Architecture images grace the pages of magazines and fill travel albums all over the world. If architects do their job right, it only fits that their work would catch the eye of creative photographers.</p>\r\n\";s:4:\"body\";s:2325:\"\r\n<p>The villas are joined by the main lodge consisting of a dining room, bar, lounge area and sprawling outdoor terrace. The camp is entirely off-grid, <strong>self-generated all energy by a bespoke</strong>, 250m solar walkway.</p>\r\n<h2>Camera Equipment For Architecture</h2>\r\n<ul>\r\n<li>World Nomads (for everyone below 70)</li>\r\n<li>Insure My Trip (for those over 70)</li>\r\n<li>Medjet (for additional repatriation coverage)</li>\r\n</ul>\r\n<p>If you follow the tips below, you will avoid many of the most common mistakes while taking architecture photos. The biggest things to keep in mind are avoiding getting bogged down in technicalities and instead worry more about the basics of good photography like composition, lighting, and creating a connection with the viewer.</p>\r\n<p>When choosing lenses, think about the distortion that some of your lenses will cause and work to avoid it. Finally, be sure to spend some time considering how you want to present the building by thinking about the best time of day for the best light. </p>\r\n<h2>What Is Architecture Photography?</h2>\r\n<p><em>Small bells hang on the wall perhaps in homage to the Abbey bells</em>, behind a white reception while the rest of the room has funky artworks, as does most of the hotel. Sometimes it’s Regency-style, sometimes faces obscured by a primary colour and bizarrely even animals dressed in military costumes. In much of the communal area, carpets are decorated with butterflies; sometimes there are prints and maps. A lot is going on.</p>\r\n<blockquote>\r\n<p>Imagine sinking into some bubbles looking out across an azure sea, or enjoying a soak with a chilled glass of champagne over a cityscape.</p>\r\n</blockquote>\r\n<p>Sure, there have always been tourists behaving badly ever since the first tourist existed. But, in an age where travel has become so easy and ubiquitous for so many for the first time, those problems have amplified a thousandfold. Destinations didn’t have the necessary infrastructure to handle the flood of tourists cheap travel brought.</p>\r\n<p>All rooms come with comfy Hypnos beds with luxury Egyptian cotton linen, spacious bathrooms, Nespresso coffee machines, highspeed Wi-Fi and several channels on a 40” flat-screen TV.  The mini-bar comes stocked with some drinks that are included in the room rate.</p>\";s:6:\"images\";s:459:\"{\"image_intro\":\"images\\/julian-timmerman-Fn27DlI8bZ8-unsplash.jpg#joomlaImage:\\/\\/local-images\\/julian-timmerman-Fn27DlI8bZ8-unsplash.jpg?width=1380&height=921\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/julian-timmerman-Fn27DlI8bZ8-unsplash.jpg#joomlaImage:\\/\\/local-images\\/julian-timmerman-Fn27DlI8bZ8-unsplash.jpg?width=1380&height=921\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:2;s:10:\"created_by\";i:123;s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2024-04-02 02:56:53\";s:11:\"modified_by\";i:123;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":99:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"1\";s:9:\"show_hits\";s:1:\"1\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";s:20:\"astroid_article_type\";s:7:\"regular\";s:26:\"astroid_article_video_type\";s:7:\"youtube\";s:31:\"astroid_article_gallery_bullets\";s:1:\"1\";s:34:\"astroid_article_gallery_navigation\";s:1:\"1\";s:25:\"astroid_article_thumbnail\";s:1:\"1\";s:29:\"astroid_article_gallery_items\";a:0:{}s:28:\"astroid_article_audio_source\";s:10:\"soundcloud\";s:29:\"astroid_article_review_rating\";s:1:\"5\";s:32:\"astroid_article_review_criterias\";a:0:{}s:32:\"astroid_article_content_position\";s:11:\"above-title\";s:21:\"astroid_article_badge\";s:1:\"0\";s:26:\"astroid_article_badge_type\";s:1:\"2\";s:33:\"article_relatedposts_count_custom\";s:1:\"4\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"version\";i:5;s:8:\"ordering\";i:0;s:8:\"category\";s:13:\"Uncategorised\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:48:\"6:a-beginner-s-guide-to-architecture-photography\";s:7:\"catslug\";s:15:\"2:uncategorised\";s:6:\"author\";s:13:\"Violet Michel\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:8:\"imageUrl\";s:139:\"images/julian-timmerman-Fn27DlI8bZ8-unsplash.jpg#joomlaImage://local-images/julian-timmerman-Fn27DlI8bZ8-unsplash.jpg?width=1380&height=921\";s:8:\"imageAlt\";s:0:\"\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2024-04-02 02:29:22\";i:10;N;i:11;s:101:\"index.php?option=com_content&view=article&id=6:a-beginner-s-guide-to-architecture-photography&catid=2\";i:12;N;i:13;s:19:\"2024-04-02 02:29:22\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:3;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:13:\"Violet Michel\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:13:\"Uncategorised\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:7;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}}i:16;s:48:\"A Beginner’s Guide To Architecture Photography\";i:17;i:3;i:18;s:46:\"index.php?option=com_content&view=article&id=6\";}'),
('7', 'index.php?option=com_content&view=article&id=7', 'index.php?option=com_content&view=article&id=7:what-to-do-on-a-weekend-in-istanbul-tuerkiye&catid=2', 'What To Do On A Weekend In Istanbul, Türkiye', ' Lighting is dimmed, walls are in a shade of olive with simple artwork, with a feature wall on one side, floors and tables are of wood, with chairs with black or olive green upholstery. ', '2024-04-02 03:09:21', '35bb7532b4de1c2eaaaf8fb9689cb630', '1', '1', '1', '*', '2024-04-02 02:29:22', NULL, '2024-04-02 02:29:22', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:186:\" Lighting is dimmed, walls are in a shade of olive with simple artwork, with a feature wall on one side, floors and tables are of wood, with chairs with black or olive green upholstery. \";i:3;a:27:{s:2:\"id\";i:7;s:5:\"alias\";s:44:\"what to do on a weekend in istanbul tuerkiye\";s:7:\"summary\";s:193:\"<p>Lighting is dimmed, walls are in a shade of olive with simple artwork, with a feature wall on one side, floors and tables are of wood, with chairs with black or olive green upholstery.</p>\r\n\";s:4:\"body\";s:1784:\"\r\n<p>The villas are joined by the main lodge consisting of a dining room, bar, lounge area and sprawling outdoor terrace. The camp is entirely off-grid, <strong>self-generated all energy by a bespoke</strong>, 250m solar walkway.</p>\r\n<h2><strong>Mistake #1: Wildlife Baiting</strong> </h2>\r\n<ul>\r\n<li>World Nomads (for everyone below 70)</li>\r\n<li>Insure My Trip (for those over 70)</li>\r\n<li>Medjet (for additional repatriation coverage)</li>\r\n</ul>\r\n<p>This one is less about how you make the images and more about how you share them with the world. In the last couple of years, experts have expressed growing concerns over the consequences of geotagging photos on social media; in 2018, for instance, the Jackson Hole Travel &amp; Tourism Board urged visitors to stop tagging their locations.</p>\r\n<h2><strong>Mistake #2: Ill-Considered Use Of Flash </strong></h2>\r\n<p><em>Small bells hang on the wall perhaps in homage to the Abbey bells</em>, behind a white reception while the rest of the room has funky artworks, as does most of the hotel. </p>\r\n<blockquote>\r\n<p>In stylish Taksim looking dapper with its many art deco buildings, we popped into Kismet by Milka in Bebek whose quaint jewellery designs are worn by celebrities worldwide.</p>\r\n</blockquote>\r\n<p>Sure, there have always been tourists behaving badly ever since the first tourist existed. But, in an age where travel has become so easy and ubiquitous for so many for the first time, those problems have amplified a thousandfold. </p>\r\n<p>All rooms come with comfy Hypnos beds with luxury Egyptian cotton linen, spacious bathrooms, Nespresso coffee machines, highspeed Wi-Fi and several channels on a 40” flat-screen TV.  The mini-bar comes stocked with some drinks that are included in the room rate.</p>\";s:6:\"images\";s:314:\"{\"image_intro\":\"images\\/raimond-klavins-kkJRyWGpQuw-unsplash.jpg#joomlaImage:\\/\\/local-images\\/raimond-klavins-kkJRyWGpQuw-unsplash.jpg?width=1380&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:2;s:10:\"created_by\";i:123;s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2024-04-02 03:09:21\";s:11:\"modified_by\";i:123;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":100:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"1\";s:9:\"show_hits\";s:1:\"1\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";s:20:\"astroid_article_type\";s:5:\"video\";s:26:\"astroid_article_video_type\";s:7:\"youtube\";s:25:\"astroid_article_video_url\";s:43:\"https://www.youtube.com/watch?v=UdB58PPZFW0\";s:31:\"astroid_article_gallery_bullets\";s:1:\"1\";s:34:\"astroid_article_gallery_navigation\";s:1:\"1\";s:25:\"astroid_article_thumbnail\";s:1:\"1\";s:29:\"astroid_article_gallery_items\";a:0:{}s:28:\"astroid_article_audio_source\";s:10:\"soundcloud\";s:29:\"astroid_article_review_rating\";s:1:\"5\";s:32:\"astroid_article_review_criterias\";a:0:{}s:32:\"astroid_article_content_position\";s:11:\"above-title\";s:21:\"astroid_article_badge\";s:1:\"0\";s:26:\"astroid_article_badge_type\";s:1:\"2\";s:33:\"article_relatedposts_count_custom\";s:1:\"4\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"version\";i:7;s:8:\"ordering\";i:0;s:8:\"category\";s:13:\"Uncategorised\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:46:\"7:what-to-do-on-a-weekend-in-istanbul-tuerkiye\";s:7:\"catslug\";s:15:\"2:uncategorised\";s:6:\"author\";s:13:\"Violet Michel\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:8:\"imageUrl\";s:137:\"images/raimond-klavins-kkJRyWGpQuw-unsplash.jpg#joomlaImage://local-images/raimond-klavins-kkJRyWGpQuw-unsplash.jpg?width=1380&height=900\";s:8:\"imageAlt\";s:0:\"\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2024-04-02 02:29:22\";i:10;N;i:11;s:99:\"index.php?option=com_content&view=article&id=7:what-to-do-on-a-weekend-in-istanbul-tuerkiye&catid=2\";i:12;N;i:13;s:19:\"2024-04-02 02:29:22\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:3;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:13:\"Violet Michel\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:13:\"Uncategorised\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:7;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}}i:16;s:45:\"What To Do On A Weekend In Istanbul, Türkiye\";i:17;i:3;i:18;s:46:\"index.php?option=com_content&view=article&id=7\";}'),
('8', 'index.php?option=com_content&view=article&id=8', 'index.php?option=com_content&view=article&id=8:hotel-review-hotel-indigo-bath-somerset&catid=2', 'HOTEL Review: Hotel Indigo Bath, Somerset', ' The decor is a departure from other themed hotel rooms; it has a four-poster bed with stylish bathrooms decorated with patterned tiling, a rainforest shower and a free-standing roll-top bath. ', '2024-05-07 02:48:22', '183f8ddaa2d115c14a6f676c248b4c87', '1', '1', '1', '*', '2024-04-02 02:29:22', NULL, '2024-04-02 02:29:22', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:193:\" The decor is a departure from other themed hotel rooms; it has a four-poster bed with stylish bathrooms decorated with patterned tiling, a rainforest shower and a free-standing roll-top bath. \";i:3;a:27:{s:2:\"id\";i:8;s:5:\"alias\";s:39:\"hotel review hotel indigo bath somerset\";s:7:\"summary\";s:200:\"<p>The decor is a departure from other themed hotel rooms; it has a four-poster bed with stylish bathrooms decorated with patterned tiling, a rainforest shower and a free-standing roll-top bath.</p>\r\n\";s:4:\"body\";s:2362:\"\r\n<p>The main entrance leads to the reception area where staff clad in jeans and a waistcoat are welcoming and efficient. The colourful area has comfortable sofas, armchairs and chandeliers making this a lovely place to hang out. It has a trendy vibe about it.</p>\r\n<h2>Facilities</h2>\r\n<p>Small bells hang on the wall perhaps in homage to the Abbey bells, behind a white reception while the rest of the room has funky artworks, as does most of the hotel. Sometimes it’s Regency-style, sometimes faces obscured by a primary colour and bizarrely even animals dressed in military costumes. </p>\r\n<blockquote>\r\n<p>Getting inspiration from other photographers through their online photography portfolios or social media posts only goes so far. </p>\r\n</blockquote>\r\n<p>Sure, there have always been tourists behaving badly ever since the first tourist existed. But, in an age where travel has become so easy and ubiquitous for so many for the first time, those problems have amplified a thousandfold. Destinations didn’t have the necessary infrastructure to handle the flood of tourists cheap travel brought.</p>\r\n<p>All rooms come with comfy Hypnos beds with luxury Egyptian cotton linen, spacious bathrooms, <strong>Nespresso coffee machines</strong>, highspeed Wi-Fi and several channels on a 40” flat-screen TV.  The mini-bar comes stocked with some drinks that are included in the room rate.</p>\r\n<h2>Nespresso coffee machines</h2>\r\n<p><img class=\"float-none\" src=\"images/garrett-parker-DlkF4-dbCOU-unsplash.jpg\" width=\"1380\" height=\"900\"></p>\r\n<ul>\r\n<li>World Nomads (for everyone below 70)</li>\r\n<li>Insure My Trip (for those over 70)</li>\r\n<li style=\"font-style: italic;\"><em>Medjet (for additional repatriation coverage)</em></li>\r\n</ul>\r\n<p>As we yearn to reconnect with friends, family, and the world at large, I think that what we’ve gone through has also given many of us a chance to reflect on all the things we took for granted: the outdoors, community, neighborhood restaurants, and the arts.</p>\r\n<p>From flouting rules and refusing to wear a mask to hosting parties, coughing on others, and just generally being selfish, the pandemic has shown us that the world is filled with more assholes than we thought. But, despite all of that, when it comes to the future of travel, I think the pandemic is going to make it <em>better</em>.</p>\";s:6:\"images\";s:316:\"{\"image_intro\":\"images\\/pietro-de-grandi-T7K4aEPoGGk-unsplash.jpg#joomlaImage:\\/\\/local-images\\/pietro-de-grandi-T7K4aEPoGGk-unsplash.jpg?width=1380&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:2;s:10:\"created_by\";i:123;s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2024-05-07 02:48:22\";s:11:\"modified_by\";i:123;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":100:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"1\";s:9:\"show_hits\";s:1:\"1\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";s:20:\"astroid_article_type\";s:5:\"audio\";s:26:\"astroid_article_video_type\";s:7:\"youtube\";s:31:\"astroid_article_gallery_bullets\";s:1:\"1\";s:34:\"astroid_article_gallery_navigation\";s:1:\"1\";s:25:\"astroid_article_thumbnail\";s:1:\"1\";s:29:\"astroid_article_gallery_items\";a:0:{}s:28:\"astroid_article_audio_source\";s:10:\"soundcloud\";s:32:\"astroid_article_audio_soundcloud\";s:950:\"<iframe width=\"100%\" height=\"300\" scrolling=\"no\" frameborder=\"no\" allow=\"autoplay\" src=\"https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/206722679&color=%23ff5500&auto_play=false&hide_related=false&show_comments=true&show_user=true&show_reposts=false&show_teaser=true&visual=true\"></iframe><div style=\"font-size: 10px; color: #cccccc;line-break: anywhere;word-break: normal;overflow: hidden;white-space: nowrap;text-overflow: ellipsis; font-family: Interstate,Lucida Grande,Lucida Sans Unicode,Lucida Sans,Garuda,Verdana,Tahoma,sans-serif;font-weight: 100;\"><a href=\"https://soundcloud.com/fkj-2\" title=\"FKJ\" target=\"_blank\" style=\"color: #cccccc; text-decoration: none;\">FKJ</a> · <a href=\"https://soundcloud.com/fkj-2/lianne-la-havas-unstoppable-fkj-remix\" title=\"Lianne La Havas  - Unstoppable (FKJ Remix)\" target=\"_blank\" style=\"color: #cccccc; text-decoration: none;\">Lianne La Havas  - Unstoppable (FKJ Remix)</a></div>\";s:29:\"astroid_article_review_rating\";s:1:\"5\";s:32:\"astroid_article_review_criterias\";a:0:{}s:32:\"astroid_article_content_position\";s:11:\"above-title\";s:21:\"astroid_article_badge\";s:1:\"0\";s:26:\"astroid_article_badge_type\";s:1:\"2\";s:33:\"article_relatedposts_count_custom\";s:1:\"4\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"version\";i:4;s:8:\"ordering\";i:8;s:8:\"category\";s:13:\"Uncategorised\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:41:\"8:hotel-review-hotel-indigo-bath-somerset\";s:7:\"catslug\";s:15:\"2:uncategorised\";s:6:\"author\";s:9:\"Leo Ethan\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:8:\"imageUrl\";s:139:\"images/pietro-de-grandi-T7K4aEPoGGk-unsplash.jpg#joomlaImage://local-images/pietro-de-grandi-T7K4aEPoGGk-unsplash.jpg?width=1380&height=900\";s:8:\"imageAlt\";s:0:\"\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2024-04-02 02:29:22\";i:10;N;i:11;s:94:\"index.php?option=com_content&view=article&id=8:hotel-review-hotel-indigo-bath-somerset&catid=2\";i:12;N;i:13;s:19:\"2024-04-02 02:29:22\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:3;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:9:\"Leo Ethan\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:12;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:13:\"Uncategorised\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:7;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}}i:16;s:41:\"HOTEL Review: Hotel Indigo Bath, Somerset\";i:17;i:3;i:18;s:46:\"index.php?option=com_content&view=article&id=8\";}'),
('9', 'index.php?option=com_content&view=article&id=9', 'index.php?option=com_content&view=article&id=9:where-music-lovers-should-travel-in-2024&catid=2', 'Where Music Lovers Should Travel In 2024', ' It’s also a chance to hear up and coming jazz artists, such as the National Youth Jazz Orchestra (NYJO), as the festival has an active talent development programme. ', '2024-04-02 03:21:49', 'add9e0073aba01fa6bddb3a3c407d0d5', '1', '1', '1', '*', '2024-04-02 02:29:22', NULL, '2024-04-02 02:29:22', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:168:\" It’s also a chance to hear up and coming jazz artists, such as the National Youth Jazz Orchestra (NYJO), as the festival has an active talent development programme. \";i:3;a:27:{s:2:\"id\";i:9;s:5:\"alias\";s:40:\"where music lovers should travel in 2024\";s:7:\"summary\";s:179:\"<p> It’s also a chance to hear up and coming jazz artists, such as the National Youth Jazz Orchestra (NYJO), as the festival has an active talent development programme. </p>\r\n\";s:4:\"body\";s:2172:\"\r\n<p>A trip to Cheltenham is a pleasure at any time of the year, but the Georgian spa town is particularly buzzing during Cheltenham Jazz Festival when 20,000 music fans descend on Montpellier Gardens over the week.</p>\r\n<p>This year Gregory Porter, the festival’s Artistic Curator, will be headlining, and other acts not to miss include Dionne Warwick, Sophie Ellis Bextor, Ronnie Scott’s Jazz Orchestra, Morcheeba, and Courtney Pine.</p>\r\n<h2>Headed Into Low-Cost Headwinds</h2>\r\n<p>Sometimes it’s Regency-style, sometimes faces obscured by a primary colour and bizarrely even animals dressed in military costumes. In much of the communal area, carpets are decorated with butterflies; sometimes there are prints and maps. A lot is going on.</p>\r\n<blockquote>\r\n<p>Getting inspiration from other photographers through their online photography portfolios or social media posts only goes so far. </p>\r\n</blockquote>\r\n<p>Most musical genres are represented in the programme, so whether it is blues, soul, rock, folk, or electronic music that gets you up on the dance floor, there will be plenty to keep you entertained until late at night</p>\r\n<p>All rooms come with comfy Hypnos beds with luxury Egyptian cotton linen, spacious bathrooms, Nespresso coffee machines, highspeed Wi-Fi and several channels on a 40” flat-screen TV.  The mini-bar comes stocked with some drinks that are included in the room rate.</p>\r\n<h2>The Skies Will Be Busier, The Planes Fuller</h2>\r\n<ul>\r\n<li>World Nomads (for everyone below 70)</li>\r\n<li>Insure My Trip (for those over 70)</li>\r\n<li style=\"font-style: italic;\"><em>Medjet (for additional repatriation coverage)</em></li>\r\n</ul>\r\n<p>As we yearn to reconnect with friends, family, and the world at large, I think that what we’ve gone through has also given many of us a chance to reflect on all the things we took for granted: the outdoors, community, neighborhood restaurants, and the arts.</p>\r\n<p>From flouting rules and refusing to <em>wear a mask to hosting parties</em>, coughing on others, and just generally being selfish, the pandemic has shown us that the world is filled with more assholes than we thought. </p>\";s:6:\"images\";s:312:\"{\"image_intro\":\"images\\/ibrahim-rifath-Y6tBl0pTe-g-unsplash.jpg#joomlaImage:\\/\\/local-images\\/ibrahim-rifath-Y6tBl0pTe-g-unsplash.jpg?width=1380&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:2;s:10:\"created_by\";i:123;s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2024-04-02 03:21:49\";s:11:\"modified_by\";i:123;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":101:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"1\";s:9:\"show_hits\";s:1:\"1\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";s:20:\"astroid_article_type\";s:5:\"quote\";s:26:\"astroid_article_video_type\";s:7:\"youtube\";s:31:\"astroid_article_gallery_bullets\";s:1:\"1\";s:34:\"astroid_article_gallery_navigation\";s:1:\"1\";s:25:\"astroid_article_thumbnail\";s:1:\"1\";s:29:\"astroid_article_gallery_items\";a:0:{}s:28:\"astroid_article_audio_source\";s:10:\"soundcloud\";s:29:\"astroid_article_review_rating\";s:1:\"5\";s:32:\"astroid_article_review_criterias\";a:0:{}s:26:\"astroid_article_quote_text\";s:139:\"There are concerts here throughout the year, but the highlight is the summer opera festival, which has itself run for more than a century. \";s:28:\"astroid_article_quote_author\";s:13:\"David Poutays\";s:32:\"astroid_article_content_position\";s:11:\"above-title\";s:21:\"astroid_article_badge\";s:1:\"0\";s:26:\"astroid_article_badge_type\";s:1:\"2\";s:33:\"article_relatedposts_count_custom\";s:1:\"4\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"version\";i:4;s:8:\"ordering\";i:0;s:8:\"category\";s:13:\"Uncategorised\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:42:\"9:where-music-lovers-should-travel-in-2024\";s:7:\"catslug\";s:15:\"2:uncategorised\";s:6:\"author\";s:13:\"Violet Michel\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:8:\"imageUrl\";s:135:\"images/ibrahim-rifath-Y6tBl0pTe-g-unsplash.jpg#joomlaImage://local-images/ibrahim-rifath-Y6tBl0pTe-g-unsplash.jpg?width=1380&height=900\";s:8:\"imageAlt\";s:0:\"\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2024-04-02 02:29:22\";i:10;N;i:11;s:95:\"index.php?option=com_content&view=article&id=9:where-music-lovers-should-travel-in-2024&catid=2\";i:12;N;i:13;s:19:\"2024-04-02 02:29:22\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:3;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:13:\"Violet Michel\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:13:\"Uncategorised\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:7;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}}i:16;s:40:\"Where Music Lovers Should Travel In 2024\";i:17;i:3;i:18;s:46:\"index.php?option=com_content&view=article&id=9\";}'),
('10', 'index.php?option=com_content&view=article&id=10', 'index.php?option=com_content&view=article&id=10:10-european-ski-destinations-you-should-visit&catid=2', '10 European Ski Destinations You Should Visit', ' The attractive neo-classical opera house dates from the early 1940s, and forthcoming productions are advertised outside. Pop into the box office to book tickets. ', '2024-04-02 03:27:03', 'e60a7f66105f5009c12dd893be5cbba3', '1', '1', '1', '*', '2024-04-02 02:29:22', NULL, '2024-04-02 02:29:22', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:163:\" The attractive neo-classical opera house dates from the early 1940s, and forthcoming productions are advertised outside. Pop into the box office to book tickets. \";i:3;a:25:{s:2:\"id\";i:10;s:5:\"alias\";s:45:\"10 european ski destinations you should visit\";s:7:\"summary\";s:170:\"<p>The attractive neo-classical opera house dates from the early 1940s, and forthcoming productions are advertised outside. Pop into the box office to book tickets.</p>\r\n\";s:4:\"body\";s:1824:\"\r\n<p>It’s an easy yet slightly poised ambiance at The Olive Tree restaurant. Diners talk in hushed voices while their facial grimaces show reverence and subdued delight. Lighting is dimmed, walls are in a shade of olive with simple artwork, with a feature wall on one side, floors and tables are of wood, with chairs with black or olive green upholstery.</p>\r\n<h2>Ambience At The Olive Tree Restaurant</h2>\r\n<p>Small bells hang on the wall perhaps in homage to the Abbey bells, behind a white reception while the rest of the room has funky artworks, as does most of the hotel. Sometimes it’s Regency-style, sometimes faces obscured by a primary colour and bizarrely even animals dressed in military costumes. </p>\r\n<ul>\r\n<li>Always Use a Tripod</li>\r\n<li>Composition for Building Photography</li>\r\n<li>Control Perspective</li>\r\n</ul>\r\n<p>Whether you are a hobbyist strolling a new city, a travel blogger looking to share spectacular sights with your readers, or a professional photographer looking for a new niche, the architecture around us all the time is an exciting and varied subject.</p>\r\n<h2>Food &amp; Drink</h2>\r\n<blockquote>\r\n<p><em>The biggest mistake you can make in architecture photos is to snap and go, with little planning or forethought. Take your time and exercise your creative grey cells.</em></p>\r\n</blockquote>\r\n<p>As we yearn to reconnect with friends, family, and the world at large, I think that what we’ve gone through has also given many of us a chance to reflect on all the things we took for granted: the outdoors, community, neighborhood restaurants, and the arts.</p>\r\n<p>From flouting rules and refusing to wear a mask to hosting parties, coughing on others, and just generally being selfish, the pandemic has shown us that the world is filled with more assholes than we thought. </p>\";s:6:\"images\";s:173:\"{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:2;s:10:\"created_by\";i:123;s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2024-04-02 03:27:03\";s:11:\"modified_by\";i:123;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":99:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"1\";s:9:\"show_hits\";s:1:\"1\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";s:20:\"astroid_article_type\";s:7:\"gallery\";s:26:\"astroid_article_video_type\";s:7:\"youtube\";s:31:\"astroid_article_gallery_bullets\";s:1:\"1\";s:34:\"astroid_article_gallery_navigation\";s:1:\"1\";s:25:\"astroid_article_thumbnail\";s:1:\"1\";s:29:\"astroid_article_gallery_items\";a:3:{s:30:\"astroid_article_gallery_items0\";a:3:{s:5:\"title\";s:0:\"\";s:5:\"image\";s:127:\"images/luca-bravo-VowIFDxogG4-unsplash.jpg#joomlaImage://local-images/luca-bravo-VowIFDxogG4-unsplash.jpg?width=1380&height=900\";s:11:\"description\";s:0:\"\";}s:30:\"astroid_article_gallery_items1\";a:3:{s:5:\"title\";s:0:\"\";s:5:\"image\";s:137:\"images/david-edelstein-N4DbvTUDikw-unsplash.jpg#joomlaImage://local-images/david-edelstein-N4DbvTUDikw-unsplash.jpg?width=1380&height=900\";s:11:\"description\";s:0:\"\";}s:30:\"astroid_article_gallery_items2\";a:3:{s:5:\"title\";s:0:\"\";s:5:\"image\";s:131:\"images/kalen-emsley-7bwQXzbF6KE-unsplash.jpg#joomlaImage://local-images/kalen-emsley-7bwQXzbF6KE-unsplash.jpg?width=1380&height=900\";s:11:\"description\";s:0:\"\";}}s:28:\"astroid_article_audio_source\";s:10:\"soundcloud\";s:29:\"astroid_article_review_rating\";s:1:\"5\";s:32:\"astroid_article_review_criterias\";a:0:{}s:32:\"astroid_article_content_position\";s:14:\"before-content\";s:21:\"astroid_article_badge\";s:1:\"0\";s:26:\"astroid_article_badge_type\";s:1:\"2\";s:33:\"article_relatedposts_count_custom\";s:1:\"4\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"version\";i:6;s:8:\"ordering\";i:0;s:8:\"category\";s:13:\"Uncategorised\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:48:\"10:10-european-ski-destinations-you-should-visit\";s:7:\"catslug\";s:15:\"2:uncategorised\";s:6:\"author\";s:13:\"Violet Michel\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2024-04-02 02:29:22\";i:10;N;i:11;s:101:\"index.php?option=com_content&view=article&id=10:10-european-ski-destinations-you-should-visit&catid=2\";i:12;N;i:13;s:19:\"2024-04-02 02:29:22\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:3;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:13:\"Violet Michel\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:13:\"Uncategorised\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:7;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}}i:16;s:45:\"10 European Ski Destinations You Should Visit\";i:17;i:3;i:18;s:47:\"index.php?option=com_content&view=article&id=10\";}'),
('11', 'index.php?option=com_content&view=category&id=8', 'index.php?option=com_content&view=category&id=8', 'Tours', '', '2024-04-12 03:06:56', 'ced91a46e86d1a2f9806f7bdd864b909', '1', '1', '1', '*', NULL, NULL, '2024-04-12 03:06:56', NULL, '0', '0', '1', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:0:\"\";i:3;a:17:{s:2:\"id\";i:8;s:5:\"alias\";s:5:\"tours\";s:9:\"extension\";s:11:\"com_content\";s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":2:{s:6:\"author\";s:0:\"\";s:6:\"robots\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:3:\"lft\";i:11;s:9:\"parent_id\";i:1;s:5:\"level\";i:1;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":12:{s:15:\"category_layout\";s:0:\"\";s:5:\"image\";s:0:\"\";s:9:\"image_alt\";s:0:\"\";s:18:\"astroid_authorinfo\";s:0:\"\";s:20:\"astroid_relatedposts\";s:0:\"\";s:26:\"article_relatedposts_count\";s:0:\"\";s:33:\"article_relatedposts_count_custom\";s:1:\"4\";s:29:\"article_relatedposts_posttype\";s:0:\"\";s:26:\"article_relatedposts_badge\";s:0:\"\";s:16:\"astroid_readtime\";s:0:\"\";s:19:\"astroid_socialshare\";s:0:\"\";s:16:\"astroid_comments\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"summary\";s:0:\"\";s:10:\"created_by\";i:123;s:8:\"modified\";s:19:\"2024-04-12 03:06:56\";s:11:\"modified_by\";i:123;s:4:\"slug\";s:7:\"8:tours\";s:6:\"layout\";s:8:\"category\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:4:\"link\";i:4;s:7:\"metakey\";i:5;s:8:\"metadesc\";i:6;s:10:\"metaauthor\";i:7;s:6:\"author\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;N;i:10;N;i:11;s:47:\"index.php?option=com_content&view=category&id=8\";i:12;N;i:13;s:19:\"2024-04-12 03:06:56\";i:14;i:1;i:15;a:2:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:8:\"Category\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:10;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}}i:16;s:5:\"Tours\";i:17;i:1;i:18;s:47:\"index.php?option=com_content&view=category&id=8\";}'),
('12', 'index.php?option=com_content&view=article&id=11', 'index.php?option=com_content&view=article&id=11:high-speed-thames-river-rib-cruise-in-london&catid=8', 'High-Speed Thames River RIB Cruise in London', ' Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque consequat odio turpis, eu finibus odio varius non. Suspendisse commodo lobortis dapibus. ', '2024-04-12 08:36:29', '2104f0c54205e7f27baeb346131d899f', '1', '1', '1', '*', '2024-04-12 03:11:28', NULL, '2024-04-12 03:11:28', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:160:\" Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque consequat odio turpis, eu finibus odio varius non. Suspendisse commodo lobortis dapibus. \";i:3;a:27:{s:2:\"id\";i:11;s:5:\"alias\";s:44:\"high speed thames river rib cruise in london\";s:7:\"summary\";s:167:\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque consequat odio turpis, eu finibus odio varius non. Suspendisse commodo lobortis dapibus.</p>\r\n\";s:4:\"body\";s:286:\"\r\n<p>Morbi eu rhoncus risus. Praesent blandit efficitur eros ac rhoncus. In sit amet fermentum sem. Nunc nisi turpis, faucibus in arcu aliquam, tempus semper augue. Ut interdum erat neque, vitae facilisis leo convallis ut. Ut tempus placerat nisi, eget dapibus elit consectetur vel.</p>\";s:6:\"images\";s:317:\"{\"image_intro\":\"images\\/charles-postiaux-Q6UehpkBSnQ-unsplash.jpg#joomlaImage:\\/\\/local-images\\/charles-postiaux-Q6UehpkBSnQ-unsplash.jpg?width=1920&height=1280\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:8;s:10:\"created_by\";i:123;s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2024-04-12 08:36:29\";s:11:\"modified_by\";i:123;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":99:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"1\";s:9:\"show_hits\";s:1:\"1\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";s:20:\"astroid_article_type\";s:7:\"gallery\";s:26:\"astroid_article_video_type\";s:7:\"youtube\";s:31:\"astroid_article_gallery_bullets\";s:1:\"1\";s:34:\"astroid_article_gallery_navigation\";s:1:\"1\";s:25:\"astroid_article_thumbnail\";s:1:\"1\";s:29:\"astroid_article_gallery_items\";a:3:{s:30:\"astroid_article_gallery_items0\";a:3:{s:5:\"title\";s:0:\"\";s:5:\"image\";s:140:\"images/charles-postiaux-Q6UehpkBSnQ-unsplash.jpg#joomlaImage://local-images/charles-postiaux-Q6UehpkBSnQ-unsplash.jpg?width=1920&height=1280\";s:11:\"description\";s:0:\"\";}s:30:\"astroid_article_gallery_items1\";a:3:{s:5:\"title\";s:0:\"\";s:5:\"image\";s:138:\"images/benjamin-davies-Oja2ty_9ZLM-unsplash.jpg#joomlaImage://local-images/benjamin-davies-Oja2ty_9ZLM-unsplash.jpg?width=1920&height=1280\";s:11:\"description\";s:0:\"\";}s:30:\"astroid_article_gallery_items2\";a:3:{s:5:\"title\";s:0:\"\";s:5:\"image\";s:132:\"images/lucas-davies-iP8ElEhqHeY-unsplash.jpg#joomlaImage://local-images/lucas-davies-iP8ElEhqHeY-unsplash.jpg?width=1920&height=1280\";s:11:\"description\";s:0:\"\";}}s:28:\"astroid_article_audio_source\";s:10:\"soundcloud\";s:29:\"astroid_article_review_rating\";s:1:\"5\";s:32:\"astroid_article_review_criterias\";a:0:{}s:32:\"astroid_article_content_position\";s:11:\"above-title\";s:21:\"astroid_article_badge\";s:1:\"0\";s:26:\"astroid_article_badge_type\";s:1:\"2\";s:33:\"article_relatedposts_count_custom\";s:1:\"4\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"version\";i:4;s:8:\"ordering\";i:0;s:8:\"category\";s:5:\"Tours\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:47:\"11:high-speed-thames-river-rib-cruise-in-london\";s:7:\"catslug\";s:7:\"8:tours\";s:6:\"author\";s:9:\"Leo Ethan\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:8:\"imageUrl\";s:140:\"images/charles-postiaux-Q6UehpkBSnQ-unsplash.jpg#joomlaImage://local-images/charles-postiaux-Q6UehpkBSnQ-unsplash.jpg?width=1920&height=1280\";s:8:\"imageAlt\";s:0:\"\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2024-04-12 03:11:28\";i:10;N;i:11;s:100:\"index.php?option=com_content&view=article&id=11:high-speed-thames-river-rib-cruise-in-london&catid=8\";i:12;N;i:13;s:19:\"2024-04-12 03:11:28\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:3;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:9:\"Leo Ethan\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:12;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:5:\"Tours\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:11;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}}i:16;s:44:\"High-Speed Thames River RIB Cruise in London\";i:17;i:3;i:18;s:47:\"index.php?option=com_content&view=article&id=11\";}');/**ABDB**/
/**ABDB**/CREATE TABLE `#__action_logs_users` (
  `user_id` int(10) unsigned NOT NULL,
  `notify` tinyint(3) unsigned NOT NULL,
  `extensions` text NOT NULL,
  PRIMARY KEY (`user_id`),
  KEY `idx_notify` (`notify`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__action_logs_users`  VALUES 
('123', '0', '[\"com_content\"]');
/**ABDB**/CREATE TABLE `#__ucm_content` (
  `core_content_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `core_type_alias` varchar(400) NOT NULL DEFAULT '' COMMENT 'FK to the content types table',
  `core_title` varchar(400) NOT NULL DEFAULT '',
  `core_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `core_body` mediumtext DEFAULT NULL,
  `core_state` tinyint(4) NOT NULL DEFAULT 0,
  `core_checked_out_time` datetime DEFAULT NULL,
  `core_checked_out_user_id` int(10) unsigned DEFAULT NULL,
  `core_access` int(10) unsigned NOT NULL DEFAULT 0,
  `core_params` text DEFAULT NULL,
  `core_featured` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `core_metadata` varchar(2048) NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `core_created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `core_created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `core_created_time` datetime NOT NULL,
  `core_modified_user_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Most recent user that modified',
  `core_modified_time` datetime NOT NULL,
  `core_language` char(7) NOT NULL DEFAULT '',
  `core_publish_up` datetime DEFAULT NULL,
  `core_publish_down` datetime DEFAULT NULL,
  `core_content_item_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'ID from the individual type table',
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `core_images` text DEFAULT NULL,
  `core_urls` text DEFAULT NULL,
  `core_hits` int(10) unsigned NOT NULL DEFAULT 0,
  `core_version` int(10) unsigned NOT NULL DEFAULT 1,
  `core_ordering` int(11) NOT NULL DEFAULT 0,
  `core_metakey` text DEFAULT NULL,
  `core_metadesc` text DEFAULT NULL,
  `core_catid` int(10) unsigned NOT NULL DEFAULT 0,
  `core_type_id` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`core_content_id`),
  KEY `tag_idx` (`core_state`,`core_access`),
  KEY `idx_access` (`core_access`),
  KEY `idx_alias` (`core_alias`(100)),
  KEY `idx_language` (`core_language`),
  KEY `idx_title` (`core_title`(100)),
  KEY `idx_modified_time` (`core_modified_time`),
  KEY `idx_created_time` (`core_created_time`),
  KEY `idx_content_type` (`core_type_alias`(100)),
  KEY `idx_core_modified_user_id` (`core_modified_user_id`),
  KEY `idx_core_checked_out_user_id` (`core_checked_out_user_id`),
  KEY `idx_core_created_user_id` (`core_created_user_id`),
  KEY `idx_core_type_id` (`core_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Contains core content data in name spaced fields';
/**ABDB**/INSERT INTO `#__ucm_content`  VALUES 
('1', 'com_content.article', 'A Beginner’s Guide To Architecture Photography', 'a-beginner-s-guide-to-architecture-photography', '<p>Architecture images grace the pages of magazines and fill travel albums all over the world. If architects do their job right, it only fits that their work would catch the eye of creative photographers.</p>\r\n', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"astroid_article_type\":\"regular\",\"astroid_article_video_type\":\"youtube\",\"astroid_article_video_url\":\"\",\"astroid_article_gallery_width\":\"\",\"astroid_article_gallery_bullets\":\"1\",\"astroid_article_gallery_navigation\":\"1\",\"astroid_article_thumbnail\":\"1\",\"astroid_article_gallery_items\":[],\"astroid_article_audio_source\":\"soundcloud\",\"astroid_article_audio_soundcloud\":\"\",\"astroid_article_audio_spotify\":\"\",\"astroid_article_review_heading\":\"\",\"astroid_article_review_summery\":\"\",\"astroid_article_review_good\":\"\",\"astroid_article_review_bad\":\"\",\"astroid_article_review_rating\":\"5\",\"astroid_article_button_action\":\"\",\"astroid_article_button_link\":\"\",\"astroid_article_review_criterias\":[],\"astroid_article_quote_text\":\"\",\"astroid_article_quote_author\":\"\",\"astroid_article_content_position\":\"above-title\",\"astroid_article_badge\":\"0\",\"astroid_article_badge_type\":\"2\",\"astroid_article_badge_text\":\"\",\"astroid_article_badge_color\":\"\",\"astroid_article_badge_text_color\":\"\",\"astroid_authorinfo\":\"\",\"astroid_relatedposts\":\"\",\"article_relatedposts_count\":\"\",\"article_relatedposts_count_custom\":\"4\",\"article_relatedposts_posttype\":\"\",\"article_relatedposts_badge\":\"\",\"astroid_readtime\":\"\",\"astroid_socialshare\":\"\",\"astroid_comments\":\"\",\"astroid_og_title\":\"\",\"astroid_og_desc\":\"\",\"astroid_og_image\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '123', '', '2024-04-02 02:29:22', '123', '2024-04-02 02:56:53', '*', '2024-04-02 02:29:22', NULL, '6', '129', '{\"image_intro\":\"images\\/julian-timmerman-Fn27DlI8bZ8-unsplash.jpg#joomlaImage:\\/\\/local-images\\/julian-timmerman-Fn27DlI8bZ8-unsplash.jpg?width=1380&height=921\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/julian-timmerman-Fn27DlI8bZ8-unsplash.jpg#joomlaImage:\\/\\/local-images\\/julian-timmerman-Fn27DlI8bZ8-unsplash.jpg?width=1380&height=921\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '1', '5', '0', '', '', '2', '1'),
('2', 'com_content.article', 'What To Do On A Weekend In Istanbul, Türkiye', 'what-to-do-on-a-weekend-in-istanbul-tuerkiye', '<p>Lighting is dimmed, walls are in a shade of olive with simple artwork, with a feature wall on one side, floors and tables are of wood, with chairs with black or olive green upholstery.</p>\r\n', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"astroid_article_type\":\"video\",\"astroid_article_video_type\":\"youtube\",\"astroid_article_video_url\":\"https:\\/\\/www.youtube.com\\/watch?v=UdB58PPZFW0\",\"astroid_article_gallery_width\":\"\",\"astroid_article_gallery_bullets\":\"1\",\"astroid_article_gallery_navigation\":\"1\",\"astroid_article_thumbnail\":\"1\",\"astroid_article_gallery_items\":[],\"astroid_article_audio_source\":\"soundcloud\",\"astroid_article_audio_soundcloud\":\"\",\"astroid_article_audio_spotify\":\"\",\"astroid_article_review_heading\":\"\",\"astroid_article_review_summery\":\"\",\"astroid_article_review_good\":\"\",\"astroid_article_review_bad\":\"\",\"astroid_article_review_rating\":\"5\",\"astroid_article_button_action\":\"\",\"astroid_article_button_link\":\"\",\"astroid_article_review_criterias\":[],\"astroid_article_quote_text\":\"\",\"astroid_article_quote_author\":\"\",\"astroid_article_content_position\":\"above-title\",\"astroid_article_badge\":\"0\",\"astroid_article_badge_type\":\"2\",\"astroid_article_badge_text\":\"\",\"astroid_article_badge_color\":\"\",\"astroid_article_badge_text_color\":\"\",\"astroid_authorinfo\":\"\",\"astroid_relatedposts\":\"\",\"article_relatedposts_count\":\"\",\"article_relatedposts_count_custom\":\"4\",\"article_relatedposts_posttype\":\"\",\"article_relatedposts_badge\":\"\",\"astroid_readtime\":\"\",\"astroid_socialshare\":\"\",\"astroid_comments\":\"\",\"astroid_og_title\":\"\",\"astroid_og_desc\":\"\",\"astroid_og_image\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '123', '', '2024-04-02 02:29:22', '123', '2024-04-02 03:09:21', '*', '2024-04-02 02:29:22', NULL, '7', '130', '{\"image_intro\":\"images\\/raimond-klavins-kkJRyWGpQuw-unsplash.jpg#joomlaImage:\\/\\/local-images\\/raimond-klavins-kkJRyWGpQuw-unsplash.jpg?width=1380&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '5', '7', '0', '', '', '2', '1'),
('3', 'com_content.article', 'HOTEL Review: Hotel Indigo Bath, Somerset', 'hotel-review-hotel-indigo-bath-somerset', '<p>The decor is a departure from other themed hotel rooms; it has a four-poster bed with stylish bathrooms decorated with patterned tiling, a rainforest shower and a free-standing roll-top bath.</p>\r\n', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"astroid_article_type\":\"audio\",\"astroid_article_video_type\":\"youtube\",\"astroid_article_video_url\":\"\",\"astroid_article_gallery_width\":\"\",\"astroid_article_gallery_bullets\":\"1\",\"astroid_article_gallery_navigation\":\"1\",\"astroid_article_thumbnail\":\"1\",\"astroid_article_gallery_items\":[],\"astroid_article_audio_source\":\"soundcloud\",\"astroid_article_audio_soundcloud\":\"<iframe width=\\\"100%\\\" height=\\\"300\\\" scrolling=\\\"no\\\" frameborder=\\\"no\\\" allow=\\\"autoplay\\\" src=\\\"https:\\/\\/w.soundcloud.com\\/player\\/?url=https%3A\\/\\/api.soundcloud.com\\/tracks\\/206722679&color=%23ff5500&auto_play=false&hide_related=false&show_comments=true&show_user=true&show_reposts=false&show_teaser=true&visual=true\\\"><\\/iframe><div style=\\\"font-size: 10px; color: #cccccc;line-break: anywhere;word-break: normal;overflow: hidden;white-space: nowrap;text-overflow: ellipsis; font-family: Interstate,Lucida Grande,Lucida Sans Unicode,Lucida Sans,Garuda,Verdana,Tahoma,sans-serif;font-weight: 100;\\\"><a href=\\\"https:\\/\\/soundcloud.com\\/fkj-2\\\" title=\\\"FKJ\\\" target=\\\"_blank\\\" style=\\\"color: #cccccc; text-decoration: none;\\\">FKJ<\\/a> \\u00b7 <a href=\\\"https:\\/\\/soundcloud.com\\/fkj-2\\/lianne-la-havas-unstoppable-fkj-remix\\\" title=\\\"Lianne La Havas  - Unstoppable (FKJ Remix)\\\" target=\\\"_blank\\\" style=\\\"color: #cccccc; text-decoration: none;\\\">Lianne La Havas  - Unstoppable (FKJ Remix)<\\/a><\\/div>\",\"astroid_article_audio_spotify\":\"\",\"astroid_article_review_heading\":\"\",\"astroid_article_review_summery\":\"\",\"astroid_article_review_good\":\"\",\"astroid_article_review_bad\":\"\",\"astroid_article_review_rating\":\"5\",\"astroid_article_button_action\":\"\",\"astroid_article_button_link\":\"\",\"astroid_article_review_criterias\":[],\"astroid_article_quote_text\":\"\",\"astroid_article_quote_author\":\"\",\"astroid_article_content_position\":\"above-title\",\"astroid_article_badge\":\"0\",\"astroid_article_badge_type\":\"2\",\"astroid_article_badge_text\":\"\",\"astroid_article_badge_color\":\"\",\"astroid_article_badge_text_color\":\"\",\"astroid_authorinfo\":\"\",\"astroid_relatedposts\":\"\",\"article_relatedposts_count\":\"\",\"article_relatedposts_count_custom\":\"4\",\"article_relatedposts_posttype\":\"\",\"article_relatedposts_badge\":\"\",\"astroid_readtime\":\"\",\"astroid_socialshare\":\"\",\"astroid_comments\":\"\",\"astroid_og_title\":\"\",\"astroid_og_desc\":\"\",\"astroid_og_image\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '123', '', '2024-04-02 02:29:22', '123', '2024-05-07 02:48:22', '*', '2024-04-02 02:29:22', NULL, '8', '131', '{\"image_intro\":\"images\\/pietro-de-grandi-T7K4aEPoGGk-unsplash.jpg#joomlaImage:\\/\\/local-images\\/pietro-de-grandi-T7K4aEPoGGk-unsplash.jpg?width=1380&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '5', '4', '8', '', '', '2', '1'),
('4', 'com_content.article', 'Travel Guide: 48 Hours In Dushanbe, Tajikstan ', 'travel-guide-48-hours-in-dushanbe-tajikstan', '<p>Many travellers arrive in Dushanbe, the capital and gateway of Tajikistan, and dash off for an adventure, perhaps hiking in the Fann Mountains or driving along the famously dramatic Pamir Highway.</p>\r\n', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"astroid_article_type\":\"video\",\"astroid_article_video_type\":\"youtube\",\"astroid_article_video_url\":\"https:\\/\\/www.youtube.com\\/watch?v=mNzenfB3OuY\",\"astroid_article_gallery_width\":\"\",\"astroid_article_gallery_bullets\":\"1\",\"astroid_article_gallery_navigation\":\"1\",\"astroid_article_thumbnail\":\"1\",\"astroid_article_gallery_items\":[],\"astroid_article_audio_source\":\"soundcloud\",\"astroid_article_audio_soundcloud\":\"\",\"astroid_article_audio_spotify\":\"\",\"astroid_article_review_heading\":\"\",\"astroid_article_review_summery\":\"\",\"astroid_article_review_good\":\"\",\"astroid_article_review_bad\":\"\",\"astroid_article_review_rating\":\"5\",\"astroid_article_button_action\":\"\",\"astroid_article_button_link\":\"\",\"astroid_article_review_criterias\":[],\"astroid_article_quote_text\":\"\",\"astroid_article_quote_author\":\"\",\"astroid_article_content_position\":\"above-title\",\"astroid_article_badge\":\"0\",\"astroid_article_badge_type\":\"2\",\"astroid_article_badge_text\":\"\",\"astroid_article_badge_color\":\"\",\"astroid_article_badge_text_color\":\"\",\"astroid_authorinfo\":\"\",\"astroid_relatedposts\":\"\",\"article_relatedposts_count\":\"\",\"article_relatedposts_count_custom\":\"4\",\"article_relatedposts_posttype\":\"\",\"article_relatedposts_badge\":\"\",\"astroid_readtime\":\"\",\"astroid_socialshare\":\"\",\"astroid_comments\":\"\",\"astroid_og_title\":\"\",\"astroid_og_desc\":\"\",\"astroid_og_image\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '123', '', '2024-04-02 02:29:22', '123', '2024-05-07 02:49:00', '*', '2024-04-02 02:29:22', NULL, '2', '125', '{\"image_intro\":\"images\\/daniela-cuevas-t7YycgAoVSw-unsplash.jpg#joomlaImage:\\/\\/local-images\\/daniela-cuevas-t7YycgAoVSw-unsplash.jpg?width=1380&height=900\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '4', '6', '2', '', '', '2', '1'),
('5', 'com_content.article', 'Restaurant Review: The Olive Tree, Bath, Somerset, England', 'restaurant-review-the-olive-tree-bath-somerset-england', '<p>The Olive Tree restaurant in Bath is in a basement on Russell Street. That sounds eerie, but actually, this hidden-away restaurant has a fine provenance, on at least two counts.</p>\r\n', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"astroid_article_type\":\"gallery\",\"astroid_article_video_type\":\"youtube\",\"astroid_article_video_url\":\"\",\"astroid_article_gallery_width\":\"\",\"astroid_article_gallery_bullets\":\"1\",\"astroid_article_gallery_navigation\":\"1\",\"astroid_article_thumbnail\":\"1\",\"astroid_article_gallery_items\":{\"astroid_article_gallery_items0\":{\"title\":\"\",\"image\":\"images\\/drif-riadh-YpkuRn54y4w-unsplash.jpg#joomlaImage:\\/\\/local-images\\/drif-riadh-YpkuRn54y4w-unsplash.jpg?width=1380&height=900\",\"description\":\"\"},\"astroid_article_gallery_items1\":{\"title\":\"\",\"image\":\"images\\/felix-rostig-UmV2wr-Vbq8-unsplash.jpg#joomlaImage:\\/\\/local-images\\/felix-rostig-UmV2wr-Vbq8-unsplash.jpg?width=1380&height=900\",\"description\":\"\"},\"astroid_article_gallery_items2\":{\"title\":\"\",\"image\":\"images\\/kalen-emsley-7bwQXzbF6KE-unsplash.jpg#joomlaImage:\\/\\/local-images\\/kalen-emsley-7bwQXzbF6KE-unsplash.jpg?width=1380&height=900\",\"description\":\"\"}},\"astroid_article_audio_source\":\"soundcloud\",\"astroid_article_audio_soundcloud\":\"\",\"astroid_article_audio_spotify\":\"\",\"astroid_article_review_heading\":\"\",\"astroid_article_review_summery\":\"\",\"astroid_article_review_good\":\"\",\"astroid_article_review_bad\":\"\",\"astroid_article_review_rating\":\"5\",\"astroid_article_button_action\":\"\",\"astroid_article_button_link\":\"\",\"astroid_article_review_criterias\":[],\"astroid_article_quote_text\":\"\",\"astroid_article_quote_author\":\"\",\"astroid_article_content_position\":\"above-title\",\"astroid_article_badge\":\"0\",\"astroid_article_badge_type\":\"2\",\"astroid_article_badge_text\":\"\",\"astroid_article_badge_color\":\"\",\"astroid_article_badge_text_color\":\"\",\"astroid_authorinfo\":\"\",\"astroid_relatedposts\":\"\",\"article_relatedposts_count\":\"\",\"article_relatedposts_count_custom\":\"4\",\"article_relatedposts_posttype\":\"\",\"article_relatedposts_badge\":\"\",\"astroid_readtime\":\"\",\"astroid_socialshare\":\"\",\"astroid_comments\":\"\",\"astroid_og_title\":\"\",\"astroid_og_desc\":\"\",\"astroid_og_image\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '123', '', '2024-04-02 02:29:22', '123', '2024-05-07 02:49:33', '*', '2024-04-02 02:29:22', NULL, '3', '126', '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '14', '6', '3', '', '', '2', '1');
/**ABDB**/CREATE TABLE `#__fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0,
  `context` varchar(255) NOT NULL DEFAULT '',
  `group_id` int(10) unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `label` varchar(255) NOT NULL DEFAULT '',
  `default_value` text DEFAULT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'text',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `required` tinyint(4) NOT NULL DEFAULT 0,
  `only_use_in_subform` tinyint(4) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `params` text NOT NULL,
  `fieldparams` mediumtext NOT NULL,
  `language` char(7) NOT NULL DEFAULT '',
  `created_time` datetime NOT NULL,
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `access` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_user_id` (`created_user_id`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__fields`  VALUES 
('1', '145', 'com_content.article', '1', 'Destination', 'destination', 'Destination', '', 'list', '', '', '1', '1', '0', NULL, NULL, '0', '{\"class\":\"\",\"label_class\":\"\",\"show_on\":\"\",\"showon\":\"\",\"render_class\":\"\",\"value_render_class\":\"\",\"showlabel\":\"1\",\"label_render_class\":\"\",\"display\":\"2\",\"prefix\":\"\",\"suffix\":\"\",\"layout\":\"\",\"display_readonly\":\"2\",\"searchindex\":\"0\",\"form_layout\":\"joomla.form.field.list\"}', '{\"multiple\":\"\",\"options\":{\"options0\":{\"name\":\"Euro\",\"value\":\"euro\"},\"options1\":{\"name\":\"Asia\",\"value\":\"asia\"},\"options2\":{\"name\":\"North America\",\"value\":\"north-america\"},\"options3\":{\"name\":\"South America\",\"value\":\"south-america\"},\"options4\":{\"name\":\"Africa\",\"value\":\"africa\"},\"options5\":{\"name\":\"Australia\",\"value\":\"australia\"}}}', '*', '2024-04-12 02:57:56', '123', '2024-04-12 04:22:37', '123', '1'),
('2', '146', 'com_content.article', '1', 'Language', 'language', 'Language', '', 'list', '', '', '1', '0', '0', NULL, NULL, '0', '{\"class\":\"\",\"label_class\":\"\",\"show_on\":\"\",\"showon\":\"\",\"render_class\":\"\",\"value_render_class\":\"\",\"showlabel\":\"1\",\"label_render_class\":\"\",\"display\":\"2\",\"prefix\":\"\",\"suffix\":\"\",\"layout\":\"\",\"display_readonly\":\"2\",\"searchindex\":\"0\",\"form_layout\":\"joomla.form.field.list\"}', '{\"multiple\":\"\",\"options\":{\"options0\":{\"name\":\"English\",\"value\":\"english\"},\"options1\":{\"name\":\"French\",\"value\":\"french\"},\"options2\":{\"name\":\"Italian\",\"value\":\"italian\"},\"options3\":{\"name\":\"German\",\"value\":\"german\"},\"options4\":{\"name\":\"Spanish\",\"value\":\"spanish\"},\"options5\":{\"name\":\"Portugal\",\"value\":\"portugal\"}}}', '*', '2024-04-12 02:59:56', '123', '2024-04-12 04:22:45', '123', '1'),
('3', '147', 'com_content.article', '1', 'Time to Travel', 'time-to-travel', 'Time to Travel', '', 'calendar', '', '', '1', '0', '0', NULL, NULL, '0', '{\"hint\":\"\",\"class\":\"\",\"label_class\":\"\",\"show_on\":\"\",\"showon\":\"\",\"render_class\":\"\",\"value_render_class\":\"\",\"showlabel\":\"1\",\"label_render_class\":\"\",\"display\":\"2\",\"prefix\":\"\",\"suffix\":\"\",\"layout\":\"\",\"display_readonly\":\"2\",\"searchindex\":\"0\"}', '{\"showtime\":0}', '*', '2024-04-12 03:06:40', '123', '2024-04-12 04:22:52', '123', '1'),
('4', '150', 'com_content.article', '1', 'Type', 'type', 'Type', '', 'list', '', '', '1', '1', '0', NULL, NULL, '0', '{\"class\":\"\",\"label_class\":\"\",\"show_on\":\"\",\"showon\":\"\",\"render_class\":\"\",\"value_render_class\":\"\",\"showlabel\":\"1\",\"label_render_class\":\"\",\"display\":\"2\",\"prefix\":\"\",\"suffix\":\"\",\"layout\":\"\",\"display_readonly\":\"2\",\"searchindex\":\"0\",\"form_layout\":\"joomla.form.field.list\"}', '{\"multiple\":\"\",\"options\":{\"options0\":{\"name\":\"Adventure\",\"value\":\"adventure\"},\"options1\":{\"name\":\"City Tour\",\"value\":\"city-tour\"},\"options2\":{\"name\":\"Cultural\",\"value\":\"cultural\"},\"options3\":{\"name\":\"Honeymoon\",\"value\":\"honeymoon\"},\"options4\":{\"name\":\"Luxury\",\"value\":\"luxury\"},\"options5\":{\"name\":\"Discovery\",\"value\":\"discovery\"}}}', '*', '2024-04-12 08:36:08', '123', '2024-04-12 08:36:08', '123', '1');
/**ABDB**/CREATE TABLE `#__user_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `catid` int(10) unsigned NOT NULL DEFAULT 0,
  `subject` varchar(100) NOT NULL DEFAULT '',
  `body` text NOT NULL,
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL,
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL,
  `review_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_category_id` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__postinstall_messages` (
  `postinstall_message_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `extension_id` bigint(20) NOT NULL DEFAULT 700 COMMENT 'FK to #__extensions',
  `title_key` varchar(255) NOT NULL DEFAULT '' COMMENT 'Lang key for the title',
  `description_key` varchar(255) NOT NULL DEFAULT '' COMMENT 'Lang key for description',
  `action_key` varchar(255) NOT NULL DEFAULT '',
  `language_extension` varchar(255) NOT NULL DEFAULT 'com_postinstall' COMMENT 'Extension holding lang keys',
  `language_client_id` tinyint(4) NOT NULL DEFAULT 1,
  `type` varchar(10) NOT NULL DEFAULT 'link' COMMENT 'Message type - message, link, action',
  `action_file` varchar(255) DEFAULT '' COMMENT 'RAD URI to the PHP file containing action method',
  `action` varchar(255) DEFAULT '' COMMENT 'Action method name or URL',
  `condition_file` varchar(255) DEFAULT NULL COMMENT 'RAD URI to file holding display condition method',
  `condition_method` varchar(255) DEFAULT NULL COMMENT 'Display condition method, must return boolean',
  `version_introduced` varchar(50) NOT NULL DEFAULT '3.2.0' COMMENT 'Version when this message was introduced',
  `enabled` tinyint(4) NOT NULL DEFAULT 1,
  PRIMARY KEY (`postinstall_message_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__postinstall_messages`  VALUES 
('1', '237', 'COM_CPANEL_WELCOME_BEGINNERS_TITLE', 'COM_CPANEL_WELCOME_BEGINNERS_MESSAGE', '', 'com_cpanel', '1', 'message', '', '', '', '', '3.2.0', '1'),
('2', '237', 'COM_CPANEL_MSG_STATS_COLLECTION_TITLE', 'COM_CPANEL_MSG_STATS_COLLECTION_BODY', '', 'com_cpanel', '1', 'message', '', '', 'admin://components/com_admin/postinstall/statscollection.php', 'admin_postinstall_statscollection_condition', '3.5.0', '1'),
('3', '237', 'PLG_SYSTEM_HTTPHEADERS_POSTINSTALL_INTRODUCTION_TITLE', 'PLG_SYSTEM_HTTPHEADERS_POSTINSTALL_INTRODUCTION_BODY', 'PLG_SYSTEM_HTTPHEADERS_POSTINSTALL_INTRODUCTION_ACTION', 'plg_system_httpheaders', '1', 'action', 'site://plugins/system/httpheaders/postinstall/introduction.php', 'httpheaders_postinstall_action', 'site://plugins/system/httpheaders/postinstall/introduction.php', 'httpheaders_postinstall_condition', '4.0.0', '1'),
('4', '237', 'COM_USERS_POSTINSTALL_MULTIFACTORAUTH_TITLE', 'COM_USERS_POSTINSTALL_MULTIFACTORAUTH_BODY', 'COM_USERS_POSTINSTALL_MULTIFACTORAUTH_ACTION', 'com_users', '1', 'action', 'admin://components/com_users/postinstall/multifactorauth.php', 'com_users_postinstall_mfa_action', 'admin://components/com_users/postinstall/multifactorauth.php', 'com_users_postinstall_mfa_condition', '4.2.0', '1'),
('5', '237', 'COM_ADMIN_POSTINSTALL_MSG_HTACCESS_BROTLI_TITLE', 'COM_ADMIN_POSTINSTALL_MSG_HTACCESS_BROTLI_DESCRIPTION', '', 'com_admin', '1', 'message', '', '', 'admin://components/com_admin/postinstall/htaccessbrotli.php', 'admin_postinstall_htaccessbrotli_condition', '5.1.0', '1');
/**ABDB**/CREATE TABLE `#__akeeba_common` (
  `key` varchar(190) NOT NULL,
  `value` longtext NOT NULL,
  PRIMARY KEY (`key`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__akeeba_common`  VALUES 
('stats_lastrun', '1717235113'),
('stats_siteid', 'e6d31bb8f0777990ade0eb52244a5ba71bb8837c'),
('stats_siteurl', '8eed7eb1ad31011ed450dc35fcc2ce10');
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `value` text DEFAULT NULL,
  `default_value` text DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `published` tinyint(4) NOT NULL DEFAULT 1,
  `advanced_search` tinyint(4) NOT NULL DEFAULT 0,
  `list_view` tinyint(4) NOT NULL DEFAULT 0,
  `detail_view` tinyint(4) NOT NULL DEFAULT 1,
  `params` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT 1,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 1,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/**ABDB**/INSERT INTO `#__tz_portfolio_plus_fields`  VALUES 
('1', '', 'Destination', 'dropdownlist', '[{\"text\":\"Asia\",\"value\":\"asia\",\"default\":1},{\"text\":\"Africa\",\"value\":\"africa\"},{\"text\":\"Euro\",\"value\":\"euro\"},{\"text\":\"North America\",\"value\":\"north-america\"},{\"text\":\"South America\",\"value\":\"south-america\"},{\"text\":\"Australia\",\"value\":\"australia\"}]', NULL, '0', '1', '1', '1', '1', '{\"required\":\"0\",\"show_title\":\"1\",\"show_label\":\"1\",\"show_image\":\"1\",\"enable_search_link\":\"0\",\"size\":\"\",\"search_type\":\"\"}', '', '1', '136', '2024-04-11 08:43:58', '123', '2024-05-04 08:39:17', '123', '0', '0000-00-00 00:00:00'),
('2', '', 'Language', 'dropdownlist', '[{\"text\":\"English\",\"value\":\"english\",\"default\":1},{\"text\":\"French\",\"value\":\"french\"},{\"text\":\"Vietnamese\",\"value\":\"vietnamese\"},{\"text\":\"Arabic\",\"value\":\"arabic\"},{\"text\":\"Italian\",\"value\":\"italian\"},{\"text\":\"Spanish\",\"value\":\"spanish\"}]', NULL, '0', '1', '1', '0', '1', '{\"required\":\"0\",\"show_title\":\"1\",\"show_label\":\"1\",\"show_image\":\"1\",\"enable_search_link\":\"0\",\"size\":\"\",\"search_type\":\"\"}', '', '1', '137', '2024-04-11 08:45:55', '123', '2024-05-07 02:32:25', '123', '0', '0000-00-00 00:00:00'),
('3', '', 'Time to Travel', 'text', '', NULL, '0', '1', '1', '0', '1', '{\"required\":\"0\",\"show_title\":\"1\",\"show_label\":\"1\",\"show_image\":\"1\",\"enable_search_link\":\"0\",\"regex\":\"\",\"custom_regex\":\"\",\"size\":\"\",\"placeholder\":\"\",\"suggestion\":\"\"}', '', '1', '138', '2024-04-11 08:50:33', '123', '2024-05-04 09:07:59', '123', '0', '0000-00-00 00:00:00'),
('4', '', 'Duration', 'text', '', NULL, '0', '1', '1', '1', '1', '{\"required\":\"0\",\"show_title\":\"1\",\"show_label\":\"1\",\"show_image\":\"1\",\"enable_search_link\":\"0\",\"regex\":\"\",\"custom_regex\":\"\",\"size\":\"\",\"placeholder\":\"\",\"suggestion\":\"\"}', '', '1', '153', '2024-05-04 03:55:44', '123', '2024-05-04 08:38:55', '123', '0', '0000-00-00 00:00:00'),
('5', '', 'Budget', 'text', '', NULL, '0', '1', '1', '1', '1', '{\"required\":\"0\",\"show_title\":\"1\",\"show_label\":\"1\",\"show_image\":\"1\",\"enable_search_link\":\"0\",\"regex\":\"\",\"custom_regex\":\"\",\"size\":\"\",\"placeholder\":\"\",\"suggestion\":\"\"}', '', '1', '154', '2024-05-04 03:58:38', '123', '2024-05-04 08:38:49', '123', '0', '0000-00-00 00:00:00'),
('6', '', 'Type', 'dropdownlist', '[{\"text\":\"Aventure\",\"value\":\"Aventure\"},{\"text\":\"Family Trip\",\"value\":\"Family Trip\"},{\"text\":\"Honeymoon\",\"value\":\"Honeymoon\"},{\"text\":\"Couple\",\"value\":\"Couple\"},{\"text\":\"Culture\",\"value\":\"Culture\"},{\"text\":\"Explore\",\"value\":\"Explore\"}]', NULL, '0', '1', '1', '1', '1', '{\"required\":\"0\",\"show_title\":\"1\",\"show_label\":\"1\",\"show_image\":\"1\",\"enable_search_link\":\"0\",\"size\":\"\",\"search_type\":\"\"}', '', '1', '155', '2024-05-04 08:13:09', '123', '2024-05-04 08:38:44', '123', '0', '0000-00-00 00:00:00');
/**ABDB**/CREATE TABLE `#__action_logs_extensions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `extension` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__action_logs_extensions`  VALUES 
('1', 'com_banners'),
('2', 'com_cache'),
('3', 'com_categories'),
('4', 'com_config'),
('5', 'com_contact'),
('6', 'com_content'),
('7', 'com_installer'),
('8', 'com_media'),
('9', 'com_menus'),
('10', 'com_messages'),
('11', 'com_modules'),
('12', 'com_newsfeeds'),
('13', 'com_plugins'),
('14', 'com_redirect'),
('15', 'com_tags'),
('16', 'com_templates'),
('17', 'com_users'),
('18', 'com_checkin'),
('19', 'com_scheduler'),
('20', 'com_fields'),
('21', 'com_guidedtours');
/**ABDB**/CREATE TABLE `#__redirect_links` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `old_url` varchar(2048) NOT NULL,
  `new_url` varchar(2048) DEFAULT NULL,
  `referer` varchar(2048) NOT NULL,
  `comment` varchar(255) NOT NULL DEFAULT '',
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `published` tinyint(4) NOT NULL,
  `created_date` datetime NOT NULL,
  `modified_date` datetime NOT NULL,
  `header` smallint(6) NOT NULL DEFAULT 301,
  PRIMARY KEY (`id`),
  KEY `idx_old_url` (`old_url`(100)),
  KEY `idx_link_modified` (`modified_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__banner_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `contact` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `extrainfo` text NOT NULL,
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `metakey` text DEFAULT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT 0,
  `metakey_prefix` varchar(400) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT -1,
  `track_clicks` tinyint(4) NOT NULL DEFAULT -1,
  `track_impressions` tinyint(4) NOT NULL DEFAULT -1,
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__akeebabackup_profiles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL,
  `configuration` longtext DEFAULT NULL,
  `filters` longtext DEFAULT NULL,
  `quickicon` tinyint(4) NOT NULL DEFAULT 1,
  `access` int(11) DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__akeebabackup_profiles`  VALUES 
('1', 'Default Backup Profile', '###AES128###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', '', '1', '1');
/**ABDB**/CREATE TABLE `#__action_log_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) NOT NULL DEFAULT '',
  `type_alias` varchar(255) NOT NULL DEFAULT '',
  `id_holder` varchar(255) DEFAULT NULL,
  `title_holder` varchar(255) DEFAULT NULL,
  `table_name` varchar(255) DEFAULT NULL,
  `text_prefix` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__action_log_config`  VALUES 
('1', 'article', 'com_content.article', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
('2', 'article', 'com_content.form', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
('3', 'banner', 'com_banners.banner', 'id', 'name', '#__banners', 'PLG_ACTIONLOG_JOOMLA'),
('4', 'user_note', 'com_users.note', 'id', 'subject', '#__user_notes', 'PLG_ACTIONLOG_JOOMLA'),
('5', 'media', 'com_media.file', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('6', 'category', 'com_categories.category', 'id', 'title', '#__categories', 'PLG_ACTIONLOG_JOOMLA'),
('7', 'menu', 'com_menus.menu', 'id', 'title', '#__menu_types', 'PLG_ACTIONLOG_JOOMLA'),
('8', 'menu_item', 'com_menus.item', 'id', 'title', '#__menu', 'PLG_ACTIONLOG_JOOMLA'),
('9', 'newsfeed', 'com_newsfeeds.newsfeed', 'id', 'name', '#__newsfeeds', 'PLG_ACTIONLOG_JOOMLA'),
('10', 'link', 'com_redirect.link', 'id', 'old_url', '#__redirect_links', 'PLG_ACTIONLOG_JOOMLA'),
('11', 'tag', 'com_tags.tag', 'id', 'title', '#__tags', 'PLG_ACTIONLOG_JOOMLA'),
('12', 'style', 'com_templates.style', 'id', 'title', '#__template_styles', 'PLG_ACTIONLOG_JOOMLA'),
('13', 'plugin', 'com_plugins.plugin', 'extension_id', 'name', '#__extensions', 'PLG_ACTIONLOG_JOOMLA'),
('14', 'component_config', 'com_config.component', 'extension_id', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('15', 'contact', 'com_contact.contact', 'id', 'name', '#__contact_details', 'PLG_ACTIONLOG_JOOMLA'),
('16', 'module', 'com_modules.module', 'id', 'title', '#__modules', 'PLG_ACTIONLOG_JOOMLA'),
('17', 'access_level', 'com_users.level', 'id', 'title', '#__viewlevels', 'PLG_ACTIONLOG_JOOMLA'),
('18', 'banner_client', 'com_banners.client', 'id', 'name', '#__banner_clients', 'PLG_ACTIONLOG_JOOMLA'),
('19', 'application_config', 'com_config.application', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('20', 'task', 'com_scheduler.task', 'id', 'title', '#__scheduler_tasks', 'PLG_ACTIONLOG_JOOMLA'),
('21', 'field', 'com_fields.field', 'id', 'title', '#__fields', 'PLG_ACTIONLOG_JOOMLA'),
('22', 'guidedtour', 'com_guidedtours.state', 'id', 'title', '#__guidedtours', 'PLG_ACTIONLOG_JOOMLA'),
('23', 'contact', 'com_contact.form', 'id', 'name', '#__contact_details', 'PLG_ACTIONLOG_JOOMLA');
/**ABDB**/CREATE TABLE `#__workflow_transitions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `workflow_id` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `from_stage_id` int(11) NOT NULL,
  `to_stage_id` int(11) NOT NULL,
  `options` text NOT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_checked_out` (`checked_out`),
  KEY `idx_from_stage_id` (`from_stage_id`),
  KEY `idx_to_stage_id` (`to_stage_id`),
  KEY `idx_workflow_id` (`workflow_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_transitions`  VALUES 
('1', '58', '1', '1', '1', 'UNPUBLISH', '', '-1', '1', '{\"publishing\":\"0\"}', NULL, NULL),
('2', '59', '2', '1', '1', 'PUBLISH', '', '-1', '1', '{\"publishing\":\"1\"}', NULL, NULL),
('3', '60', '3', '1', '1', 'TRASH', '', '-1', '1', '{\"publishing\":\"-2\"}', NULL, NULL),
('4', '61', '4', '1', '1', 'ARCHIVE', '', '-1', '1', '{\"publishing\":\"2\"}', NULL, NULL),
('5', '62', '5', '1', '1', 'FEATURE', '', '-1', '1', '{\"featuring\":\"1\"}', NULL, NULL),
('6', '63', '6', '1', '1', 'UNFEATURE', '', '-1', '1', '{\"featuring\":\"0\"}', NULL, NULL),
('7', '64', '7', '1', '1', 'PUBLISH_AND_FEATURE', '', '-1', '1', '{\"publishing\":\"1\",\"featuring\":\"1\"}', NULL, NULL);
/**ABDB**/CREATE TABLE `#__ucm_base` (
  `ucm_id` int(10) unsigned NOT NULL,
  `ucm_item_id` int(11) NOT NULL,
  `ucm_type_id` int(11) NOT NULL,
  `ucm_language_id` int(11) NOT NULL,
  PRIMARY KEY (`ucm_id`),
  KEY `idx_ucm_item_id` (`ucm_item_id`),
  KEY `idx_ucm_type_id` (`ucm_type_id`),
  KEY `idx_ucm_language_id` (`ucm_language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__ucm_base`  VALUES 
('1', '6', '1', '0'),
('2', '7', '1', '0'),
('3', '8', '1', '0'),
('4', '2', '1', '0'),
('5', '3', '1', '0');
/**ABDB**/CREATE TABLE `#__workflow_associations` (
  `item_id` int(11) NOT NULL DEFAULT 0 COMMENT 'Extension table id value',
  `stage_id` int(11) NOT NULL COMMENT 'Foreign Key to #__workflow_stages.id',
  `extension` varchar(50) NOT NULL,
  PRIMARY KEY (`item_id`,`extension`),
  KEY `idx_item_stage_extension` (`item_id`,`stage_id`,`extension`),
  KEY `idx_item_id` (`item_id`),
  KEY `idx_stage_id` (`stage_id`),
  KEY `idx_extension` (`extension`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_associations`  VALUES 
('1', '1', 'com_content.article'),
('2', '1', 'com_content.article'),
('3', '1', 'com_content.article'),
('4', '1', 'com_content.article'),
('5', '1', 'com_content.article'),
('6', '1', 'com_content.article'),
('7', '1', 'com_content.article'),
('8', '1', 'com_content.article'),
('9', '1', 'com_content.article'),
('10', '1', 'com_content.article'),
('11', '1', 'com_content.article');
/**ABDB**/CREATE TABLE `#__messages` (
  `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id_from` int(10) unsigned NOT NULL DEFAULT 0,
  `user_id_to` int(10) unsigned NOT NULL DEFAULT 0,
  `folder_id` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `date_time` datetime NOT NULL,
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `subject` varchar(255) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  PRIMARY KEY (`message_id`),
  KEY `useridto_state` (`user_id_to`,`state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__akeebabackup_backups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL,
  `comment` longtext DEFAULT NULL,
  `backupstart` timestamp NULL DEFAULT NULL,
  `backupend` timestamp NULL DEFAULT NULL,
  `status` enum('run','fail','complete') NOT NULL DEFAULT 'run',
  `origin` varchar(30) NOT NULL DEFAULT 'backend',
  `type` varchar(30) NOT NULL DEFAULT 'full',
  `profile_id` bigint(20) NOT NULL DEFAULT 1,
  `archivename` longtext DEFAULT NULL,
  `absolute_path` longtext DEFAULT NULL,
  `multipart` int(11) NOT NULL DEFAULT 0,
  `tag` varchar(255) DEFAULT NULL,
  `backupid` varchar(255) DEFAULT NULL,
  `filesexist` tinyint(4) NOT NULL DEFAULT 1,
  `remote_filename` varchar(1000) DEFAULT NULL,
  `total_size` bigint(20) NOT NULL DEFAULT 0,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  `instep` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_fullstatus` (`filesexist`,`status`),
  KEY `idx_stale` (`status`,`origin`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__akeebabackup_backups`  VALUES 
('4', 'Backup taken on Thursday, 25 September 2025 09:41 UTC', '', '2025-09-25 09:41:19', '2025-09-25 09:41:20', 'complete', 'backend', 'full', '1', 'site-plazart.com-20250925-094119utc-ESFVEUD27wHwd9IF.zip', '/home/plazart/public_html/travelami/quickstart/administrator/components/com_akeebabackup/backup/site-plazart.com-20250925-094119utc-ESFVEUD27wHwd9IF.zip', '0', 'backend', 'id-20250925-094119-101322', '1', NULL, '0', '0', '1');
/**ABDB**/CREATE TABLE `#__content_rating` (
  `content_id` int(11) NOT NULL DEFAULT 0,
  `rating_sum` int(10) unsigned NOT NULL DEFAULT 0,
  `rating_count` int(10) unsigned NOT NULL DEFAULT 0,
  `lastip` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0,
  `lft` int(11) NOT NULL DEFAULT 0,
  `rgt` int(11) NOT NULL DEFAULT 0,
  `level` int(10) unsigned NOT NULL DEFAULT 0,
  `path` varchar(400) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `params` text NOT NULL,
  `metadesc` varchar(1024) NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) NOT NULL DEFAULT '' COMMENT 'The keywords for the page.',
  `metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL,
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL,
  `images` text NOT NULL,
  `urls` text NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tag_idx` (`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__tags`  VALUES 
('1', '0', '0', '13', '0', '', 'ROOT', 'root', '', '', '1', NULL, NULL, '1', '', '', '', '', '123', '2024-03-28 05:46:43', '', '123', '2024-03-28 05:46:43', '', '', '0', '*', '1', NULL, NULL),
('2', '1', '1', '2', '1', 'photography', 'Photography', 'photography', '', '', '1', NULL, NULL, '1', '{}', '', '', '{}', '123', '2024-04-02 02:55:06', '', '123', '2024-04-02 02:55:06', '{}', '{}', '0', '*', '1', NULL, NULL),
('3', '1', '3', '4', '1', 'leisure', 'Leisure', 'leisure', '', '', '1', NULL, NULL, '1', '{}', '', '', '{}', '123', '2024-04-02 02:55:06', '', '123', '2024-04-02 02:55:06', '{}', '{}', '0', '*', '1', NULL, NULL),
('4', '1', '5', '6', '1', 'hotel', 'Hotel', 'hotel', '', '', '1', NULL, NULL, '1', '{}', '', '', '{}', '123', '2024-05-07 02:48:22', '', '123', '2024-05-07 02:48:22', '{}', '{}', '0', '*', '1', NULL, NULL),
('5', '1', '7', '8', '1', 'travel-guide', 'Travel Guide', 'travel-guide', '', '', '1', NULL, NULL, '1', '{}', '', '', '{}', '123', '2024-05-07 02:49:00', '', '123', '2024-05-07 02:49:00', '{}', '{}', '0', '*', '1', NULL, NULL),
('6', '1', '9', '10', '1', 'review', 'Review', 'review', '', '', '1', NULL, NULL, '1', '{}', '', '', '{}', '123', '2024-05-07 02:49:33', '', '123', '2024-05-07 02:49:33', '{}', '{}', '0', '*', '1', NULL, NULL),
('7', '1', '11', '12', '1', 'restaurant', 'Restaurant', 'restaurant', '', '', '1', NULL, NULL, '1', '{}', '', '', '{}', '123', '2024-05-07 02:49:33', '', '123', '2024-05-07 02:49:33', '{}', '{}', '0', '*', '1', NULL, NULL);
/**ABDB**/CREATE TABLE `#__fields_categories` (
  `field_id` int(11) NOT NULL DEFAULT 0,
  `category_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`field_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__fields_categories`  VALUES 
('1', '8'),
('2', '8'),
('3', '8'),
('4', '8');
/**ABDB**/CREATE TABLE `#__privacy_requests` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(100) NOT NULL DEFAULT '',
  `requested_at` datetime NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 0,
  `request_type` varchar(25) NOT NULL DEFAULT '',
  `confirm_token` varchar(100) NOT NULL DEFAULT '',
  `confirm_token_created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__akeebabackup_storage` (
  `tag` varchar(255) NOT NULL,
  `lastupdate` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `data` longtext DEFAULT NULL,
  PRIMARY KEY (`tag`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__finder_taxonomy_map` (
  `link_id` int(10) unsigned NOT NULL,
  `node_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`node_id`),
  KEY `link_id` (`link_id`),
  KEY `node_id` (`node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__finder_taxonomy_map`  VALUES 
('1', '3'),
('1', '5'),
('1', '7'),
('1', '9'),
('2', '3'),
('2', '7'),
('2', '9'),
('2', '12'),
('3', '3'),
('3', '7'),
('3', '9'),
('3', '12'),
('4', '3'),
('4', '5'),
('4', '7'),
('4', '9'),
('5', '3'),
('5', '5'),
('5', '7'),
('5', '9'),
('6', '3'),
('6', '5'),
('6', '7'),
('6', '9'),
('7', '3'),
('7', '5'),
('7', '7'),
('7', '9'),
('8', '3'),
('8', '7'),
('8', '9'),
('8', '12'),
('9', '3'),
('9', '5'),
('9', '7'),
('9', '9'),
('10', '3'),
('10', '5'),
('10', '7'),
('10', '9'),
('11', '9'),
('11', '10'),
('12', '3'),
('12', '9'),
('12', '11'),
('12', '12');
/**ABDB**/CREATE TABLE `#__action_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `message_language_key` varchar(255) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  `log_date` datetime NOT NULL,
  `extension` varchar(50) NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT 0,
  `item_id` int(11) NOT NULL DEFAULT 0,
  `ip_address` varchar(40) NOT NULL DEFAULT '0.0.0.0',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_user_id_logdate` (`user_id`,`log_date`),
  KEY `idx_user_id_extension` (`user_id`,`extension`),
  KEY `idx_extension_item_id` (`extension`,`item_id`)
) ENGINE=InnoDB AUTO_INCREMENT=843 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__finder_terms` (
  `term_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `term` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `stem` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `common` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `phrase` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `weight` float unsigned NOT NULL DEFAULT 0,
  `soundex` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `links` int(11) NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`term_id`),
  UNIQUE KEY `idx_term_language` (`term`,`language`),
  KEY `idx_stem` (`stem`),
  KEY `idx_term_phrase` (`term`,`phrase`),
  KEY `idx_stem_phrase` (`stem`,`phrase`),
  KEY `idx_soundex_phrase` (`soundex`,`phrase`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=1296 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__webauthn_credentials` (
  `id` varchar(1000) NOT NULL COMMENT 'Credential ID',
  `user_id` varchar(128) NOT NULL COMMENT 'User handle',
  `label` varchar(190) NOT NULL COMMENT 'Human readable label',
  `credential` mediumtext NOT NULL COMMENT 'Credential source data, JSON format',
  PRIMARY KEY (`id`(100)),
  KEY `user_id` (`user_id`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__updates` (
  `update_id` int(11) NOT NULL AUTO_INCREMENT,
  `update_site_id` int(11) DEFAULT 0,
  `extension_id` int(11) DEFAULT 0,
  `name` varchar(100) DEFAULT '',
  `description` text NOT NULL,
  `element` varchar(100) DEFAULT '',
  `type` varchar(20) DEFAULT '',
  `folder` varchar(20) DEFAULT '',
  `client_id` tinyint(4) DEFAULT 0,
  `version` varchar(32) DEFAULT '',
  `data` text NOT NULL,
  `detailsurl` text NOT NULL,
  `infourl` text NOT NULL,
  `changelogurl` text DEFAULT NULL,
  `extra_query` varchar(1000) DEFAULT '',
  PRIMARY KEY (`update_id`)
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Available Updates';
/**ABDB**/INSERT INTO `#__updates`  VALUES 
('2', '2', '0', 'Afrikaans', '', 'pkg_af-ZA', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/af-ZA_details.xml', '', '', ''),
('3', '2', '0', 'Arabic Unitag', '', 'pkg_ar-AA', 'package', '', '0', '5.3.2.3', '', 'https://update.joomla.org/language/details5/ar-AA_details.xml', '', '', ''),
('4', '2', '0', 'Belarusian', '', 'pkg_be-BY', 'package', '', '0', '5.3.0.1', '', 'https://update.joomla.org/language/details5/be-BY_details.xml', '', '', ''),
('5', '2', '0', 'Bulgarian', '', 'pkg_bg-BG', 'package', '', '0', '5.3.1.4', '', 'https://update.joomla.org/language/details5/bg-BG_details.xml', '', '', ''),
('6', '2', '0', 'Catalan', '', 'pkg_ca-ES', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/ca-ES_details.xml', '', '', ''),
('7', '2', '0', 'Chinese, Simplified', '', 'pkg_zh-CN', 'package', '', '0', '5.1.2.1', '', 'https://update.joomla.org/language/details5/zh-CN_details.xml', '', '', ''),
('8', '2', '0', 'Chinese, Traditional', '', 'pkg_zh-TW', 'package', '', '0', '5.3.1.1', '', 'https://update.joomla.org/language/details5/zh-TW_details.xml', '', '', ''),
('9', '2', '0', 'Croatian', '', 'pkg_hr-HR', 'package', '', '0', '5.2.1.1', '', 'https://update.joomla.org/language/details5/hr-HR_details.xml', '', '', ''),
('10', '2', '0', 'Czech', '', 'pkg_cs-CZ', 'package', '', '0', '5.3.1.1', '', 'https://update.joomla.org/language/details5/cs-CZ_details.xml', '', '', ''),
('11', '2', '0', 'Danish', '', 'pkg_da-DK', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/da-DK_details.xml', '', '', ''),
('12', '2', '0', 'Dutch', '', 'pkg_nl-NL', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/nl-NL_details.xml', '', '', ''),
('13', '2', '0', 'English, Australia', '', 'pkg_en-AU', 'package', '', '0', '5.3.0.1', '', 'https://update.joomla.org/language/details5/en-AU_details.xml', '', '', ''),
('14', '2', '0', 'English, Canada', '', 'pkg_en-CA', 'package', '', '0', '5.3.0.1', '', 'https://update.joomla.org/language/details5/en-CA_details.xml', '', '', ''),
('15', '2', '0', 'English, New Zealand', '', 'pkg_en-NZ', 'package', '', '0', '5.3.0.1', '', 'https://update.joomla.org/language/details5/en-NZ_details.xml', '', '', ''),
('16', '2', '0', 'English, USA', '', 'pkg_en-US', 'package', '', '0', '5.3.0.1', '', 'https://update.joomla.org/language/details5/en-US_details.xml', '', '', ''),
('17', '2', '0', 'Estonian', '', 'pkg_et-EE', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/et-EE_details.xml', '', '', ''),
('18', '2', '0', 'Finnish', '', 'pkg_fi-FI', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/fi-FI_details.xml', '', '', ''),
('19', '2', '0', 'Flemish', '', 'pkg_nl-BE', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/nl-BE_details.xml', '', '', ''),
('20', '2', '0', 'French', '', 'pkg_fr-FR', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/fr-FR_details.xml', '', '', ''),
('21', '2', '0', 'French, Canada', '', 'pkg_fr-CA', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/fr-CA_details.xml', '', '', ''),
('22', '2', '0', 'Georgian', '', 'pkg_ka-GE', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/ka-GE_details.xml', '', '', ''),
('23', '2', '0', 'German', '', 'pkg_de-DE', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/de-DE_details.xml', '', '', ''),
('24', '2', '0', 'German, Austria', '', 'pkg_de-AT', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/de-AT_details.xml', '', '', ''),
('25', '2', '0', 'German, Liechtenstein', '', 'pkg_de-LI', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/de-LI_details.xml', '', '', ''),
('26', '2', '0', 'German, Luxembourg', '', 'pkg_de-LU', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/de-LU_details.xml', '', '', ''),
('27', '2', '0', 'German, Switzerland', '', 'pkg_de-CH', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/de-CH_details.xml', '', '', ''),
('28', '2', '0', 'Greek', '', 'pkg_el-GR', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/el-GR_details.xml', '', '', ''),
('29', '2', '0', 'Hungarian', '', 'pkg_hu-HU', 'package', '', '0', '5.3.1.1', '', 'https://update.joomla.org/language/details5/hu-HU_details.xml', '', '', ''),
('30', '2', '0', 'Italian', '', 'pkg_it-IT', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/it-IT_details.xml', '', '', ''),
('31', '2', '0', 'Japanese', '', 'pkg_ja-JP', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/ja-JP_details.xml', '', '', ''),
('32', '2', '0', 'Kazakh', '', 'pkg_kk-KZ', 'package', '', '0', '5.0.0.4', '', 'https://update.joomla.org/language/details5/kk-KZ_details.xml', '', '', ''),
('33', '2', '0', 'Korean', '', 'pkg_ko-KR', 'package', '', '0', '5.0.2.1', '', 'https://update.joomla.org/language/details5/ko-KR_details.xml', '', '', ''),
('34', '2', '0', 'Latvian', '', 'pkg_lv-LV', 'package', '', '0', '5.2.4.1', '', 'https://update.joomla.org/language/details5/lv-LV_details.xml', '', '', ''),
('35', '2', '0', 'Lithuanian', '', 'pkg_lt-LT', 'package', '', '0', '5.3.0.1', '', 'https://update.joomla.org/language/details5/lt-LT_details.xml', '', '', ''),
('36', '2', '0', 'Norwegian Bokmål', '', 'pkg_nb-NO', 'package', '', '0', '5.2.3.1', '', 'https://update.joomla.org/language/details5/nb-NO_details.xml', '', '', ''),
('37', '2', '0', 'Pashto Afghanistan', '', 'pkg_ps-AF', 'package', '', '0', '5.0.1.1', '', 'https://update.joomla.org/language/details5/ps-AF_details.xml', '', '', ''),
('38', '2', '0', 'Persian Farsi', '', 'pkg_fa-IR', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/fa-IR_details.xml', '', '', ''),
('39', '2', '0', 'Polish', '', 'pkg_pl-PL', 'package', '', '0', '5.3.3.2', '', 'https://update.joomla.org/language/details5/pl-PL_details.xml', '', '', ''),
('40', '2', '0', 'Portuguese, Brazil', '', 'pkg_pt-BR', 'package', '', '0', '5.3.0.1', '', 'https://update.joomla.org/language/details5/pt-BR_details.xml', '', '', ''),
('41', '2', '0', 'Portuguese, Portugal', '', 'pkg_pt-PT', 'package', '', '0', '5.2.2.1', '', 'https://update.joomla.org/language/details5/pt-PT_details.xml', '', '', ''),
('42', '2', '0', 'Romanian', '', 'pkg_ro-RO', 'package', '', '0', '5.3.1.1', '', 'https://update.joomla.org/language/details5/ro-RO_details.xml', '', '', ''),
('43', '2', '0', 'Russian', '', 'pkg_ru-RU', 'package', '', '0', '5.3.0.1', '', 'https://update.joomla.org/language/details5/ru-RU_details.xml', '', '', ''),
('44', '2', '0', 'Serbian, Cyrillic', '', 'pkg_sr-RS', 'package', '', '0', '5.3.1.1', '', 'https://update.joomla.org/language/details5/sr-RS_details.xml', '', '', ''),
('45', '2', '0', 'Serbian, Latin', '', 'pkg_sr-YU', 'package', '', '0', '5.3.3.2', '', 'https://update.joomla.org/language/details5/sr-YU_details.xml', '', '', ''),
('46', '2', '0', 'Slovak', '', 'pkg_sk-SK', 'package', '', '0', '5.2.6.1', '', 'https://update.joomla.org/language/details5/sk-SK_details.xml', '', '', ''),
('47', '2', '0', 'Slovenian', '', 'pkg_sl-SI', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/sl-SI_details.xml', '', '', ''),
('48', '2', '0', 'Spanish', '', 'pkg_es-ES', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/es-ES_details.xml', '', '', ''),
('49', '2', '0', 'Swedish', '', 'pkg_sv-SE', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/sv-SE_details.xml', '', '', ''),
('50', '2', '0', 'Tamil, India', '', 'pkg_ta-IN', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/ta-IN_details.xml', '', '', ''),
('51', '2', '0', 'Thai', '', 'pkg_th-TH', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/th-TH_details.xml', '', '', ''),
('52', '2', '0', 'Turkish', '', 'pkg_tr-TR', 'package', '', '0', '5.3.3.3', '', 'https://update.joomla.org/language/details5/tr-TR_details.xml', '', '', ''),
('53', '2', '0', 'Ukrainian', '', 'pkg_uk-UA', 'package', '', '0', '5.1.3.1', '', 'https://update.joomla.org/language/details5/uk-UA_details.xml', '', '', ''),
('54', '2', '0', 'Urdu, Pakistan', '', 'pkg_ur-PK', 'package', '', '0', '5.1.2.1', '', 'https://update.joomla.org/language/details5/ur-PK_details.xml', '', '', ''),
('55', '2', '0', 'Welsh', '', 'pkg_cy-GB', 'package', '', '0', '5.3.3.1', '', 'https://update.joomla.org/language/details5/cy-GB_details.xml', '', '', '');
/**ABDB**/CREATE TABLE `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) unsigned NOT NULL,
  `banner_id` int(10) unsigned NOT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__finder_terms_common` (
  `term` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `language` char(7) NOT NULL DEFAULT '',
  `custom` int(11) NOT NULL DEFAULT 0,
  UNIQUE KEY `idx_term_language` (`term`,`language`),
  KEY `idx_lang` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__finder_terms_common`  VALUES 
('a', 'en', '0'),
('about', 'en', '0'),
('above', 'en', '0'),
('after', 'en', '0'),
('again', 'en', '0'),
('against', 'en', '0'),
('all', 'en', '0'),
('am', 'en', '0'),
('an', 'en', '0'),
('and', 'en', '0'),
('any', 'en', '0'),
('are', 'en', '0'),
('aren\'t', 'en', '0'),
('as', 'en', '0'),
('at', 'en', '0'),
('be', 'en', '0'),
('because', 'en', '0'),
('been', 'en', '0'),
('before', 'en', '0'),
('being', 'en', '0'),
('below', 'en', '0'),
('between', 'en', '0'),
('both', 'en', '0'),
('but', 'en', '0'),
('by', 'en', '0'),
('can\'t', 'en', '0'),
('cannot', 'en', '0'),
('could', 'en', '0'),
('couldn\'t', 'en', '0'),
('did', 'en', '0'),
('didn\'t', 'en', '0'),
('do', 'en', '0'),
('does', 'en', '0'),
('doesn\'t', 'en', '0'),
('doing', 'en', '0'),
('don\'t', 'en', '0'),
('down', 'en', '0'),
('during', 'en', '0'),
('each', 'en', '0'),
('few', 'en', '0'),
('for', 'en', '0'),
('from', 'en', '0'),
('further', 'en', '0'),
('had', 'en', '0'),
('hadn\'t', 'en', '0'),
('has', 'en', '0'),
('hasn\'t', 'en', '0'),
('have', 'en', '0'),
('haven\'t', 'en', '0'),
('having', 'en', '0'),
('he', 'en', '0'),
('he\'d', 'en', '0'),
('he\'ll', 'en', '0'),
('he\'s', 'en', '0'),
('her', 'en', '0'),
('here', 'en', '0'),
('here\'s', 'en', '0'),
('hers', 'en', '0'),
('herself', 'en', '0'),
('him', 'en', '0'),
('himself', 'en', '0'),
('his', 'en', '0'),
('how', 'en', '0'),
('how\'s', 'en', '0'),
('i', 'en', '0'),
('i\'d', 'en', '0'),
('i\'ll', 'en', '0'),
('i\'m', 'en', '0'),
('i\'ve', 'en', '0'),
('if', 'en', '0'),
('in', 'en', '0'),
('into', 'en', '0'),
('is', 'en', '0'),
('isn\'t', 'en', '0'),
('it', 'en', '0'),
('it\'s', 'en', '0'),
('its', 'en', '0'),
('itself', 'en', '0'),
('let\'s', 'en', '0'),
('me', 'en', '0'),
('more', 'en', '0'),
('most', 'en', '0'),
('mustn\'t', 'en', '0'),
('my', 'en', '0'),
('myself', 'en', '0'),
('no', 'en', '0'),
('nor', 'en', '0'),
('not', 'en', '0'),
('of', 'en', '0'),
('off', 'en', '0'),
('on', 'en', '0'),
('once', 'en', '0'),
('only', 'en', '0'),
('or', 'en', '0'),
('other', 'en', '0'),
('ought', 'en', '0'),
('our', 'en', '0'),
('ours', 'en', '0'),
('ourselves', 'en', '0'),
('out', 'en', '0'),
('over', 'en', '0'),
('own', 'en', '0'),
('same', 'en', '0'),
('shan\'t', 'en', '0'),
('she', 'en', '0'),
('she\'d', 'en', '0'),
('she\'ll', 'en', '0'),
('she\'s', 'en', '0'),
('should', 'en', '0'),
('shouldn\'t', 'en', '0'),
('so', 'en', '0'),
('some', 'en', '0'),
('such', 'en', '0'),
('than', 'en', '0'),
('that', 'en', '0'),
('that\'s', 'en', '0'),
('the', 'en', '0'),
('their', 'en', '0'),
('theirs', 'en', '0'),
('them', 'en', '0'),
('themselves', 'en', '0'),
('then', 'en', '0'),
('there', 'en', '0'),
('there\'s', 'en', '0'),
('these', 'en', '0'),
('they', 'en', '0'),
('they\'d', 'en', '0'),
('they\'ll', 'en', '0'),
('they\'re', 'en', '0'),
('they\'ve', 'en', '0'),
('this', 'en', '0'),
('those', 'en', '0'),
('through', 'en', '0'),
('to', 'en', '0'),
('too', 'en', '0'),
('under', 'en', '0'),
('until', 'en', '0'),
('up', 'en', '0'),
('very', 'en', '0'),
('was', 'en', '0'),
('wasn\'t', 'en', '0'),
('we', 'en', '0'),
('we\'d', 'en', '0'),
('we\'ll', 'en', '0'),
('we\'re', 'en', '0'),
('we\'ve', 'en', '0'),
('were', 'en', '0'),
('weren\'t', 'en', '0'),
('what', 'en', '0'),
('what\'s', 'en', '0'),
('when', 'en', '0'),
('when\'s', 'en', '0'),
('where', 'en', '0'),
('where\'s', 'en', '0'),
('which', 'en', '0'),
('while', 'en', '0'),
('who', 'en', '0'),
('who\'s', 'en', '0'),
('whom', 'en', '0'),
('why', 'en', '0'),
('why\'s', 'en', '0'),
('with', 'en', '0'),
('won\'t', 'en', '0'),
('would', 'en', '0'),
('wouldn\'t', 'en', '0'),
('you', 'en', '0'),
('you\'d', 'en', '0'),
('you\'ll', 'en', '0'),
('you\'re', 'en', '0'),
('you\'ve', 'en', '0'),
('your', 'en', '0'),
('yours', 'en', '0'),
('yourself', 'en', '0'),
('yourselves', 'en', '0');
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_content_category_map` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contentid` int(11) NOT NULL DEFAULT 0,
  `catid` int(11) NOT NULL DEFAULT 0,
  `main` tinyint(4) NOT NULL COMMENT 'Main Category',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/**ABDB**/INSERT INTO `#__tz_portfolio_plus_content_category_map`  VALUES 
('1', '1', '2', '1'),
('2', '2', '2', '1'),
('3', '4', '2', '1'),
('4', '5', '2', '1'),
('5', '6', '2', '1'),
('6', '7', '2', '1'),
('7', '8', '2', '1'),
('8', '9', '2', '1'),
('9', '10', '2', '1'),
('10', '11', '2', '1'),
('11', '12', '2', '1'),
('12', '13', '2', '1');
/**ABDB**/CREATE TABLE `#__usergroups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Adjacency List Reference Id',
  `lft` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set rgt.',
  `title` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_usergroup_parent_title_lookup` (`parent_id`,`title`),
  KEY `idx_usergroup_title_lookup` (`title`),
  KEY `idx_usergroup_adjacency_lookup` (`parent_id`),
  KEY `idx_usergroup_nested_set_lookup` (`lft`,`rgt`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__usergroups`  VALUES 
('1', '0', '1', '18', 'Public'),
('2', '1', '8', '15', 'Registered'),
('3', '2', '9', '14', 'Author'),
('4', '3', '10', '13', 'Editor'),
('5', '4', '11', '12', 'Publisher'),
('6', '1', '4', '7', 'Manager'),
('7', '6', '5', '6', 'Administrator'),
('8', '1', '16', '17', 'Super Users'),
('9', '1', '2', '3', 'Guest');
/**ABDB**/CREATE TABLE `#__modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `title` varchar(100) NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `content` text DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `position` varchar(50) NOT NULL DEFAULT '',
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `module` varchar(50) DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `showtitle` tinyint(3) unsigned NOT NULL DEFAULT 1,
  `params` text NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=128 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__modules`  VALUES 
('1', '39', 'Main Menu', '', '', '2', 'sidebar-right', NULL, NULL, NULL, NULL, '1', 'mod_menu', '1', '1', '{\"menutype\":\"mainmenu\",\"base\":\"\",\"startLevel\":1,\"endLevel\":0,\"showAllChildren\":1,\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('2', '40', 'Login', '', '', '1', 'login', NULL, NULL, NULL, NULL, '1', 'mod_login', '1', '1', '', '1', '*'),
('3', '41', 'Popular Articles', '', '', '6', 'cpanel', NULL, NULL, NULL, NULL, '1', 'mod_popular', '3', '1', '{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\": \"12\",\"header_tag\":\"h2\"}', '1', '*'),
('4', '42', 'Recently Added Articles', '', '', '4', 'cpanel', NULL, NULL, NULL, NULL, '1', 'mod_latest', '3', '1', '{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\": \"12\",\"header_tag\":\"h2\"}', '1', '*'),
('8', '43', 'Toolbar', '', '', '1', 'toolbar', NULL, NULL, NULL, NULL, '1', 'mod_toolbar', '3', '1', '', '1', '*'),
('9', '44', 'Notifications', '', '', '3', 'icon', NULL, NULL, NULL, NULL, '1', 'mod_quickicon', '3', '1', '{\"context\":\"update_quickicon\",\"header_icon\":\"icon-sync\",\"show_jupdate\":\"1\",\"show_eupdate\":\"1\",\"show_oupdate\":\"1\",\"show_privacy\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', '1', '*'),
('10', '45', 'Logged-in Users', '', '', '2', 'cpanel', NULL, NULL, NULL, NULL, '1', 'mod_logged', '3', '1', '{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\": \"12\",\"header_tag\":\"h2\"}', '1', '*'),
('12', '46', 'Admin Menu', '', '', '1', 'menu', NULL, NULL, NULL, NULL, '1', 'mod_menu', '3', '1', '{\"layout\":\"\",\"moduleclass_sfx\":\"\",\"shownew\":\"1\",\"showhelp\":\"1\",\"cache\":\"0\"}', '1', '*'),
('15', '49', 'Title', '', '', '1', 'title', NULL, NULL, NULL, NULL, '1', 'mod_title', '3', '1', '', '1', '*'),
('16', '50', 'Login Form', '', '', '2', 'sidebar-right', NULL, NULL, NULL, NULL, '1', 'mod_login', '1', '1', '{\"pretext\":\"\",\"posttext\":\"\",\"login\":\"\",\"logout\":\"\",\"customRegLinkMenu\":\"\",\"greeting\":1,\"name\":0,\"profilelink\":0,\"usetext\":0,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('17', '51', 'Breadcrumbs', '', '', '1', 'breadcrumbs', NULL, NULL, NULL, NULL, '1', 'mod_breadcrumbs', '1', '1', '{\"moduleclass_sfx\":\"\",\"showHome\":\"1\",\"homeText\":\"\",\"showComponent\":\"1\",\"separator\":\"\",\"cache\":\"0\",\"cache_time\":\"0\",\"cachemode\":\"itemid\"}', '0', '*'),
('79', '52', 'Multilanguage status', '', '', '2', 'status', NULL, NULL, NULL, NULL, '1', 'mod_multilangstatus', '3', '1', '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', '1', '*'),
('86', '53', 'Joomla Version', '', '', '1', 'status', NULL, NULL, NULL, NULL, '1', 'mod_version', '3', '1', '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', '1', '*'),
('87', '55', 'Sample Data', '', '', '1', 'cpanel', NULL, NULL, NULL, NULL, '1', 'mod_sampledata', '6', '1', '{\"bootstrap_size\": \"12\",\"header_tag\":\"h2\"}', '1', '*'),
('88', '67', 'Latest Actions', '', '', '3', 'cpanel', NULL, NULL, NULL, NULL, '1', 'mod_latestactions', '6', '1', '{\"bootstrap_size\": \"12\",\"header_tag\":\"h2\"}', '1', '*'),
('89', '68', 'Privacy Dashboard', '', '', '5', 'cpanel', NULL, NULL, NULL, NULL, '1', 'mod_privacy_dashboard', '6', '1', '{\"bootstrap_size\": \"12\",\"header_tag\":\"h2\"}', '1', '*'),
('90', '89', 'Login Support', '', '', '1', 'sidebar', NULL, NULL, NULL, NULL, '1', 'mod_loginsupport', '1', '1', '{\"forum_url\":\"https://forum.joomla.org/\",\"documentation_url\":\"https://docs.joomla.org/\",\"news_url\":\"https://www.joomla.org/announcements.html\",\"automatic_title\":1,\"prepare_content\":1,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '1', '*'),
('91', '72', 'System Dashboard', '', '', '1', 'cpanel-system', NULL, NULL, NULL, NULL, '1', 'mod_submenu', '1', '0', '{\"menutype\":\"*\",\"preset\":\"system\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', '1', '*'),
('92', '73', 'Content Dashboard', '', '', '1', 'cpanel-content', NULL, NULL, NULL, NULL, '1', 'mod_submenu', '1', '0', '{\"menutype\":\"*\",\"preset\":\"content\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', '1', '*'),
('93', '74', 'Menus Dashboard', '', '', '1', 'cpanel-menus', NULL, NULL, NULL, NULL, '1', 'mod_submenu', '1', '0', '{\"menutype\":\"*\",\"preset\":\"menus\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', '1', '*'),
('94', '75', 'Components Dashboard', '', '', '1', 'cpanel-components', NULL, NULL, NULL, NULL, '1', 'mod_submenu', '1', '0', '{\"menutype\":\"*\",\"preset\":\"components\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', '1', '*'),
('95', '76', 'Users Dashboard', '', '', '1', 'cpanel-users', NULL, NULL, NULL, NULL, '1', 'mod_submenu', '1', '0', '{\"menutype\":\"*\",\"preset\":\"users\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', '1', '*'),
('96', '86', 'Popular Articles', '', '', '3', 'cpanel-content', NULL, NULL, NULL, NULL, '1', 'mod_popular', '3', '1', '{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\": \"12\",\"header_tag\":\"h2\"}', '1', '*'),
('97', '87', 'Recently Added Articles', '', '', '4', 'cpanel-content', NULL, NULL, NULL, NULL, '1', 'mod_latest', '3', '1', '{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\": \"12\",\"header_tag\":\"h2\"}', '1', '*'),
('98', '88', 'Logged-in Users', '', '', '2', 'cpanel-users', NULL, NULL, NULL, NULL, '1', 'mod_logged', '3', '1', '{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\": \"12\",\"header_tag\":\"h2\"}', '1', '*'),
('99', '77', 'Frontend Link', '', '', '5', 'status', NULL, NULL, NULL, NULL, '1', 'mod_frontend', '1', '1', '', '1', '*'),
('100', '78', 'Messages', '', '', '4', 'status', NULL, NULL, NULL, NULL, '1', 'mod_messages', '3', '1', '', '1', '*'),
('101', '79', 'Post Install Messages', '', '', '3', 'status', NULL, NULL, NULL, NULL, '1', 'mod_post_installation_messages', '3', '1', '', '1', '*'),
('102', '80', 'User Status', '', '', '6', 'status', NULL, NULL, NULL, NULL, '1', 'mod_user', '3', '1', '', '1', '*'),
('103', '70', 'Site', '', '', '1', 'icon', NULL, NULL, NULL, NULL, '1', 'mod_quickicon', '1', '1', '{\"context\":\"site_quickicon\",\"header_icon\":\"icon-desktop\",\"show_users\":\"1\",\"show_articles\":\"1\",\"show_categories\":\"1\",\"show_media\":\"1\",\"show_menuItems\":\"1\",\"show_modules\":\"1\",\"show_plugins\":\"1\",\"show_templates\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', '1', '*'),
('104', '71', 'System', '', '', '2', 'icon', NULL, NULL, NULL, NULL, '1', 'mod_quickicon', '1', '1', '{\"context\":\"system_quickicon\",\"header_icon\":\"icon-wrench\",\"show_global\":\"1\",\"show_checkin\":\"1\",\"show_cache\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', '1', '*'),
('105', '82', '3rd Party', '', '', '4', 'icon', NULL, NULL, NULL, NULL, '1', 'mod_quickicon', '1', '1', '{\"context\":\"mod_quickicon\",\"header_icon\":\"icon-boxes\",\"load_plugins\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', '1', '*'),
('106', '83', 'Help Dashboard', '', '', '1', 'cpanel-help', NULL, NULL, NULL, NULL, '1', 'mod_submenu', '1', '0', '{\"menutype\":\"*\",\"preset\":\"help\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"style\":\"System-none\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', '1', '*'),
('107', '84', 'Privacy Requests', '', '', '1', 'cpanel-privacy', NULL, NULL, NULL, NULL, '1', 'mod_privacy_dashboard', '1', '1', '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', '1', '*'),
('108', '85', 'Privacy Status', '', '', '1', 'cpanel-privacy', NULL, NULL, NULL, NULL, '1', 'mod_privacy_status', '1', '1', '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', '1', '*'),
('109', '96', 'Guided Tours', '', '', '1', 'status', NULL, NULL, NULL, NULL, '1', 'mod_guidedtours', '1', '1', '', '1', '*'),
('110', '100', 'Astroid Clear Cache', '', '', '1', 'status', NULL, NULL, NULL, NULL, '1', 'mod_astroid_clear_cache', '1', '1', '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\"}', '1', '*'),
('111', '101', 'Astroid Menu', '', '', '1', 'status', NULL, NULL, NULL, NULL, '1', 'mod_astroid_menu', '1', '1', '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\"}', '0', '*'),
('112', '110', 'TZ Portfolio Plus Archived Articles', '', '', '1', '', NULL, NULL, NULL, NULL, '0', 'mod_tz_portfolio_plus_articles_archive', '1', '1', '', '0', '*'),
('113', '111', 'TZ Portfolio Plus Categories', '', '', '2', '', NULL, NULL, NULL, NULL, '0', 'mod_tz_portfolio_plus_categories', '1', '1', '', '0', '*'),
('114', '112', 'TZ Portfolio Plus Filter', '', '', '3', '', NULL, NULL, NULL, NULL, '0', 'mod_tz_portfolio_plus_filter', '1', '1', '', '0', '*'),
('115', '113', 'TZ Portfolio Plus Portfolio', '', '', '4', '', NULL, NULL, NULL, NULL, '0', 'mod_tz_portfolio_plus_portfolio', '1', '1', '', '0', '*'),
('116', '114', 'TZ Portfolio Plus Tags', '', '', '5', '', NULL, NULL, NULL, NULL, '0', 'mod_tz_portfolio_plus_tags', '1', '1', '', '0', '*'),
('117', '151', 'Search', '', NULL, '3', 'sidebar-right', NULL, NULL, NULL, NULL, '0', 'mod_finder', '1', '1', '{\"searchfilter\":\"\",\"show_autosuggest\":1,\"show_advanced\":1,\"show_label\":1,\"alt_label\":\"\",\"show_button\":0,\"opensearch\":1,\"opensearch_name\":\"\",\"set_itemid\":102,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('118', '156', 'Search', '', NULL, '1', 'sidebar-left', NULL, NULL, NULL, NULL, '1', 'mod_tz_portfolio_plus_filter', '1', '1', '{\"template_id\":\"0\",\"show_search_word\":\"1\",\"show_box_label\":\"1\",\"label\":\"\",\"width\":\"\",\"text\":\"\",\"button\":\"1\",\"imagebutton\":\"0\",\"icon\":\"\",\"icon_class\":\"\",\"button_text\":\"Search\",\"button_style\":\"btn-primary\",\"button_width\":\"\",\"search_inline\":\"0\",\"show_category\":\"1\",\"category_text\":\"\",\"show_category_text\":\"1\",\"parent_cat\":\"0\",\"show_parent_root\":\"0\",\"show_fields\":\"1\",\"fields\":[\"6\",\"1\",\"3\",\"4\",\"2\",\"5\"],\"show_group_title\":\"0\",\"set_itemid\":\"117\",\"column_lg\":\"1\",\"column_md\":\"1\",\"column_sm\":\"1\",\"column\":\"1\",\"gutter\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"enable_bootstrap\":\"0\",\"bootstrapversion\":\"3\",\"enable_bootstrap_js\":\"1\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('119', '165', 'Tags', '', NULL, '4', 'sidebar-right', NULL, NULL, NULL, NULL, '1', 'mod_tags_popular', '1', '1', '{\"maximum\":5,\"timeframe\":\"alltime\",\"order_value\":\"count\",\"order_direction\":1,\"display_count\":1,\"no_results_text\":0,\"minsize\":1,\"maxsize\":2,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"owncache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('120', '166', 'About Travelami', '', '<p><img class=\"rounded-3\" src=\"images/felix-rostig-UmV2wr-Vbq8-unsplash.jpg\" width=\"1380\" height=\"900\" loading=\"lazy\" data-path=\"local-images:/felix-rostig-UmV2wr-Vbq8-unsplash.jpg\"></p>\r\n<p>Our travel experts live and breathe the destinations they specialise in. This shows in their passion for creating our clients’ unique holidays. We offer journeys of distinction, just truly unforgettable journeys unlike any other.</p>', '1', 'sidebar-right', NULL, NULL, NULL, NULL, '1', 'mod_custom', '1', '1', '{\"prepare_content\":0,\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('121', '171', 'Filter - Main Top - Dark bg', '', NULL, '1', 'main-top', NULL, NULL, NULL, NULL, '1', 'mod_tz_portfolio_plus_filter', '1', '0', '{\"template_id\":\"0\",\"show_search_word\":\"0\",\"show_box_label\":\"1\",\"label\":\"\",\"width\":\"\",\"text\":\"\",\"button\":\"1\",\"imagebutton\":\"0\",\"icon\":\"\",\"icon_class\":\"\",\"button_text\":\"Search\",\"button_style\":\"btn-light\",\"button_width\":\"\",\"search_inline\":\"1\",\"show_category\":\"0\",\"category_text\":\"\",\"show_category_text\":\"1\",\"parent_cat\":\"0\",\"show_parent_root\":\"0\",\"show_fields\":\"1\",\"fields\":[\"6\",\"1\",\"2\"],\"show_group_title\":\"0\",\"set_itemid\":\"117\",\"column_lg\":\"auto\",\"column_md\":\"auto\",\"column_sm\":\"1\",\"column\":\"1\",\"gutter\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"enable_bootstrap\":\"0\",\"bootstrapversion\":\"3\",\"enable_bootstrap_js\":\"1\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('122', '173', 'mod_tz_portfolio_plus_carousel', '', '', '6', '', NULL, NULL, NULL, NULL, '0', 'mod_tz_portfolio_plus_carousel', '1', '1', '', '0', '*'),
('123', '174', 'Most Popular Tour', '', NULL, '1', 'main-bottom', NULL, NULL, NULL, NULL, '1', 'mod_tz_portfolio_plus_portfolio', '1', '0', '{\"catid\":[\"2\"],\"media_types\":[\"\"],\"template_id\":\"0\",\"show_title\":\"1\",\"show_introtext\":\"1\",\"introtext_limit\":\"\",\"show_created_date\":\"0\",\"show_hit\":\"0\",\"show_author\":\"0\",\"show_category\":\"0\",\"show_tag\":\"0\",\"show_readmore\":\"0\",\"readmore_text\":\"Read more\",\"show_view_all\":\"0\",\"view_all_link\":\"\",\"view_all_text\":\"View All Portfolios\",\"view_all_target\":\"\",\"article_limit\":\"6\",\"show_featured\":\"1\",\"random_article\":\"0\",\"orderby_pri\":\"none\",\"orderby_sec\":\"rdate\",\"order_date\":\"created\",\"usermenuitem\":\"117\",\"tagmenuitem\":\"117\",\"load_style\":\"0\",\"width_element\":\"450\",\"height_element\":\"\",\"show_filter\":\"0\",\"tz_filter_type\":\"categories\",\"enable_resize_image\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"enable_bootstrap\":\"0\",\"bootstrapversion\":\"3\",\"enable_bootstrap_js\":\"1\",\"enable_lazyload\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"show_cat_vote\":\"0\",\"show_counter\":\"1\",\"unrated\":\"1\",\"ct_vote_notice_layout\":\"growl\",\"ct_vote_notice_effect\":\"scale\",\"ct_vote_notice_ttl\":\"3000\",\"mt_show_image\":\"1\",\"mt_image_size\":\"o\",\"mt_img_gallery_switcher\":\"image\",\"mt_img_gallery_size\":\"o\",\"mt_img_gallery_flex_slideshow\":\"1\",\"mt_img_gallery_flex_show_arrows\":\"0\",\"mt_img_gallery_flex_show_controlNav\":\"1\",\"mt_img_gallery_flex_controlnav_type\":\"none\",\"mt_img_gallery_thumb_size\":\"o\",\"mt_img_gallery_flex_pausePlay\":\"0\",\"mt_img_gallery_flex_pauseOnAction\":\"1\",\"mt_img_gallery_flex_pauseOnHover\":\"0\",\"mt_img_gallery_flex_useCSS\":\"1\",\"mt_img_gallery_flex_direction\":\"horizontal\",\"mt_img_gallery_flex_animation\":\"none\",\"mt_img_gallery_flex_animSpeed\":\"7000\",\"mt_img_gallery_flex_anim_duration\":\"600\",\"mt_img_gallery_flex_animLoop\":\"1\",\"mt_img_gallery_flex_smoothHeight\":\"1\",\"mt_img_gallery_flex_randomize\":\"0\",\"mt_img_gallery_flex_startAt\":\"0\",\"mt_img_gallery_flex_itemWidth\":\"0\",\"mt_img_gallery_flex_itemMargin\":\"0\",\"mt_img_gallery_flex_minItems\":\"0\",\"mt_img_gallery_flex_maxItems\":\"0\"}', '0', '*'),
('124', '175', 'Astroid Menu - Mobile', '', NULL, '1', 'status', NULL, NULL, NULL, NULL, '1', 'mod_astroid_menu', '1', '1', '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\"}', '0', '*'),
('125', '176', 'Filter - Main Top - Light Bg', '', NULL, '1', 'main-top', NULL, NULL, NULL, NULL, '1', 'mod_tz_portfolio_plus_filter', '1', '0', '{\"template_id\":\"0\",\"show_search_word\":\"0\",\"show_box_label\":\"1\",\"label\":\"\",\"width\":\"\",\"text\":\"\",\"button\":\"1\",\"imagebutton\":\"0\",\"icon\":\"\",\"icon_class\":\"\",\"button_text\":\"Search\",\"button_style\":\"btn-dark\",\"button_width\":\"\",\"search_inline\":\"1\",\"show_category\":\"0\",\"category_text\":\"\",\"show_category_text\":\"1\",\"parent_cat\":\"0\",\"show_parent_root\":\"0\",\"show_fields\":\"1\",\"fields\":[\"6\",\"1\",\"2\"],\"show_group_title\":\"0\",\"set_itemid\":\"117\",\"column_lg\":\"auto\",\"column_md\":\"auto\",\"column_sm\":\"1\",\"column\":\"1\",\"gutter\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"enable_bootstrap\":\"0\",\"bootstrapversion\":\"3\",\"enable_bootstrap_js\":\"1\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('126', '178', 'Travelami Ltd', '', '<p>The island of Crete offers a rare mix of splendid beaches, amazing mountain landscapes, vibrant towns and cosy villages inhabited by warm-hearted locals, all this spiced with genuine local cuisine, excellent wine, and perhaps a shot of raki!</p>\r\n<p>The south-west part of the island is characterized by a unique landscape of scenic gorges and a coast full of secluded beaches and deep blue waters. During the last walk of the trip, you explore the impressive Aradena Gorge, a challenging but rewarding walk you’ll never forget.</p>', '1', 'offcanvas', NULL, NULL, NULL, NULL, '1', 'mod_custom', '1', '1', '{\"prepare_content\":0,\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('127', '180', 'Astroid Layout Module', '', '', '7', '', NULL, NULL, NULL, NULL, '0', 'mod_astroid_layout', '1', '1', '', '0', '*');
/**ABDB**/CREATE TABLE `#__user_usergroup_map` (
  `user_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Foreign Key to #__users.id',
  `group_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Foreign Key to #__usergroups.id',
  PRIMARY KEY (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__user_usergroup_map`  VALUES 
('123', '8');
/**ABDB**/CREATE TABLE `#__extensions` (
  `extension_id` int(11) NOT NULL AUTO_INCREMENT,
  `package_id` int(11) NOT NULL DEFAULT 0 COMMENT 'Parent package ID for extensions installed as a package.',
  `name` varchar(100) NOT NULL,
  `type` varchar(20) NOT NULL,
  `element` varchar(100) NOT NULL,
  `changelogurl` text DEFAULT NULL,
  `folder` varchar(100) NOT NULL,
  `client_id` tinyint(4) NOT NULL,
  `enabled` tinyint(4) NOT NULL DEFAULT 0,
  `access` int(10) unsigned NOT NULL DEFAULT 1,
  `protected` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'Flag to indicate if the extension is protected. Protected extensions cannot be disabled.',
  `locked` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'Flag to indicate if the extension is locked. Locked extensions cannot be uninstalled.',
  `manifest_cache` text NOT NULL,
  `params` text NOT NULL,
  `custom_data` text NOT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int(11) DEFAULT 0,
  `state` int(11) DEFAULT 0,
  `note` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`extension_id`),
  KEY `element_clientid` (`element`,`client_id`),
  KEY `element_folder_clientid` (`element`,`folder`,`client_id`),
  KEY `extension` (`type`,`element`,`folder`,`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=283 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__extensions`  VALUES 
('1', '0', 'com_wrapper', 'component', 'com_wrapper', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Wrapper\",\"filename\":\"wrapper\"}', '', '', NULL, NULL, '0', '0', NULL),
('2', '0', 'com_admin', 'component', 'com_admin', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Admin\"}', '', '', NULL, NULL, '0', '0', NULL),
('3', '0', 'com_banners', 'component', 'com_banners', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Banners\",\"filename\":\"banners\"}', '{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\",\"save_history\":\"1\",\"history_limit\":10}', '', NULL, NULL, '0', '0', NULL),
('4', '0', 'com_cache', 'component', 'com_cache', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Cache\"}', '', '', NULL, NULL, '0', '0', NULL),
('5', '0', 'com_categories', 'component', 'com_categories', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"2007-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Categories\"}', '', '', NULL, NULL, '0', '0', NULL),
('6', '0', 'com_checkin', 'component', 'com_checkin', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Checkin\"}', '', '', NULL, NULL, '0', '0', NULL),
('7', '0', 'com_contact', 'component', 'com_contact', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Contact\",\"filename\":\"contact\"}', '{\"contact_layout\":\"_:default\",\"show_contact_category\":\"hide\",\"save_history\":\"1\",\"history_limit\":10,\"show_contact_list\":\"0\",\"presentation_style\":\"sliders\",\"show_tags\":\"1\",\"show_info\":\"1\",\"show_name\":\"1\",\"show_position\":\"1\",\"show_email\":\"0\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_image\":\"1\",\"show_misc\":\"1\",\"image\":\"\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"articles_display_num\":\"10\",\"show_profile\":\"0\",\"show_user_custom_fields\":[\"-1\"],\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"0\",\"maxLevel\":\"-1\",\"show_subcat_desc\":\"1\",\"show_empty_categories\":\"0\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_subcat_desc_cat\":\"1\",\"show_empty_categories_cat\":\"0\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"0\",\"show_pagination_limit\":\"0\",\"show_headings\":\"1\",\"show_image_heading\":\"0\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"initial_sort\":\"ordering\",\"captcha\":\"\",\"show_email_form\":\"1\",\"show_email_copy\":\"0\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_feed_link\":\"1\",\"sef_ids\":1,\"custom_fields_enable\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('8', '0', 'com_cpanel', 'component', 'com_cpanel', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"2007-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Cpanel\"}', '', '', NULL, NULL, '0', '0', NULL),
('9', '0', 'com_installer', 'component', 'com_installer', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Installer\"}', '{\"cachetimeout\":\"6\",\"minimum_stability\":\"4\"}', '', NULL, NULL, '0', '0', NULL),
('10', '0', 'com_languages', 'component', 'com_languages', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Languages\"}', '{\"administrator\":\"en-GB\",\"site\":\"en-GB\"}', '', NULL, NULL, '0', '0', NULL),
('11', '0', 'com_login', 'component', 'com_login', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Login\"}', '', '', NULL, NULL, '0', '0', NULL),
('12', '0', 'com_media', 'component', 'com_media', '', '', '1', '1', '0', '1', '1', '{\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Media\",\"filename\":\"media\"}', '{\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"allowed_media_usergroup\":\"3\",\"restrict_uploads_extensions\":\"bmp,gif,jpg,jpeg,png,webp,avif,ico,mp3,m4a,mp4a,ogg,mp4,mp4v,mpeg,mov,odg,odp,ods,odt,pdf,ppt,txt,xcf,xls,csv\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png,jpeg,webp,avif\",\"audio_extensions\":\"mp3,m4a,mp4a,ogg\",\"video_extensions\":\"mp4,mp4v,mpeg,mov,webm\",\"doc_extensions\":\"odg,odp,ods,odt,pdf,ppt,txt,xcf,xls,csv\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,image\\/webp,image\\/avif,audio\\/ogg,audio\\/mpeg,audio\\/mp4,video\\/mp4,video\\/webm,video\\/mpeg,video\\/quicktime,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\"}', '', NULL, NULL, '0', '0', NULL),
('13', '0', 'com_menus', 'component', 'com_menus', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Menus\",\"filename\":\"menus\"}', '{\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\"}', '', NULL, NULL, '0', '0', NULL),
('14', '0', 'com_messages', 'component', 'com_messages', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Messages\"}', '', '', NULL, NULL, '0', '0', NULL),
('15', '0', 'com_modules', 'component', 'com_modules', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Modules\",\"filename\":\"modules\"}', '', '', NULL, NULL, '0', '0', NULL),
('16', '0', 'com_newsfeeds', 'component', 'com_newsfeeds', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Newsfeeds\",\"filename\":\"newsfeeds\"}', '{\"newsfeed_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_character_count\":\"0\",\"feed_display_order\":\"des\",\"float_first\":\"right\",\"float_second\":\"right\",\"show_tags\":\"1\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\",\"sef_ids\":1}', '', NULL, NULL, '0', '0', NULL),
('17', '0', 'com_plugins', 'component', 'com_plugins', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Plugins\"}', '', '', NULL, NULL, '0', '0', NULL),
('18', '0', 'com_templates', 'component', 'com_templates', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Templates\"}', '{\"template_positions_display\":\"0\",\"upload_limit\":\"10\",\"image_formats\":\"gif,bmp,jpg,jpeg,png,webp\",\"source_formats\":\"txt,less,ini,xml,js,php,css,scss,sass,json\",\"font_formats\":\"woff,woff2,ttf,otf\",\"compressed_formats\":\"zip\",\"difference\":\"SideBySide\"}', '', NULL, NULL, '0', '0', NULL),
('19', '0', 'com_content', 'component', 'com_content', '', '', '1', '1', '0', '1', '1', '{\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Content\",\"filename\":\"content\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"info_block_position\":\"0\",\"info_block_show_title\":\"1\",\"show_category\":\"1\",\"link_category\":\"1\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_associations\":\"0\",\"flags\":\"1\",\"show_author\":\"1\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"1\",\"show_item_navigation\":\"1\",\"show_readmore\":\"1\",\"show_readmore_title\":\"1\",\"readmore_limit\":100,\"show_tags\":\"1\",\"record_hits\":\"1\",\"show_hits\":\"1\",\"show_noauth\":\"0\",\"urls_position\":0,\"captcha\":\"\",\"show_publishing_options\":\"1\",\"show_article_options\":\"1\",\"show_configure_edit_options\":\"1\",\"show_permissions\":\"1\",\"show_associations_edit\":\"1\",\"save_history\":\"1\",\"history_limit\":10,\"show_urls_images_frontend\":\"0\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"left\",\"float_fulltext\":\"left\",\"category_layout\":\"_:blog\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"1\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_category_heading_title_text\":\"1\",\"show_subcat_desc\":\"1\",\"show_cat_num_articles\":\"0\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":1,\"blog_class_leading\":\"\",\"num_intro_articles\":4,\"blog_class\":\"\",\"num_columns\":1,\"multi_column_order\":\"0\",\"num_links\":4,\"show_subcategory_content\":\"0\",\"link_intro_image\":\"0\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"display_num\":\"10\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_featured\":\"show\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\",\"feed_show_readmore\":\"0\",\"sef_ids\":1,\"custom_fields_enable\":\"1\",\"workflow_enabled\":\"0\"}', '', NULL, NULL, '0', '0', NULL),
('20', '0', 'com_config', 'component', 'com_config', '', '', '1', '1', '0', '1', '1', '{\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Config\",\"filename\":\"config\"}', '{\"filters\":{\"1\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"9\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', NULL, NULL, '0', '0', NULL),
('21', '0', 'com_redirect', 'component', 'com_redirect', '', '', '1', '1', '0', '0', '1', '{\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Redirect\"}', '', '', NULL, NULL, '0', '0', NULL),
('22', '0', 'com_users', 'component', 'com_users', '', '', '1', '1', '0', '1', '1', '{\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Users\",\"filename\":\"users\"}', '{\"allowUserRegistration\":\"0\",\"new_usertype\":\"2\",\"guest_usergroup\":\"9\",\"sendpassword\":\"0\",\"useractivation\":\"2\",\"mail_to_admin\":\"1\",\"captcha\":\"\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"change_login_name\":\"0\",\"reset_count\":\"10\",\"reset_time\":\"1\",\"minimum_length\":\"12\",\"minimum_integers\":\"0\",\"minimum_symbols\":\"0\",\"minimum_uppercase\":\"0\",\"save_history\":\"1\",\"history_limit\":5,\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\"}', '', NULL, NULL, '0', '0', NULL),
('23', '0', 'com_finder', 'component', 'com_finder', '', '', '1', '1', '0', '0', '1', '{\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Finder\",\"filename\":\"finder\"}', '{\"enabled\":\"0\",\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_autosuggest\":\"1\",\"show_suggested_query\":\"1\",\"show_explained_query\":\"1\",\"show_advanced\":\"1\",\"show_advanced_tips\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"sort_order\":\"relevance\",\"sort_direction\":\"desc\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stem\":\"1\",\"stemmer\":\"snowball\",\"enable_logging\":\"0\"}', '', NULL, NULL, '0', '0', NULL),
('24', '0', 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', '', '1', '1', '0', '1', '1', '{\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2012 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.3\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Joomlaupdate\"}', '{\"updatesource\":\"default\",\"customurl\":\"\"}', '', NULL, NULL, '0', '0', NULL),
('25', '0', 'com_tags', 'component', 'com_tags', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_tags\",\"type\":\"component\",\"creationDate\":\"2013-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Tags\",\"filename\":\"tags\"}', '{\"tag_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_tag_title\":\"0\",\"tag_list_show_tag_image\":\"0\",\"tag_list_show_tag_description\":\"0\",\"tag_list_image\":\"\",\"tag_list_orderby\":\"title\",\"tag_list_orderby_direction\":\"ASC\",\"show_headings\":\"0\",\"tag_list_show_date\":\"0\",\"tag_list_show_item_image\":\"0\",\"tag_list_show_item_description\":\"0\",\"tag_list_item_maximum_characters\":0,\"return_any_or_all\":\"1\",\"include_children\":\"0\",\"maximum\":200,\"tag_list_language_filter\":\"all\",\"tags_layout\":\"_:default\",\"all_tags_orderby\":\"title\",\"all_tags_orderby_direction\":\"ASC\",\"all_tags_show_tag_image\":\"0\",\"all_tags_show_tag_description\":\"0\",\"all_tags_tag_maximum_characters\":20,\"all_tags_show_tag_hits\":\"0\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"tag_field_ajax_mode\":\"1\",\"show_feed_link\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('26', '0', 'com_contenthistory', 'component', 'com_contenthistory', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_contenthistory\",\"type\":\"component\",\"creationDate\":\"2013-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTENTHISTORY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Contenthistory\",\"filename\":\"contenthistory\"}', '', '', NULL, NULL, '0', '0', NULL),
('27', '0', 'com_ajax', 'component', 'com_ajax', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_ajax\",\"type\":\"component\",\"creationDate\":\"2013-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_AJAX_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"ajax\"}', '', '', NULL, NULL, '0', '0', NULL),
('28', '0', 'com_postinstall', 'component', 'com_postinstall', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_postinstall\",\"type\":\"component\",\"creationDate\":\"2013-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_POSTINSTALL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Postinstall\"}', '', '', NULL, NULL, '0', '0', NULL),
('29', '0', 'com_fields', 'component', 'com_fields', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_fields\",\"type\":\"component\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, '0', '0', NULL),
('30', '0', 'com_associations', 'component', 'com_associations', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_associations\",\"type\":\"component\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_ASSOCIATIONS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Associations\"}', '', '', NULL, NULL, '0', '0', NULL),
('31', '0', 'com_privacy', 'component', 'com_privacy', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_privacy\",\"type\":\"component\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Privacy\",\"filename\":\"privacy\"}', '', '', NULL, NULL, '0', '0', NULL),
('32', '0', 'com_actionlogs', 'component', 'com_actionlogs', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_actionlogs\",\"type\":\"component\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Actionlogs\"}', '{\"ip_logging\":0,\"csv_delimiter\":\",\",\"loggable_extensions\":[\"com_banners\",\"com_cache\",\"com_categories\",\"com_checkin\",\"com_config\",\"com_contact\",\"com_content\",\"com_fields\",\"com_installer\",\"com_media\",\"com_menus\",\"com_messages\",\"com_modules\",\"com_newsfeeds\",\"com_plugins\",\"com_redirect\",\"com_scheduler\",\"com_tags\",\"com_templates\",\"com_users\"]}', '', NULL, NULL, '0', '0', NULL),
('33', '0', 'com_workflow', 'component', 'com_workflow', '', '', '1', '1', '0', '1', '1', '{\"name\":\"com_workflow\",\"type\":\"component\",\"creationDate\":\"2017-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_WORKFLOW_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Workflow\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('34', '0', 'com_mails', 'component', 'com_mails', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_mails\",\"type\":\"component\",\"creationDate\":\"2019-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MAILS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Mails\"}', '', '', NULL, NULL, '0', '0', NULL),
('35', '0', 'com_scheduler', 'component', 'com_scheduler', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_scheduler\",\"type\":\"component\",\"creationDate\":\"2021-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.0\",\"description\":\"COM_SCHEDULER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Scheduler\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('36', '0', 'com_guidedtours', 'component', 'com_guidedtours', '', '', '1', '1', '0', '0', '1', '{\"name\":\"com_guidedtours\",\"type\":\"component\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"COM_GUIDEDTOURS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Guidedtours\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('37', '0', 'lib_joomla', 'library', 'joomla', '', '', '0', '1', '1', '1', '1', '{\"name\":\"lib_joomla\",\"type\":\"library\",\"creationDate\":\"2008-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2008 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"https:\\/\\/www.joomla.org\",\"version\":\"13.1\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"joomla\"}', '', '', NULL, NULL, '0', '0', NULL),
('38', '0', 'lib_phpass', 'library', 'phpass', '', '', '0', '1', '1', '1', '1', '{\"name\":\"lib_phpass\",\"type\":\"library\",\"creationDate\":\"2004-01\",\"author\":\"Solar Designer\",\"copyright\":\"\",\"authorEmail\":\"solar@openwall.com\",\"authorUrl\":\"https:\\/\\/www.openwall.com\\/phpass\\/\",\"version\":\"0.5.1\",\"description\":\"LIB_PHPASS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"phpass\"}', '', '', NULL, NULL, '0', '0', NULL),
('39', '0', 'mod_articles_archive', 'module', 'mod_articles_archive', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesArchive\",\"filename\":\"mod_articles_archive\"}', '', '', NULL, NULL, '0', '0', NULL),
('40', '0', 'mod_articles_latest', 'module', 'mod_articles_latest', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesLatest\",\"filename\":\"mod_articles_latest\"}', '', '', NULL, NULL, '0', '0', NULL),
('41', '0', 'mod_articles_popular', 'module', 'mod_articles_popular', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesPopular\",\"filename\":\"mod_articles_popular\"}', '', '', NULL, NULL, '0', '0', NULL),
('42', '0', 'mod_banners', 'module', 'mod_banners', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Banners\",\"filename\":\"mod_banners\"}', '', '', NULL, NULL, '0', '0', NULL),
('43', '0', 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Breadcrumbs\",\"filename\":\"mod_breadcrumbs\"}', '', '', NULL, NULL, '0', '0', NULL),
('44', '0', 'mod_custom', 'module', 'mod_custom', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Custom\",\"filename\":\"mod_custom\"}', '', '', NULL, NULL, '0', '0', NULL),
('45', '0', 'mod_feed', 'module', 'mod_feed', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"2005-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Feed\",\"filename\":\"mod_feed\"}', '', '', NULL, NULL, '0', '0', NULL),
('46', '0', 'mod_footer', 'module', 'mod_footer', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Footer\",\"filename\":\"mod_footer\"}', '', '', NULL, NULL, '0', '0', NULL),
('47', '0', 'mod_login', 'module', 'mod_login', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Login\",\"filename\":\"mod_login\"}', '', '', NULL, NULL, '0', '0', NULL),
('48', '0', 'mod_menu', 'module', 'mod_menu', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Menu\",\"filename\":\"mod_menu\"}', '', '', NULL, NULL, '0', '0', NULL),
('49', '0', 'mod_articles_news', 'module', 'mod_articles_news', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesNews\",\"filename\":\"mod_articles_news\"}', '', '', NULL, NULL, '0', '0', NULL),
('50', '0', 'mod_random_image', 'module', 'mod_random_image', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\RandomImage\",\"filename\":\"mod_random_image\"}', '', '', NULL, NULL, '0', '0', NULL),
('51', '0', 'mod_related_items', 'module', 'mod_related_items', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\RelatedItems\",\"filename\":\"mod_related_items\"}', '', '', NULL, NULL, '0', '0', NULL),
('52', '0', 'mod_stats', 'module', 'mod_stats', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Stats\",\"filename\":\"mod_stats\"}', '', '', NULL, NULL, '0', '0', NULL),
('53', '0', 'mod_syndicate', 'module', 'mod_syndicate', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"2006-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Syndicate\",\"filename\":\"mod_syndicate\"}', '', '', NULL, NULL, '0', '0', NULL),
('54', '0', 'mod_users_latest', 'module', 'mod_users_latest', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"2009-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\UsersLatest\",\"filename\":\"mod_users_latest\"}', '', '', NULL, NULL, '0', '0', NULL),
('55', '0', 'mod_whosonline', 'module', 'mod_whosonline', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Whosonline\",\"filename\":\"mod_whosonline\"}', '', '', NULL, NULL, '0', '0', NULL),
('56', '0', 'mod_wrapper', 'module', 'mod_wrapper', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"2004-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Wrapper\",\"filename\":\"mod_wrapper\"}', '', '', NULL, NULL, '0', '0', NULL),
('57', '0', 'mod_articles_category', 'module', 'mod_articles_category', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesCategory\",\"filename\":\"mod_articles_category\"}', '', '', NULL, NULL, '0', '0', NULL),
('58', '0', 'mod_articles_categories', 'module', 'mod_articles_categories', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesCategories\",\"filename\":\"mod_articles_categories\"}', '', '', NULL, NULL, '0', '0', NULL),
('59', '0', 'mod_languages', 'module', 'mod_languages', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Languages\",\"filename\":\"mod_languages\"}', '', '', NULL, NULL, '0', '0', NULL),
('60', '0', 'mod_finder', 'module', 'mod_finder', '', '', '0', '1', '0', '0', '1', '{\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Finder\",\"filename\":\"mod_finder\"}', '', '', NULL, NULL, '0', '0', NULL),
('61', '0', 'mod_custom', 'module', 'mod_custom', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Custom\",\"filename\":\"mod_custom\"}', '', '', NULL, NULL, '0', '0', NULL),
('62', '0', 'mod_feed', 'module', 'mod_feed', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"2005-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Feed\",\"filename\":\"mod_feed\"}', '', '', NULL, NULL, '0', '0', NULL),
('63', '0', 'mod_latest', 'module', 'mod_latest', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Latest\",\"filename\":\"mod_latest\"}', '', '', NULL, NULL, '0', '0', NULL),
('64', '0', 'mod_logged', 'module', 'mod_logged', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"2005-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Logged\",\"filename\":\"mod_logged\"}', '', '', NULL, NULL, '0', '0', NULL),
('65', '0', 'mod_login', 'module', 'mod_login', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"2005-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Login\",\"filename\":\"mod_login\"}', '', '', NULL, NULL, '0', '0', NULL),
('66', '0', 'mod_loginsupport', 'module', 'mod_loginsupport', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_loginsupport\",\"type\":\"module\",\"creationDate\":\"2019-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_LOGINSUPPORT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Loginsupport\",\"filename\":\"mod_loginsupport\"}', '', '', NULL, NULL, '0', '0', NULL),
('67', '0', 'mod_menu', 'module', 'mod_menu', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"2006-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Menu\",\"filename\":\"mod_menu\"}', '', '', NULL, NULL, '0', '0', NULL),
('68', '0', 'mod_popular', 'module', 'mod_popular', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Popular\",\"filename\":\"mod_popular\"}', '', '', NULL, NULL, '0', '0', NULL),
('69', '0', 'mod_quickicon', 'module', 'mod_quickicon', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Quickicon\",\"filename\":\"mod_quickicon\"}', '', '', NULL, NULL, '0', '0', NULL),
('70', '0', 'mod_frontend', 'module', 'mod_frontend', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_frontend\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_FRONTEND_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Frontend\",\"filename\":\"mod_frontend\"}', '', '', NULL, NULL, '0', '0', NULL),
('71', '0', 'mod_messages', 'module', 'mod_messages', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_messages\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Messages\",\"filename\":\"mod_messages\"}', '', '', NULL, NULL, '0', '0', NULL),
('72', '0', 'mod_post_installation_messages', 'module', 'mod_post_installation_messages', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_post_installation_messages\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_POST_INSTALLATION_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\PostInstallationMessages\",\"filename\":\"mod_post_installation_messages\"}', '', '', NULL, NULL, '0', '0', NULL),
('73', '0', 'mod_user', 'module', 'mod_user', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_user\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_USER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\User\",\"filename\":\"mod_user\"}', '', '', NULL, NULL, '0', '0', NULL),
('74', '0', 'mod_title', 'module', 'mod_title', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Title\",\"filename\":\"mod_title\"}', '', '', NULL, NULL, '0', '0', NULL),
('75', '0', 'mod_toolbar', 'module', 'mod_toolbar', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Toolbar\",\"filename\":\"mod_toolbar\"}', '', '', NULL, NULL, '0', '0', NULL),
('76', '0', 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"2011-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\MultilangStatus\",\"filename\":\"mod_multilangstatus\"}', '{\"cache\":\"0\"}', '', NULL, NULL, '0', '0', NULL),
('77', '0', 'mod_version', 'module', 'mod_version', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"2012-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2012 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Version\",\"filename\":\"mod_version\"}', '{\"cache\":\"0\"}', '', NULL, NULL, '0', '0', NULL),
('78', '0', 'mod_stats_admin', 'module', 'mod_stats_admin', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_stats_admin\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\StatsAdmin\",\"filename\":\"mod_stats_admin\"}', '{\"serverinfo\":\"0\",\"siteinfo\":\"0\",\"counter\":\"0\",\"increase\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', NULL, NULL, '0', '0', NULL),
('79', '0', 'mod_tags_popular', 'module', 'mod_tags_popular', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_tags_popular\",\"type\":\"module\",\"creationDate\":\"2013-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\TagsPopular\",\"filename\":\"mod_tags_popular\"}', '{\"maximum\":\"5\",\"timeframe\":\"alltime\",\"owncache\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('80', '0', 'mod_tags_similar', 'module', 'mod_tags_similar', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_tags_similar\",\"type\":\"module\",\"creationDate\":\"2013-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_SIMILAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\TagsSimilar\",\"filename\":\"mod_tags_similar\"}', '{\"maximum\":\"5\",\"matchtype\":\"any\",\"owncache\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('81', '0', 'mod_sampledata', 'module', 'mod_sampledata', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_sampledata\",\"type\":\"module\",\"creationDate\":\"2017-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"MOD_SAMPLEDATA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Sampledata\",\"filename\":\"mod_sampledata\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('82', '0', 'mod_latestactions', 'module', 'mod_latestactions', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_latestactions\",\"type\":\"module\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_LATESTACTIONS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\LatestActions\",\"filename\":\"mod_latestactions\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('83', '0', 'mod_privacy_dashboard', 'module', 'mod_privacy_dashboard', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_privacy_dashboard\",\"type\":\"module\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_PRIVACY_DASHBOARD_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\PrivacyDashboard\",\"filename\":\"mod_privacy_dashboard\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('84', '0', 'mod_submenu', 'module', 'mod_submenu', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"2006-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Submenu\",\"filename\":\"mod_submenu\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('85', '0', 'mod_privacy_status', 'module', 'mod_privacy_status', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_privacy_status\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_PRIVACY_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\PrivacyStatus\",\"filename\":\"mod_privacy_status\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('86', '0', 'mod_guidedtours', 'module', 'mod_guidedtours', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_guidedtours\",\"type\":\"module\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"MOD_GUIDEDTOURS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\GuidedTours\",\"filename\":\"mod_guidedtours\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('87', '0', 'plg_actionlog_joomla', 'plugin', 'joomla', '', 'actionlog', '0', '1', '1', '0', '1', '{\"name\":\"plg_actionlog_joomla\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_ACTIONLOG_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Actionlog\\\\Joomla\",\"filename\":\"joomla\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('88', '0', 'plg_api-authentication_basic', 'plugin', 'basic', '', 'api-authentication', '0', '0', '1', '0', '1', '{\"name\":\"plg_api-authentication_basic\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_API-AUTHENTICATION_BASIC_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\ApiAuthentication\\\\Basic\",\"filename\":\"basic\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('89', '0', 'plg_api-authentication_token', 'plugin', 'token', '', 'api-authentication', '0', '1', '1', '0', '1', '{\"name\":\"plg_api-authentication_token\",\"type\":\"plugin\",\"creationDate\":\"2019-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_API-AUTHENTICATION_TOKEN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\ApiAuthentication\\\\Token\",\"filename\":\"token\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('90', '0', 'plg_authentication_cookie', 'plugin', 'cookie', '', 'authentication', '0', '1', '1', '0', '1', '{\"name\":\"plg_authentication_cookie\",\"type\":\"plugin\",\"creationDate\":\"2013-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTHENTICATION_COOKIE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Cookie\",\"filename\":\"cookie\"}', '', '', NULL, NULL, '1', '0', NULL),
('91', '0', 'plg_authentication_joomla', 'plugin', 'joomla', '', 'authentication', '0', '1', '1', '1', '1', '{\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTHENTICATION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Joomla\",\"filename\":\"joomla\"}', '', '', NULL, NULL, '2', '0', NULL),
('92', '0', 'plg_authentication_ldap', 'plugin', 'ldap', '', 'authentication', '0', '0', '1', '0', '1', '{\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Ldap\",\"filename\":\"ldap\"}', '{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}', '', NULL, NULL, '3', '0', NULL),
('93', '0', 'plg_behaviour_compat', 'plugin', 'compat', '', 'behaviour', '0', '1', '1', '0', '1', '{\"name\":\"plg_behaviour_compat\",\"type\":\"plugin\",\"creationDate\":\"2023-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_COMPAT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Behaviour\\\\Compat\",\"filename\":\"compat\"}', '{\"classes_aliases\":\"1\",\"es5_assets\":\"1\"}', '', NULL, NULL, '1', '0', NULL),
('94', '0', 'plg_behaviour_taggable', 'plugin', 'taggable', '', 'behaviour', '0', '1', '1', '0', '1', '{\"name\":\"plg_behaviour_taggable\",\"type\":\"plugin\",\"creationDate\":\"2015-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_BEHAVIOUR_TAGGABLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Behaviour\\\\Taggable\",\"filename\":\"taggable\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('95', '0', 'plg_behaviour_versionable', 'plugin', 'versionable', '', 'behaviour', '0', '1', '1', '0', '1', '{\"name\":\"plg_behaviour_versionable\",\"type\":\"plugin\",\"creationDate\":\"2015-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_BEHAVIOUR_VERSIONABLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Behaviour\\\\Versionable\",\"filename\":\"versionable\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('96', '0', 'plg_content_confirmconsent', 'plugin', 'confirmconsent', '', 'content', '0', '0', '1', '0', '1', '{\"name\":\"plg_content_confirmconsent\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_CONTENT_CONFIRMCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\ConfirmConsent\",\"filename\":\"confirmconsent\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('97', '0', 'plg_content_contact', 'plugin', 'contact', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_contact\",\"type\":\"plugin\",\"creationDate\":\"2014-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2014 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.2\",\"description\":\"PLG_CONTENT_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Contact\",\"filename\":\"contact\"}', '', '', NULL, NULL, '2', '0', NULL),
('98', '0', 'plg_content_emailcloak', 'plugin', 'emailcloak', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\EmailCloak\",\"filename\":\"emailcloak\"}', '{\"mode\":\"1\"}', '', NULL, NULL, '3', '0', NULL),
('99', '0', 'plg_content_fields', 'plugin', 'fields', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_fields\",\"type\":\"plugin\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_CONTENT_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, '4', '0', NULL),
('100', '0', 'plg_content_finder', 'plugin', 'finder', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"2011-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Finder\",\"filename\":\"finder\"}', '', '', NULL, NULL, '5', '0', NULL),
('101', '0', 'plg_content_joomla', 'plugin', 'joomla', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"2010-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Joomla\",\"filename\":\"joomla\"}', '', '', NULL, NULL, '6', '0', NULL),
('102', '0', 'plg_content_loadmodule', 'plugin', 'loadmodule', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\LoadModule\",\"filename\":\"loadmodule\"}', '{\"style\":\"xhtml\"}', '', NULL, NULL, '7', '0', NULL),
('103', '0', 'plg_content_pagebreak', 'plugin', 'pagebreak', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\PageBreak\",\"filename\":\"pagebreak\"}', '{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}', '', NULL, NULL, '8', '0', NULL),
('104', '0', 'plg_content_pagenavigation', 'plugin', 'pagenavigation', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"2006-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\PageNavigation\",\"filename\":\"pagenavigation\"}', '{\"position\":\"1\"}', '', NULL, NULL, '9', '0', NULL),
('105', '0', 'plg_content_vote', 'plugin', 'vote', '', 'content', '0', '0', '1', '0', '1', '{\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Vote\",\"filename\":\"vote\"}', '', '', NULL, NULL, '10', '0', NULL),
('106', '0', 'plg_editors-xtd_article', 'plugin', 'article', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"2009-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Article\",\"filename\":\"article\"}', '', '', NULL, NULL, '1', '0', NULL),
('107', '0', 'plg_editors-xtd_contact', 'plugin', 'contact', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_contact\",\"type\":\"plugin\",\"creationDate\":\"2016-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Contact\",\"filename\":\"contact\"}', '', '', NULL, NULL, '2', '0', NULL),
('108', '0', 'plg_editors-xtd_fields', 'plugin', 'fields', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_fields\",\"type\":\"plugin\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, '3', '0', NULL),
('109', '0', 'plg_editors-xtd_image', 'plugin', 'image', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"2004-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Image\",\"filename\":\"image\"}', '', '', NULL, NULL, '4', '0', NULL),
('110', '0', 'plg_editors-xtd_menu', 'plugin', 'menu', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_menu\",\"type\":\"plugin\",\"creationDate\":\"2016-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Menu\",\"filename\":\"menu\"}', '', '', NULL, NULL, '5', '0', NULL),
('111', '0', 'plg_editors-xtd_module', 'plugin', 'module', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_module\",\"type\":\"plugin\",\"creationDate\":\"2015-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2015 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_MODULE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Module\",\"filename\":\"module\"}', '', '', NULL, NULL, '6', '0', NULL),
('112', '0', 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"2004-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\PageBreak\",\"filename\":\"pagebreak\"}', '', '', NULL, NULL, '7', '0', NULL),
('113', '0', 'plg_editors-xtd_readmore', 'plugin', 'readmore', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"2006-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\ReadMore\",\"filename\":\"readmore\"}', '', '', NULL, NULL, '8', '0', NULL),
('114', '0', 'plg_editors_codemirror', 'plugin', 'codemirror', '', 'editors', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"Copyright (C) 2014 - 2021 by Marijn Haverbeke <marijnh@gmail.com> and others\",\"authorEmail\":\"marijnh@gmail.com\",\"authorUrl\":\"https:\\/\\/codemirror.net\\/\",\"version\":\"6.0.0\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\CodeMirror\",\"filename\":\"codemirror\"}', '{\"lineNumbers\":\"1\",\"lineWrapping\":\"1\",\"matchTags\":\"1\",\"matchBrackets\":\"1\",\"marker-gutter\":\"1\",\"autoCloseTags\":\"1\",\"autoCloseBrackets\":\"1\",\"autoFocus\":\"1\",\"theme\":\"default\",\"tabmode\":\"indent\"}', '', NULL, NULL, '1', '0', NULL),
('115', '0', 'plg_editors_none', 'plugin', 'none', '', 'editors', '0', '1', '1', '1', '1', '{\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"2005-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\None\",\"filename\":\"none\"}', '', '', NULL, NULL, '2', '0', NULL),
('116', '0', 'plg_editors_tinymce', 'plugin', 'tinymce', '', 'editors', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-08\",\"author\":\"Tiny Technologies, Inc\",\"copyright\":\"Tiny Technologies, Inc\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"https:\\/\\/www.tiny.cloud\",\"version\":\"6.8.5\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\TinyMCE\",\"filename\":\"tinymce\"}', '{\"configuration\":{\"toolbars\":{\"2\":{\"toolbar1\":[\"bold\",\"underline\",\"strikethrough\",\"|\",\"undo\",\"redo\",\"|\",\"bullist\",\"numlist\",\"|\",\"pastetext\"]},\"1\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"blocks\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"code\",\"|\",\"hr\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"pastetext\",\"preview\"]},\"0\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"styles\",\"|\",\"blocks\",\"fontfamily\",\"fontsize\",\"|\",\"searchreplace\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"image\",\"|\",\"code\",\"|\",\"forecolor\",\"backcolor\",\"|\",\"fullscreen\",\"|\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"emoticons\",\"media\",\"hr\",\"ltr\",\"rtl\",\"|\",\"cut\",\"copy\",\"paste\",\"pastetext\",\"|\",\"visualchars\",\"visualblocks\",\"nonbreaking\",\"blockquote\",\"jtemplate\",\"|\",\"print\",\"preview\",\"codesample\",\"insertdatetime\",\"removeformat\"]}},\"setoptions\":{\"2\":{\"access\":[\"1\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"0\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"1\":{\"access\":[\"6\",\"2\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"0\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"0\":{\"access\":[\"7\",\"4\",\"8\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"}}},\"sets_amount\":3,\"html_height\":\"550\",\"html_width\":\"750\"}', '', NULL, NULL, '3', '0', NULL),
('117', '0', 'plg_extension_finder', 'plugin', 'finder', '', 'extension', '0', '1', '1', '0', '1', '{\"name\":\"plg_extension_finder\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_EXTENSION_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\Finder\",\"filename\":\"finder\"}', '', '', NULL, NULL, '1', '0', NULL),
('118', '0', 'plg_extension_joomla', 'plugin', 'joomla', '', 'extension', '0', '1', '1', '0', '1', '{\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"2010-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\Joomla\",\"filename\":\"joomla\"}', '', '', NULL, NULL, '2', '0', NULL),
('119', '0', 'plg_extension_namespacemap', 'plugin', 'namespacemap', '', 'extension', '0', '1', '1', '1', '1', '{\"name\":\"plg_extension_namespacemap\",\"type\":\"plugin\",\"creationDate\":\"2017-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_EXTENSION_NAMESPACEMAP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\NamespaceMap\",\"filename\":\"namespacemap\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('120', '0', 'plg_fields_calendar', 'plugin', 'calendar', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_calendar\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CALENDAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Calendar\",\"filename\":\"calendar\"}', '', '', NULL, NULL, '1', '0', NULL),
('121', '0', 'plg_fields_checkboxes', 'plugin', 'checkboxes', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_checkboxes\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Checkboxes\",\"filename\":\"checkboxes\"}', '', '', NULL, NULL, '2', '0', NULL),
('122', '0', 'plg_fields_color', 'plugin', 'color', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_color\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_COLOR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Color\",\"filename\":\"color\"}', '', '', NULL, NULL, '3', '0', NULL),
('123', '0', 'plg_fields_editor', 'plugin', 'editor', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_editor\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_EDITOR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Editor\",\"filename\":\"editor\"}', '{\"buttons\":0,\"width\":\"100%\",\"height\":\"250px\",\"filter\":\"\\\\Joomla\\\\CMS\\\\Component\\\\ComponentHelper::filterText\"}', '', NULL, NULL, '4', '0', NULL),
('124', '0', 'plg_fields_imagelist', 'plugin', 'imagelist', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_imagelist\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Imagelist\",\"filename\":\"imagelist\"}', '', '', NULL, NULL, '5', '0', NULL),
('125', '0', 'plg_fields_integer', 'plugin', 'integer', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_integer\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_INTEGER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Integer\",\"filename\":\"integer\"}', '{\"multiple\":\"0\",\"first\":\"1\",\"last\":\"100\",\"step\":\"1\"}', '', NULL, NULL, '6', '0', NULL),
('126', '0', 'plg_fields_list', 'plugin', 'list', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_list\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_LIST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\ListField\",\"filename\":\"list\"}', '', '', NULL, NULL, '7', '0', NULL),
('127', '0', 'plg_fields_media', 'plugin', 'media', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_media\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Media\",\"filename\":\"media\"}', '', '', NULL, NULL, '8', '0', NULL),
('128', '0', 'plg_fields_radio', 'plugin', 'radio', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_radio\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_RADIO_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Radio\",\"filename\":\"radio\"}', '', '', NULL, NULL, '9', '0', NULL),
('129', '0', 'plg_fields_sql', 'plugin', 'sql', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_sql\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_SQL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\SQL\",\"filename\":\"sql\"}', '', '', NULL, NULL, '10', '0', NULL),
('130', '0', 'plg_fields_subform', 'plugin', 'subform', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_subform\",\"type\":\"plugin\",\"creationDate\":\"2017-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_FIELDS_SUBFORM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Subform\",\"filename\":\"subform\"}', '', '', NULL, NULL, '11', '0', NULL),
('131', '0', 'plg_fields_text', 'plugin', 'text', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_text\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Text\",\"filename\":\"text\"}', '', '', NULL, NULL, '12', '0', NULL),
('132', '0', 'plg_fields_textarea', 'plugin', 'textarea', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_textarea\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Textarea\",\"filename\":\"textarea\"}', '{\"rows\":10,\"cols\":10,\"maxlength\":\"\",\"filter\":\"\\\\Joomla\\\\CMS\\\\Component\\\\ComponentHelper::filterText\"}', '', NULL, NULL, '13', '0', NULL),
('133', '0', 'plg_fields_url', 'plugin', 'url', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_url\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_URL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Url\",\"filename\":\"url\"}', '', '', NULL, NULL, '14', '0', NULL),
('134', '0', 'plg_fields_user', 'plugin', 'user', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_user\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\User\",\"filename\":\"user\"}', '', '', NULL, NULL, '15', '0', NULL),
('135', '0', 'plg_fields_usergrouplist', 'plugin', 'usergrouplist', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_usergrouplist\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\UsergroupList\",\"filename\":\"usergrouplist\"}', '', '', NULL, NULL, '16', '0', NULL),
('136', '0', 'plg_filesystem_local', 'plugin', 'local', '', 'filesystem', '0', '1', '1', '0', '1', '{\"name\":\"plg_filesystem_local\",\"type\":\"plugin\",\"creationDate\":\"2017-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_FILESYSTEM_LOCAL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Filesystem\\\\Local\",\"filename\":\"local\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('137', '0', 'plg_finder_categories', 'plugin', 'categories', '', 'finder', '0', '1', '1', '0', '1', '{\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Categories\",\"filename\":\"categories\"}', '', '', NULL, NULL, '1', '0', NULL),
('138', '0', 'plg_finder_contacts', 'plugin', 'contacts', '', 'finder', '0', '1', '1', '0', '1', '{\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Contacts\",\"filename\":\"contacts\"}', '', '', NULL, NULL, '2', '0', NULL),
('139', '0', 'plg_finder_content', 'plugin', 'content', '', 'finder', '0', '1', '1', '0', '1', '{\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Content\",\"filename\":\"content\"}', '', '', NULL, NULL, '3', '0', NULL),
('140', '0', 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', '', 'finder', '0', '1', '1', '0', '1', '{\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Newsfeeds\",\"filename\":\"newsfeeds\"}', '', '', NULL, NULL, '4', '0', NULL),
('141', '0', 'plg_finder_tags', 'plugin', 'tags', '', 'finder', '0', '1', '1', '0', '1', '{\"name\":\"plg_finder_tags\",\"type\":\"plugin\",\"creationDate\":\"2013-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Tags\",\"filename\":\"tags\"}', '', '', NULL, NULL, '5', '0', NULL),
('142', '0', 'plg_installer_folderinstaller', 'plugin', 'folderinstaller', '', 'installer', '0', '1', '1', '0', '1', '{\"name\":\"plg_installer_folderinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Folder\",\"filename\":\"folderinstaller\"}', '', '', NULL, NULL, '2', '0', NULL),
('143', '0', 'plg_installer_override', 'plugin', 'override', '', 'installer', '0', '1', '1', '0', '1', '{\"name\":\"plg_installer_override\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_INSTALLER_OVERRIDE_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Override\",\"filename\":\"override\"}', '', '', NULL, NULL, '4', '0', NULL),
('144', '0', 'plg_installer_packageinstaller', 'plugin', 'packageinstaller', '', 'installer', '0', '1', '1', '0', '1', '{\"name\":\"plg_installer_packageinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Package\",\"filename\":\"packageinstaller\"}', '', '', NULL, NULL, '1', '0', NULL),
('145', '0', 'plg_installer_urlinstaller', 'plugin', 'urlinstaller', '', 'installer', '0', '1', '1', '0', '1', '{\"name\":\"plg_installer_urlinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Url\",\"filename\":\"urlinstaller\"}', '', '', NULL, NULL, '3', '0', NULL),
('146', '0', 'plg_installer_webinstaller', 'plugin', 'webinstaller', '', 'installer', '0', '1', '1', '0', '1', '{\"name\":\"plg_installer_webinstaller\",\"type\":\"plugin\",\"creationDate\":\"2017-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_INSTALLER_WEBINSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Web\",\"filename\":\"webinstaller\"}', '{\"tab_position\":\"1\"}', '', NULL, NULL, '5', '0', NULL),
('147', '0', 'plg_media-action_crop', 'plugin', 'crop', '', 'media-action', '0', '1', '1', '0', '1', '{\"name\":\"plg_media-action_crop\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_CROP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\MediaAction\\\\Crop\",\"filename\":\"crop\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('148', '0', 'plg_media-action_resize', 'plugin', 'resize', '', 'media-action', '0', '1', '1', '0', '1', '{\"name\":\"plg_media-action_resize\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_RESIZE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\MediaAction\\\\Resize\",\"filename\":\"resize\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('149', '0', 'plg_media-action_rotate', 'plugin', 'rotate', '', 'media-action', '0', '1', '1', '0', '1', '{\"name\":\"plg_media-action_rotate\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_ROTATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\MediaAction\\\\Rotate\",\"filename\":\"rotate\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('150', '0', 'plg_privacy_actionlogs', 'plugin', 'actionlogs', '', 'privacy', '0', '1', '1', '0', '1', '{\"name\":\"plg_privacy_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Actionlogs\",\"filename\":\"actionlogs\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('151', '0', 'plg_privacy_consents', 'plugin', 'consents', '', 'privacy', '0', '1', '1', '0', '1', '{\"name\":\"plg_privacy_consents\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONSENTS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Consents\",\"filename\":\"consents\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('152', '0', 'plg_privacy_contact', 'plugin', 'contact', '', 'privacy', '0', '1', '1', '0', '1', '{\"name\":\"plg_privacy_contact\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Contact\",\"filename\":\"contact\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('153', '0', 'plg_privacy_content', 'plugin', 'content', '', 'privacy', '0', '1', '1', '0', '1', '{\"name\":\"plg_privacy_content\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Content\",\"filename\":\"content\"}', '{}', '', NULL, NULL, '4', '0', NULL),
('154', '0', 'plg_privacy_message', 'plugin', 'message', '', 'privacy', '0', '1', '1', '0', '1', '{\"name\":\"plg_privacy_message\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_MESSAGE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Message\",\"filename\":\"message\"}', '{}', '', NULL, NULL, '5', '0', NULL),
('155', '0', 'plg_privacy_user', 'plugin', 'user', '', 'privacy', '0', '1', '1', '0', '1', '{\"name\":\"plg_privacy_user\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_USER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\User\",\"filename\":\"user\"}', '{}', '', NULL, NULL, '6', '0', NULL),
('156', '0', 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', '', 'quickicon', '0', '1', '1', '0', '1', '{\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Joomlaupdate\",\"filename\":\"joomlaupdate\"}', '', '', NULL, NULL, '1', '0', NULL),
('157', '0', 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', '', 'quickicon', '0', '1', '1', '0', '1', '{\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Extensionupdate\",\"filename\":\"extensionupdate\"}', '', '', NULL, NULL, '2', '0', NULL),
('158', '0', 'plg_quickicon_overridecheck', 'plugin', 'overridecheck', '', 'quickicon', '0', '1', '1', '0', '1', '{\"name\":\"plg_quickicon_overridecheck\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_QUICKICON_OVERRIDECHECK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\OverrideCheck\",\"filename\":\"overridecheck\"}', '', '', NULL, NULL, '3', '0', NULL),
('159', '0', 'plg_quickicon_downloadkey', 'plugin', 'downloadkey', '', 'quickicon', '0', '1', '1', '0', '1', '{\"name\":\"plg_quickicon_downloadkey\",\"type\":\"plugin\",\"creationDate\":\"2019-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_QUICKICON_DOWNLOADKEY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Downloadkey\",\"filename\":\"downloadkey\"}', '', '', NULL, NULL, '4', '0', NULL),
('160', '0', 'plg_quickicon_privacycheck', 'plugin', 'privacycheck', '', 'quickicon', '0', '1', '1', '0', '1', '{\"name\":\"plg_quickicon_privacycheck\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_QUICKICON_PRIVACYCHECK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\PrivacyCheck\",\"filename\":\"privacycheck\"}', '{}', '', NULL, NULL, '5', '0', NULL),
('161', '0', 'plg_quickicon_phpversioncheck', 'plugin', 'phpversioncheck', '', 'quickicon', '0', '1', '1', '0', '1', '{\"name\":\"plg_quickicon_phpversioncheck\",\"type\":\"plugin\",\"creationDate\":\"2016-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\PhpVersionCheck\",\"filename\":\"phpversioncheck\"}', '', '', NULL, NULL, '6', '0', NULL),
('162', '0', 'plg_quickicon_eos', 'plugin', 'eos', '', 'quickicon', '0', '1', '1', '0', '1', '{\"name\":\"plg_quickicon_eos\",\"type\":\"plugin\",\"creationDate\":\"2023-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.4.0\",\"description\":\"PLG_QUICKICON_EOS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Eos\",\"filename\":\"eos\"}', '', '', NULL, NULL, '7', '0', NULL),
('163', '0', 'plg_sampledata_blog', 'plugin', 'blog', '', 'sampledata', '0', '1', '1', '0', '1', '{\"name\":\"plg_sampledata_blog\",\"type\":\"plugin\",\"creationDate\":\"2017-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\SampleData\\\\Blog\",\"filename\":\"blog\"}', '', '', NULL, NULL, '1', '0', NULL),
('164', '0', 'plg_sampledata_multilang', 'plugin', 'multilang', '', 'sampledata', '0', '1', '1', '0', '1', '{\"name\":\"plg_sampledata_multilang\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SAMPLEDATA_MULTILANG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\SampleData\\\\MultiLanguage\",\"filename\":\"multilang\"}', '', '', NULL, NULL, '2', '0', NULL),
('165', '0', 'plg_schemaorg_blogposting', 'plugin', 'blogposting', '', 'schemaorg', '0', '1', '1', '0', '0', '{\"name\":\"plg_schemaorg_blogposting\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_BLOGPOSTING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\BlogPosting\",\"filename\":\"blogposting\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('166', '0', 'plg_schemaorg_book', 'plugin', 'book', '', 'schemaorg', '0', '1', '1', '0', '0', '{\"name\":\"plg_schemaorg_book\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_BOOK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Book\",\"filename\":\"book\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('167', '0', 'plg_schemaorg_event', 'plugin', 'event', '', 'schemaorg', '0', '1', '1', '0', '0', '{\"name\":\"plg_schemaorg_event\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_EVENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Event\",\"filename\":\"event\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('168', '0', 'plg_schemaorg_organization', 'plugin', 'organization', '', 'schemaorg', '0', '1', '1', '0', '0', '{\"name\":\"plg_schemaorg_organization\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_ORGANIZATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Organization\",\"filename\":\"organization\"}', '{}', '', NULL, NULL, '4', '0', NULL),
('169', '0', 'plg_schemaorg_person', 'plugin', 'person', '', 'schemaorg', '0', '1', '1', '0', '0', '{\"name\":\"plg_schemaorg_person\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_PERSON_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Person\",\"filename\":\"person\"}', '{}', '', NULL, NULL, '5', '0', NULL),
('170', '0', 'plg_schemaorg_recipe', 'plugin', 'recipe', '', 'schemaorg', '0', '1', '1', '0', '0', '{\"name\":\"plg_schemaorg_recipe\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_RECIPE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Recipe\",\"filename\":\"recipe\"}', '{}', '', NULL, NULL, '6', '0', NULL),
('171', '0', 'plg_schemaorg_jobposting', 'plugin', 'jobposting', '', 'schemaorg', '0', '1', '1', '0', '0', '{\"name\":\"plg_schemaorg_jobposting\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_JOBPOSTING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\JobPosting\",\"filename\":\"jobposting\"}', '{}', '', NULL, NULL, '7', '0', NULL),
('172', '0', 'plg_system_accessibility', 'plugin', 'accessibility', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_accessibility\",\"type\":\"plugin\",\"creationDate\":\"2020-02-15\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_ACCESSIBILITY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Accessibility\",\"filename\":\"accessibility\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('173', '0', 'plg_system_actionlogs', 'plugin', 'actionlogs', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\ActionLogs\",\"filename\":\"actionlogs\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('174', '0', 'plg_system_cache', 'plugin', 'cache', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"2007-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Cache\",\"filename\":\"cache\"}', '{\"browsercache\":\"0\",\"cachetime\":\"15\"}', '', NULL, NULL, '3', '0', NULL),
('175', '0', 'plg_system_debug', 'plugin', 'debug', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"2006-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Debug\",\"filename\":\"debug\"}', '{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}', '', NULL, NULL, '4', '0', NULL),
('176', '0', 'plg_system_fields', 'plugin', 'fields', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_fields\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_SYSTEM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, '5', '0', NULL),
('177', '0', 'plg_system_highlight', 'plugin', 'highlight', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Highlight\",\"filename\":\"highlight\"}', '', '', NULL, NULL, '6', '0', NULL),
('178', '0', 'plg_system_httpheaders', 'plugin', 'httpheaders', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_httpheaders\",\"type\":\"plugin\",\"creationDate\":\"2017-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_HTTPHEADERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Httpheaders\",\"filename\":\"httpheaders\"}', '{}', '', NULL, NULL, '7', '0', NULL),
('179', '0', 'plg_system_jooa11y', 'plugin', 'jooa11y', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_jooa11y\",\"type\":\"plugin\",\"creationDate\":\"2022-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_SYSTEM_JOOA11Y_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Jooa11y\",\"filename\":\"jooa11y\"}', '', '', NULL, NULL, '8', '0', NULL),
('180', '0', 'plg_system_languagecode', 'plugin', 'languagecode', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"2011-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\LanguageCode\",\"filename\":\"languagecode\"}', '', '', NULL, NULL, '9', '0', NULL),
('181', '0', 'plg_system_languagefilter', 'plugin', 'languagefilter', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"2010-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\LanguageFilter\",\"filename\":\"languagefilter\"}', '', '', NULL, NULL, '10', '0', NULL),
('182', '0', 'plg_system_log', 'plugin', 'log', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"2007-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Log\",\"filename\":\"log\"}', '', '', NULL, NULL, '11', '0', NULL),
('183', '0', 'plg_system_logout', 'plugin', 'logout', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"2009-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Logout\",\"filename\":\"logout\"}', '', '', NULL, NULL, '12', '0', NULL),
('184', '0', 'plg_system_privacyconsent', 'plugin', 'privacyconsent', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_privacyconsent\",\"type\":\"plugin\",\"creationDate\":\"2018-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_PRIVACYCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\PrivacyConsent\",\"filename\":\"privacyconsent\"}', '{}', '', NULL, NULL, '14', '0', NULL),
('185', '0', 'plg_system_redirect', 'plugin', 'redirect', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"2009-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Redirect\",\"filename\":\"redirect\"}', '', '', NULL, NULL, '15', '0', NULL),
('186', '0', 'plg_system_remember', 'plugin', 'remember', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"2007-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Remember\",\"filename\":\"remember\"}', '', '', NULL, NULL, '16', '0', NULL),
('187', '0', 'plg_system_schedulerunner', 'plugin', 'schedulerunner', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_schedulerunner\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_SYSTEM_SCHEDULERUNNER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\ScheduleRunner\",\"filename\":\"schedulerunner\"}', '{}', '', NULL, NULL, '17', '0', NULL),
('188', '0', 'plg_system_schemaorg', 'plugin', 'schemaorg', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"plg_system_schemaorg\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SYSTEM_SCHEMAORG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Schemaorg\",\"filename\":\"schemaorg\"}', '{}', '', NULL, NULL, '18', '0', NULL),
('189', '0', 'plg_system_sef', 'plugin', 'sef', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"2007-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Sef\",\"filename\":\"sef\"}', '', '', NULL, NULL, '19', '0', NULL),
('190', '0', 'plg_system_shortcut', 'plugin', 'shortcut', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_shortcut\",\"type\":\"plugin\",\"creationDate\":\"2022-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_SYSTEM_SHORTCUT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Shortcut\",\"filename\":\"shortcut\"}', '{}', '', NULL, NULL, '21', '0', NULL),
('191', '0', 'plg_system_skipto', 'plugin', 'skipto', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_skipto\",\"type\":\"plugin\",\"creationDate\":\"2020-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_SKIPTO_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Skipto\",\"filename\":\"skipto\"}', '{}', '', NULL, NULL, '22', '0', NULL),
('192', '0', 'plg_system_stats', 'plugin', 'stats', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_stats\",\"type\":\"plugin\",\"creationDate\":\"2013-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_STATS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Stats\",\"filename\":\"stats\"}', 'null', '', NULL, NULL, '23', '0', NULL),
('193', '0', 'plg_system_task_notification', 'plugin', 'tasknotification', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_task_notification\",\"type\":\"plugin\",\"creationDate\":\"2021-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_SYSTEM_TASK_NOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\TaskNotification\",\"filename\":\"tasknotification\"}', '', '', NULL, NULL, '24', '0', NULL),
('194', '0', 'plg_system_webauthn', 'plugin', 'webauthn', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_webauthn\",\"type\":\"plugin\",\"creationDate\":\"2019-07-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_WEBAUTHN_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Webauthn\",\"filename\":\"webauthn\"}', '{}', '', NULL, NULL, '26', '0', NULL),
('195', '0', 'plg_task_check_files', 'plugin', 'checkfiles', '', 'task', '0', '1', '1', '0', '1', '{\"name\":\"plg_task_check_files\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_CHECK_FILES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\Checkfiles\",\"filename\":\"checkfiles\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('196', '0', 'plg_task_deleteactionlogs', 'plugin', 'deleteactionlogs', '', 'task', '0', '1', '1', '0', '1', '{\"name\":\"plg_task_deleteactionlogs\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_DELETEACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\DeleteActionLogs\",\"filename\":\"deleteactionlogs\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('197', '0', 'plg_task_globalcheckin', 'plugin', 'globalcheckin', '', 'task', '0', '1', '1', '0', '0', '{\"name\":\"plg_task_globalcheckin\",\"type\":\"plugin\",\"creationDate\":\"2023-06-22\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_GLOBALCHECKIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\Globalcheckin\",\"filename\":\"globalcheckin\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('198', '0', 'plg_task_requests', 'plugin', 'requests', '', 'task', '0', '1', '1', '0', '1', '{\"name\":\"plg_task_requests\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_REQUESTS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\Requests\",\"filename\":\"requests\"}', '{}', '', NULL, NULL, '4', '0', NULL),
('199', '0', 'plg_task_privacyconsent', 'plugin', 'privacyconsent', '', 'task', '0', '1', '1', '0', '1', '{\"name\":\"plg_task_privacyconsent\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_PRIVACYCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\PrivacyConsent\",\"filename\":\"privacyconsent\"}', '{}', '', NULL, NULL, '5', '0', NULL),
('200', '0', 'plg_task_rotatelogs', 'plugin', 'rotatelogs', '', 'task', '0', '1', '1', '0', '1', '{\"name\":\"plg_task_rotatelogs\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_ROTATELOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\RotateLogs\",\"filename\":\"rotatelogs\"}', '{}', '', NULL, NULL, '6', '0', NULL),
('201', '0', 'plg_task_sessiongc', 'plugin', 'sessiongc', '', 'task', '0', '1', '1', '0', '1', '{\"name\":\"plg_task_sessiongc\",\"type\":\"plugin\",\"creationDate\":\"2023-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_SESSIONGC_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\SessionGC\",\"filename\":\"sessiongc\"}', '{}', '', NULL, NULL, '7', '0', NULL),
('202', '0', 'plg_task_site_status', 'plugin', 'sitestatus', '', 'task', '0', '1', '1', '0', '1', '{\"name\":\"plg_task_site_status\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_SITE_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\SiteStatus\",\"filename\":\"sitestatus\"}', '{}', '', NULL, NULL, '8', '0', NULL),
('203', '0', 'plg_task_updatenotification', 'plugin', 'updatenotification', '', 'task', '0', '1', '1', '0', '1', '{\"name\":\"plg_task_updatenotification\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_UPDATENOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\UpdateNotification\",\"filename\":\"updatenotification\"}', '{}', '', NULL, NULL, '9', '0', NULL),
('204', '0', 'plg_multifactorauth_totp', 'plugin', 'totp', '', 'multifactorauth', '0', '1', '1', '0', '1', '{\"name\":\"plg_multifactorauth_totp\",\"type\":\"plugin\",\"creationDate\":\"2013-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_TOTP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Totp\",\"filename\":\"totp\"}', '', '', NULL, NULL, '1', '0', NULL),
('205', '0', 'plg_multifactorauth_yubikey', 'plugin', 'yubikey', '', 'multifactorauth', '0', '1', '1', '0', '1', '{\"name\":\"plg_multifactorauth_yubikey\",\"type\":\"plugin\",\"creationDate\":\"2013-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_YUBIKEY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Yubikey\",\"filename\":\"yubikey\"}', '', '', NULL, NULL, '2', '0', NULL),
('206', '0', 'plg_multifactorauth_webauthn', 'plugin', 'webauthn', '', 'multifactorauth', '0', '1', '1', '0', '1', '{\"name\":\"plg_multifactorauth_webauthn\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_WEBAUTHN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Webauthn\",\"filename\":\"webauthn\"}', '', '', NULL, NULL, '3', '0', NULL),
('207', '0', 'plg_multifactorauth_email', 'plugin', 'email', '', 'multifactorauth', '0', '1', '1', '0', '1', '{\"name\":\"plg_multifactorauth_email\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_EMAIL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Email\",\"filename\":\"email\"}', '', '', NULL, NULL, '4', '0', NULL),
('208', '0', 'plg_multifactorauth_fixed', 'plugin', 'fixed', '', 'multifactorauth', '0', '0', '1', '0', '1', '{\"name\":\"plg_multifactorauth_fixed\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_FIXED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Fixed\",\"filename\":\"fixed\"}', '', '', NULL, NULL, '5', '0', NULL),
('209', '0', 'plg_user_contactcreator', 'plugin', 'contactcreator', '', 'user', '0', '0', '1', '0', '1', '{\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"2009-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\ContactCreator\",\"filename\":\"contactcreator\"}', '{\"autowebpage\":\"\",\"category\":\"4\",\"autopublish\":\"0\"}', '', NULL, NULL, '1', '0', NULL),
('210', '0', 'plg_user_joomla', 'plugin', 'joomla', '', 'user', '0', '1', '1', '0', '1', '{\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"2006-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Joomla\",\"filename\":\"joomla\"}', '{\"autoregister\":\"1\",\"mail_to_user\":\"1\",\"forceLogout\":\"1\"}', '', NULL, NULL, '2', '0', NULL),
('211', '0', 'plg_user_profile', 'plugin', 'profile', '', 'user', '0', '0', '1', '0', '1', '{\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"2008-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2008 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Profile\",\"filename\":\"profile\"}', '{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}', '', NULL, NULL, '3', '0', NULL),
('212', '0', 'plg_user_terms', 'plugin', 'terms', '', 'user', '0', '0', '1', '0', '1', '{\"name\":\"plg_user_terms\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TERMS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Terms\",\"filename\":\"terms\"}', '{}', '', NULL, NULL, '4', '0', NULL),
('213', '0', 'plg_user_token', 'plugin', 'token', '', 'user', '0', '1', '1', '0', '1', '{\"name\":\"plg_user_token\",\"type\":\"plugin\",\"creationDate\":\"2019-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TOKEN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Token\",\"filename\":\"token\"}', '{}', '', NULL, NULL, '5', '0', NULL),
('214', '0', 'plg_webservices_banners', 'plugin', 'banners', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_banners\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Banners\",\"filename\":\"banners\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('215', '0', 'plg_webservices_config', 'plugin', 'config', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_config\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONFIG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Config\",\"filename\":\"config\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('216', '0', 'plg_webservices_contact', 'plugin', 'contact', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_contact\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Contact\",\"filename\":\"contact\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('217', '0', 'plg_webservices_content', 'plugin', 'content', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_content\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Content\",\"filename\":\"content\"}', '{}', '', NULL, NULL, '4', '0', NULL),
('218', '0', 'plg_webservices_installer', 'plugin', 'installer', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_installer\",\"type\":\"plugin\",\"creationDate\":\"2020-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_INSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Installer\",\"filename\":\"installer\"}', '{}', '', NULL, NULL, '5', '0', NULL),
('219', '0', 'plg_webservices_languages', 'plugin', 'languages', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_languages\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Languages\",\"filename\":\"languages\"}', '{}', '', NULL, NULL, '6', '0', NULL),
('220', '0', 'plg_webservices_media', 'plugin', 'media', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_media\",\"type\":\"plugin\",\"creationDate\":\"2021-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.0\",\"description\":\"PLG_WEBSERVICES_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Media\",\"filename\":\"media\"}', '{}', '', NULL, NULL, '7', '0', NULL),
('221', '0', 'plg_webservices_menus', 'plugin', 'menus', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_menus\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MENUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Menus\",\"filename\":\"menus\"}', '{}', '', NULL, NULL, '7', '0', NULL),
('222', '0', 'plg_webservices_messages', 'plugin', 'messages', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_messages\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Messages\",\"filename\":\"messages\"}', '{}', '', NULL, NULL, '8', '0', NULL),
('223', '0', 'plg_webservices_modules', 'plugin', 'modules', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_modules\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MODULES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Modules\",\"filename\":\"modules\"}', '{}', '', NULL, NULL, '9', '0', NULL),
('224', '0', 'plg_webservices_newsfeeds', 'plugin', 'newsfeeds', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Newsfeeds\",\"filename\":\"newsfeeds\"}', '{}', '', NULL, NULL, '10', '0', NULL),
('225', '0', 'plg_webservices_plugins', 'plugin', 'plugins', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_plugins\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_PLUGINS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Plugins\",\"filename\":\"plugins\"}', '{}', '', NULL, NULL, '11', '0', NULL),
('226', '0', 'plg_webservices_privacy', 'plugin', 'privacy', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_privacy\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Privacy\",\"filename\":\"privacy\"}', '{}', '', NULL, NULL, '12', '0', NULL),
('227', '0', 'plg_webservices_redirect', 'plugin', 'redirect', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_redirect\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Redirect\",\"filename\":\"redirect\"}', '{}', '', NULL, NULL, '13', '0', NULL),
('228', '0', 'plg_webservices_tags', 'plugin', 'tags', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_tags\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Tags\",\"filename\":\"tags\"}', '{}', '', NULL, NULL, '14', '0', NULL),
('229', '0', 'plg_webservices_templates', 'plugin', 'templates', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_templates\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Templates\",\"filename\":\"templates\"}', '{}', '', NULL, NULL, '15', '0', NULL),
('230', '0', 'plg_webservices_users', 'plugin', 'users', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_users\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_USERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Users\",\"filename\":\"users\"}', '{}', '', NULL, NULL, '16', '0', NULL),
('231', '0', 'plg_workflow_featuring', 'plugin', 'featuring', '', 'workflow', '0', '1', '1', '0', '1', '{\"name\":\"plg_workflow_featuring\",\"type\":\"plugin\",\"creationDate\":\"2020-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_FEATURING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Workflow\\\\Featuring\",\"filename\":\"featuring\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('232', '0', 'plg_workflow_notification', 'plugin', 'notification', '', 'workflow', '0', '1', '1', '0', '1', '{\"name\":\"plg_workflow_notification\",\"type\":\"plugin\",\"creationDate\":\"2020-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_NOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Workflow\\\\Notification\",\"filename\":\"notification\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('233', '0', 'plg_workflow_publishing', 'plugin', 'publishing', '', 'workflow', '0', '1', '1', '0', '1', '{\"name\":\"plg_workflow_publishing\",\"type\":\"plugin\",\"creationDate\":\"2020-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_PUBLISHING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Workflow\\\\Publishing\",\"filename\":\"publishing\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('234', '0', 'plg_system_guidedtours', 'plugin', 'guidedtours', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_guidedtours\",\"type\":\"plugin\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"PLG_SYSTEM_GUIDEDTOURS_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\GuidedTours\",\"filename\":\"guidedtours\"}', '{}', '', NULL, NULL, '15', '0', NULL),
('235', '0', 'atum', 'template', 'atum', '', '', '1', '1', '1', '0', '1', '{\"name\":\"atum\",\"type\":\"template\",\"creationDate\":\"2016-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_ATUM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"inheritable\":true,\"filename\":\"templateDetails\"}', '', '', NULL, NULL, '0', '0', NULL),
('236', '0', 'cassiopeia', 'template', 'cassiopeia', '', '', '0', '1', '1', '0', '1', '{\"name\":\"cassiopeia\",\"type\":\"template\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_CASSIOPEIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"inheritable\":true,\"filename\":\"templateDetails\"}', '{\"brand\":\"1\",\"logoFile\":\"\",\"siteTitle\":\"\",\"siteDescription\":\"\",\"useFontScheme\":\"0\",\"colorName\":\"colors_standard\",\"fluidContainer\":\"0\",\"stickyHeader\":0,\"backTop\":0}', '', NULL, NULL, '0', '0', NULL),
('237', '0', 'files_joomla', 'file', 'joomla', '', '', '0', '1', '1', '1', '1', '{\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"2025-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.3.3\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, '0', '0', NULL),
('238', '0', 'English (en-GB) Language Pack', 'package', 'pkg_en-GB', '', '', '0', '1', '1', '1', '1', '{\"name\":\"English (en-GB) Language Pack\",\"type\":\"package\",\"creationDate\":\"2025-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.3.3.1\",\"description\":\"en-GB language pack\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"pkg_en-GB\"}', '', '', NULL, NULL, '0', '0', NULL),
('239', '238', 'English (en-GB)', 'language', 'en-GB', '', '', '0', '1', '1', '1', '1', '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2025-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.3.3\",\"description\":\"en-GB site language\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, '0', '0', NULL),
('240', '238', 'English (en-GB)', 'language', 'en-GB', '', '', '1', '1', '1', '1', '1', '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2025-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.3.3\",\"description\":\"en-GB administrator language\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, '0', '0', NULL),
('241', '238', 'English (en-GB)', 'language', 'en-GB', '', '', '3', '1', '1', '1', '1', '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2025-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.3.3\",\"description\":\"en-GB api language\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, '0', '0', NULL),
('243', '247', 'System - Astroid Plugin', 'plugin', 'astroid', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"System - Astroid Plugin\",\"type\":\"plugin\",\"creationDate\":\"September 2025\",\"author\":\"Astroid Framework Team\",\"copyright\":\"Copyright (C) 2025 TemPlaza, Inc. All rights reserved.\",\"authorEmail\":\"info@templaza.com\",\"authorUrl\":\"https:\\/\\/www.templaza.com\",\"version\":\"3.3.2\",\"description\":\"Astroid Framework core plugin where Astroid libraries are called. You must enable this plugin if you want to use Astroid Framework.\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Astroid\",\"filename\":\"astroid\"}', '{\"astroid_load_fontawesome\":\"cdn\",\"astroid_inline_css\":\"0\",\"astroid_shortcut_enable\":\"1\",\"astroid_color_mode_enable\":\"1\",\"astroid_enable_widgets\":\"1\",\"astroid_remove_generator\":\"0\",\"astroid_debug\":\"0\",\"gmap_api\":\"\",\"frontend_tabs_visibility\":\"1\",\"last_get_promotion\":\"{\\\"time\\\":\\\"2025-09-25\\\",\\\"data\\\":{\\\"promotion\\\":{\\\"title\\\":\\\"Extended Mid-Year, Full Power \\\\u2013 Get 50% Off Astroid Subscriptions!\\\",\\\"description\\\":\\\"From July 14 to July 20, 2025, enjoy half-price discounts on all Astroid subscription plans. Whether you\\\\u2019re building for clients or crafting your own site, this is your chance to unlock Astroid\\\\u2019s full potential for a fraction of the cost.\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/astroidframe.work\\\\\\/pricing\\\",\\\"link_title\\\":\\\"Upgrade Now - Save 50%\\\",\\\"image\\\":\\\"https:\\\\\\/\\\\\\/www.astroidframework.com\\\\\\/images\\\\\\/logo.png\\\",\\\"validity\\\":\\\"20225-07-14\\\",\\\"expiration\\\":\\\"2025-07-20\\\"}}}\"}', '', NULL, NULL, '0', '0', ''),
('244', '247', 'Astroid Clear Cache', 'module', 'mod_astroid_clear_cache', '', '', '1', '1', '2', '0', '0', '{\"name\":\"Astroid Clear Cache\",\"type\":\"module\",\"creationDate\":\"September 2025\",\"author\":\"TemPlaza\",\"copyright\":\"(C) 2025 TemPlaza.com.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\",\"version\":\"3.3.2\",\"description\":\"Astroid Clear Cache Module\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"mod_astroid_clear_cache\"}', '[]', '', NULL, NULL, '0', '0', NULL),
('245', '247', 'Astroid Menu Module', 'module', 'mod_astroid_menu', '', '', '0', '1', '0', '0', '0', '{\"name\":\"Astroid Menu Module\",\"type\":\"module\",\"creationDate\":\"September 2025\",\"author\":\"Astroid Framework\",\"copyright\":\"(C) 2025 Astroid Framework\",\"authorEmail\":\"sonlv@templaza.com\",\"authorUrl\":\"astroidframe.work\",\"version\":\"3.3.2\",\"description\":\"MOD_ASTROID_MENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"mod_astroid_menu\"}', '{\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"menu_breakpoint\":\"lg\",\"layout\":\"_:default\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', NULL, NULL, '0', '0', NULL),
('246', '247', 'tz_travelami', 'template', 'tz_travelami', '', '', '0', '1', '1', '0', '0', '{\"name\":\"tz_travelami\",\"type\":\"template\",\"creationDate\":\"June 2024\",\"author\":\"Astroid Framework\",\"copyright\":\"Copyright (C) 2024 AstroidFrame.work, Inc. All rights reserved.\",\"authorEmail\":\"sonlv@templaza.com\",\"authorUrl\":\"https:\\/\\/astroidframe.work\",\"version\":\"1.0.0\",\"description\":\"TPL_ASTROID_XML_DESCRIPTION\",\"group\":\"\",\"inheritable\":true,\"filename\":\"templateDetails\"}', '[]', '', NULL, NULL, '0', '0', NULL),
('247', '0', 'Travelami Package', 'package', 'pkg_astroid', '', '', '0', '1', '1', '0', '0', '{\"name\":\"Travelami Package\",\"type\":\"package\",\"creationDate\":\"June 2024\",\"author\":\"Astroid Framework\",\"copyright\":\"Copyright (C) 2024 AstroidFrame.work. All rights reserved.\",\"authorEmail\":\"info@templaza.com\",\"authorUrl\":\"https:\\/\\/astroidframe.work\",\"version\":\"1.0.0\",\"description\":\"\",\"group\":\"\",\"filename\":\"pkg_astroid\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('249', '0', 'com_tz_portfolio_plus', 'component', 'com_tz_portfolio_plus', '', '', '1', '1', '0', '0', '0', '{\"name\":\"com_tz_portfolio_plus\",\"type\":\"component\",\"creationDate\":\"September 7th, 2017\",\"author\":\"TZ Portfolio+\",\"copyright\":\"Copyright (C) 2011 - 2021 TZ Portfolio.com. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"http:\\/\\/www.tzportfolio.com\",\"version\":\"2.7.1\",\"description\":\"\",\"group\":\"\"}', '{\"token_key\":\"\",\"tz_article_limit\":\"10\",\"tz_article_intro_limit\":\"\",\"use_filter_first_letter\":\"0\",\"tz_letters\":\"a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z\",\"article_columns\":\"\",\"enable_lazyload\":\"0\",\"show_limit_box\":\"0\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"orderby_pri\":\"none\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"order_fieldgroup\":\"rdate\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\",\"tz_portfolio_plus_layout\":\"ajaxInfiScroll\",\"tz_show_filter\":\"0\",\"show_all_filter\":\"0\",\"tz_filter_type\":\"categories\",\"filter_second_category\":\"1\",\"filter_tags_categories_order\":\"auto\",\"show_sort\":\"0\",\"show_layout\":\"0\",\"layout_type\":[\"masonry\"],\"tz_show_no_more_page\":\"0\",\"tz_no_more_page_text\":\"No more items to load\",\"tz_column_width\":\"450\",\"remember_recent_article\":\"0\",\"show_cat_about_title\":\"0\",\"show_cat_about_image\":\"0\",\"show_cat_about_description\":\"0\",\"show_tag_title_heading\":\"1\",\"menu_active\":\"auto\",\"user_menu_active\":\"auto\",\"show_date_title\":\"1\",\"date_link_titles\":\"1\",\"show_date_intro\":\"1\",\"show_date_category\":\"1\",\"date_link_category\":\"1\",\"show_date_parent_category\":\"0\",\"date_link_parent_category\":\"1\",\"show_date_author\":\"1\",\"date_link_author\":\"1\",\"show_date_create_date\":\"1\",\"show_date_modify_date\":\"0\",\"show_date_publish_date\":\"0\",\"show_date_readmore\":\"1\",\"show_date_hits\":\"1\",\"show_date_tags\":\"1\",\"show_date_icons\":\"1\",\"show_date_print_icon\":\"0\",\"show_date_email_icon\":\"0\",\"show_search_intro\":\"1\",\"show_search_category_filter\":\"0\",\"search_parent_cat\":\"0\",\"show_s_parent_root\":\"1\",\"search_subcategory\":\"0\",\"show_s_gfield_title\":\"1\",\"show_search_category\":\"0\",\"show_search_author\":\"1\",\"search_link_author\":\"1\",\"show_search_create_date\":\"1\",\"show_search_modify_date\":\"0\",\"show_search_publish_date\":\"0\",\"show_search_readmore\":\"1\",\"show_search_hits\":\"1\",\"show_search_tags\":\"1\",\"show_search_item_media\":\"1\",\"show_search_icons\":\"1\",\"show_search_print_icon\":\"0\",\"show_search_email_icon\":\"0\",\"show_base_description\":\"1\",\"show_description_image\":\"0\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_articles_cat\":\"1\",\"enable_jquery\":\"0\",\"enable_bootstrap\":\"0\",\"bootstrapversion\":\"4\",\"enable_bootstrap_js\":\"1\",\"tzSef\":\"1\",\"sef_remove_category\":\"1\",\"sef_portfolio_prefix\":\"category\",\"sef_users_prefix\":\"user\",\"sef_tags_prefix\":\"tag\",\"sef_date_prefix\":\"date\",\"sef_article_separator\":\"slash_revert_id\",\"sef_use_article_id\":\"1\",\"sef_use_article_alias\":\"1\",\"sef_remove_category_id\":\"0\",\"sef_use_parent_category\":\"1\",\"sef_user_separator\":\"slash_revert_id\",\"sef_use_user_alias\":\"1\",\"sef_tag_separator\":\"slash_revert_id\",\"sef_use_tag_alias\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('250', '0', 'mod_tz_portfolio_plus_articles_archive', 'module', 'mod_tz_portfolio_plus_articles_archive', '', '', '0', '1', '0', '0', '0', '{\"name\":\"mod_tz_portfolio_plus_articles_archive\",\"type\":\"module\",\"creationDate\":\"January 25th 2013\",\"author\":\"DuongTVTemplaza\",\"copyright\":\"Copyright (C) 2015 TemPlaza. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"2.6.4\",\"description\":\"MOD_TZ_PORTFOLIO_PLUS_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tz_portfolio_plus_articles_archive\"}', '{\"count\":\"10\",\"show_article_count\":\"1\",\"tzmenuitem\":\"auto\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"enable_bootstrap\":\"0\",\"bootstrapversion\":\"3\",\"enable_bootstrap_js\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('251', '0', 'mod_tz_portfolio_plus_categories', 'module', 'mod_tz_portfolio_plus_categories', '', '', '0', '1', '0', '0', '0', '{\"name\":\"mod_tz_portfolio_plus_categories\",\"type\":\"module\",\"creationDate\":\"January 25th 2013\",\"author\":\"DuongTVTemplaza\",\"copyright\":\"Copyright (C) 2015 TemPlaza. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"2.6.7\",\"description\":\"MOD_TZ_PORTFOLIO_PLUS_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tz_portfolio_plus_categories\"}', '{\"catid\":\"\",\"show_total\":\"1\",\"show_desc\":\"1\",\"show_image\":\"1\",\"show_title\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"enable_bootstrap\":\"0\",\"bootstrapversion\":\"3\",\"enable_bootstrap_js\":\"1\",\"enable_lazyload\":\"0\"}', '', NULL, NULL, '0', '0', NULL),
('252', '0', 'mod_tz_portfolio_plus_filter', 'module', 'mod_tz_portfolio_plus_filter', '', '', '0', '1', '0', '0', '0', '{\"name\":\"mod_tz_portfolio_plus_filter\",\"type\":\"module\",\"creationDate\":\"February 14th 2023\",\"author\":\"TemPlaza\",\"copyright\":\"Copyright (C) 2023 TemPlaza. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.tzportfolio.com\\/\",\"version\":\"2.6.4\",\"description\":\"MOD_TZ_PORTFOLIO_PLUS_FILTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tz_portfolio_plus_filter\"}', '{\"show_search_word\":\"1\",\"show_box_label\":\"1\",\"button\":\"1\",\"imagebutton\":\"0\",\"button_style\":\"1\",\"search_inline\":\"0\",\"show_category\":\"0\",\"show_category_text\":\"1\",\"show_parent_root\":\"1\",\"show_fields\":\"1\",\"show_group_title\":\"0\",\"set_itemid\":\"0\",\"column_lg\":\"1\",\"column_md\":\"1\",\"column_sm\":\"1\",\"column\":\"1\",\"gutter\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"enable_bootstrap\":\"0\",\"bootstrapversion\":\"3\",\"enable_bootstrap_js\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('253', '0', 'mod_tz_portfolio_plus_portfolio', 'module', 'mod_tz_portfolio_plus_portfolio', '', '', '0', '1', '0', '0', '0', '{\"name\":\"mod_tz_portfolio_plus_portfolio\",\"type\":\"module\",\"creationDate\":\"January 10 2018\",\"author\":\"DuongTVTemplaza\",\"copyright\":\"Copyright (C) 2015-2018 TemPlaza. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"2.6.4\",\"description\":\"MOD_TZ_PORTFOLIO_PLUS_PORTFOLIO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tz_portfolio_plus_portfolio\"}', '{\"catid\":\"\",\"show_title\":\"1\",\"show_introtext\":\"1\",\"show_created_date\":\"1\",\"show_hit\":\"1\",\"show_author\":\"1\",\"show_category\":\"1\",\"show_tag\":\"1\",\"show_readmore\":\"1\",\"readmore_text\":\"Read more\",\"show_view_all\":\"0\",\"view_all_text\":\"View All Portfolios\",\"article_limit\":\"5\",\"show_featured\":\"\",\"random_article\":\"0\",\"orderby_pri\":\"none\",\"orderby_sec\":\"rdate\",\"order_date\":\"created\",\"usermenuitem\":\"auto\",\"tagmenuitem\":\"auto\",\"load_style\":\"0\",\"width_element\":\"300\",\"height_element\":\"\",\"show_filter\":\"1\",\"tz_filter_type\":\"categories\",\"enable_resize_image\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"enable_bootstrap\":\"0\",\"bootstrapversion\":\"3\",\"enable_bootstrap_js\":\"1\",\"enable_lazyload\":\"0\"}', '', NULL, NULL, '0', '0', NULL),
('254', '0', 'mod_tz_portfolio_plus_tags', 'module', 'mod_tz_portfolio_plus_tags', '', '', '0', '1', '0', '0', '0', '{\"name\":\"mod_tz_portfolio_plus_tags\",\"type\":\"module\",\"creationDate\":\"November 20th 2015\",\"author\":\"tuanna\",\"copyright\":\"Copyright (C) 2015 TemPlaza. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"2.6.7\",\"description\":\"MOD_TZ_PORTFOLIO_PLUS_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tz_portfolio_plus_tags\"}', '{\"enable_link\":\"1\",\"enable_min_max_font_size\":\"1\",\"maxfont\":\"300\",\"minfont\":\"75\",\"show_article_counter\":\"1\",\"show_tag_all\":\"0\",\"tag_all_text\":\"All\",\"menu_active\":\"auto\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"enable_bootstrap\":\"0\",\"bootstrapversion\":\"3\",\"enable_bootstrap_js\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('255', '0', 'plg_quickicon_tz_portfolio_plus', 'plugin', 'tz_portfolio_plus', '', 'quickicon', '0', '1', '1', '0', '0', '{\"name\":\"plg_quickicon_tz_portfolio_plus\",\"type\":\"plugin\",\"creationDate\":\"July 26th 2019\",\"author\":\"DuongTVTemPlaza\",\"copyright\":\"Copyright (C) 2011-2019 TZ Portfolio. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"2.6.0\",\"description\":\"\",\"group\":\"\",\"filename\":\"tz_portfolio_plus\"}', '', '', NULL, NULL, '0', '0', NULL),
('256', '0', 'plg_system_tz_portfolio_plus', 'plugin', 'tz_portfolio_plus', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"plg_system_tz_portfolio_plus\",\"type\":\"plugin\",\"creationDate\":\"January 25th 2013\",\"author\":\"DuongTVTemPlaza\",\"copyright\":\"Copyright (C) 2015 TemPlaza. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"2.6.0\",\"description\":\"\",\"group\":\"\",\"filename\":\"tz_portfolio_plus\"}', '', '', NULL, NULL, '0', '0', NULL),
('265', '0', 'plg_schemaorg_article', 'plugin', 'article', '', 'schemaorg', '0', '1', '1', '0', '0', '{\"name\":\"plg_schemaorg_article\",\"type\":\"plugin\",\"creationDate\":\"2024-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2024 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.1.0\",\"description\":\"PLG_SCHEMAORG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Article\",\"filename\":\"article\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('266', '0', 'plg_schemaorg_custom', 'plugin', 'custom', '', 'schemaorg', '0', '1', '1', '0', '0', '{\"name\":\"plg_schemaorg_custom\",\"type\":\"plugin\",\"creationDate\":\"2024-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2024 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.1.0\",\"description\":\"PLG_SCHEMAORG_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Custom\",\"filename\":\"custom\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('270', '0', 'mod_tz_portfolio_plus_carousel', 'module', 'mod_tz_portfolio_plus_carousel', '', '', '0', '1', '0', '0', '0', '{\"name\":\"mod_tz_portfolio_plus_carousel\",\"type\":\"module\",\"creationDate\":\"January 11 2018\",\"author\":\"DuongTVTemPlaza\",\"copyright\":\"Copyright (C) 2011-2018 TZ Portfolio.com. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.tzportfolio.com\\/\",\"version\":\"1.0.6\",\"description\":\"MOD_TZ_PORTFOLIO_PLUS_CAROUSEL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tz_portfolio_plus_carousel\"}', '{\"article_limit\":\"5\",\"orderby_sec\":\"rdate\",\"show_title\":\"1\",\"show_introtext\":\"1\",\"show_created_date\":\"1\",\"show_modified_date\":\"1\",\"show_publish_date\":\"1\",\"show_hit\":\"1\",\"show_author\":\"1\",\"show_category_main\":\"1\",\"show_category_sec\":\"1\",\"show_tag\":\"1\",\"show_readmore\":\"1\",\"show_noauth\":\"0\",\"show_view_all\":\"0\",\"view_all_text\":\"View All Portfolios\",\"usermenuitem\":\"auto\",\"tagmenuitem\":\"auto\",\"cr_loop\":\"0\",\"cr_autoplay\":\"0\",\"cr_autoplayTimeout\":\"5000\",\"cr_autoplayHoverPause\":\"0\",\"cr_mouseDrag\":\"1\",\"cr_touchDrag\":\"1\",\"cr_nav\":\"1\",\"cr_slideBy\":\"1\",\"cr_prev_text\":\"\\u2039\",\"cr_next_text\":\"\\u203a\",\"cr_dots\":\"1\",\"cr_lazyLoad\":\"0\",\"cr_center\":\"0\",\"cr_autoWidth\":\"0\",\"cr_autoHeight\":\"0\",\"cr_rtl\":\"0\",\"cr_items\":\"1\",\"cr_margin\":\"0\",\"cr_stagePadding\":\"0\",\"cr_smartSpeed\":\"250\",\"cr_responsive\":\"{\\\"width\\\":992,\\\"item\\\":3},{\\\"width\\\":768,\\\"item\\\":2},{\\\"width\\\":0,\\\"item\\\":1}\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', NULL, NULL, '0', '0', NULL),
('271', '273', 'com_akeebabackup', 'component', 'com_akeebabackup', '', '', '1', '1', '0', '0', '0', '{\"name\":\"com_akeebabackup\",\"type\":\"component\",\"creationDate\":\"2025-09-01\",\"author\":\"Akeeba Ltd\",\"copyright\":\"Copyright (c)2006-2025 Akeeba Ltd \\/ Nicholas K. Dionysopoulos\",\"authorEmail\":\"no-reply@akeeba.com\",\"authorUrl\":\"www.akeeba.com\",\"version\":\"10.0.6\",\"description\":\"COM_AKEEBABACKUP_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Akeeba\\\\Component\\\\AkeebaBackup\",\"filename\":\"akeebabackup\"}', '{\"frontend_secret_word\":\"###AES128###rUV4vhIJImPK2lz9HG+CdkpQU1QRyMajCfZtG4m7dFBEMQfp9mrOLaeI2fSNHosFNoBdjeq0mJAo1ARhxOtZQCtlekSYp+kDz3OQ9oVLN3Wl1OI\\/SlBJVgrTLLFcefOlq9\\/qJL1BGXEAAAAA\",\"confwiz_upgrade\":1,\"siteurl\":\"https:\\/\\/travelami.jollyany.co\\/\",\"jlibrariesdir\":\"\\/home\\/customer\\/www\\/travelami.jollyany.co\\/public_html\\/libraries\",\"show_howtorestoremodal\":0}', '', NULL, NULL, '0', '0', NULL),
('272', '273', 'PLG_QUICKICON_AKEEBABACKUP', 'plugin', 'akeebabackup', '', 'quickicon', '0', '1', '1', '0', '0', '{\"name\":\"PLG_QUICKICON_AKEEBABACKUP\",\"type\":\"plugin\",\"creationDate\":\"2025-09-01\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2006-2025 Akeeba Ltd \\/ Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"https:\\/\\/www.akeeba.com\",\"version\":\"10.0.6\",\"description\":\"PLG_QUICKICON_AKEEBABACKUP_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Akeeba\\\\Plugin\\\\QuickIcon\\\\AkeebaBackup\",\"filename\":\"akeebabackup\"}', '{\"enablewarning\":\"1\",\"warnfailed\":\"1\",\"maxbackupperiod\":\"24\",\"profileid\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('273', '0', 'pkg_akeebabackup', 'package', 'pkg_akeebabackup', '', '', '0', '1', '1', '0', '0', '{\"name\":\"pkg_akeebabackup\",\"type\":\"package\",\"creationDate\":\"2025-09-01\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2006-2025 Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"10.0.6\",\"description\":\"PKG_AKEEBABACKUP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pkg_akeebabackup\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('278', '0', 'Captcha - AstroidCaptcha', 'plugin', 'astroidcaptcha', '', 'captcha', '0', '1', '1', '0', '0', '{\"name\":\"Captcha - AstroidCaptcha\",\"type\":\"plugin\",\"creationDate\":\"September 2025\",\"author\":\"Astroid Framework Team\",\"copyright\":\"Copyright (C) 2025 TemPlaza, Inc. All rights reserved.\",\"authorEmail\":\"info@templaza.com\",\"authorUrl\":\"https:\\/\\/www.templaza.com\",\"version\":\"3.3.2\",\"description\":\"Astroid Framework Plugin Description Here\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Captcha\\\\AstroidCaptcha\",\"filename\":\"astroidcaptcha\"}', '{\"captcha_type\":\"default\",\"g_site_key\":\"\",\"g_secret_key\":\"\",\"g_size\":\"normal\",\"badge\":\"bottomright\",\"tabindex\":\"0\",\"callback\":\"\",\"expired_callback\":\"\",\"error_callback\":\"\",\"t_site_key\":\"\",\"t_secret_key\":\"\",\"t_size\":\"normal\",\"t_callback\":\"\",\"t_expired_callback\":\"\",\"t_error_callback\":\"\"}', '', NULL, NULL, '0', '0', NULL),
('279', '0', 'Astroid Layout Module', 'module', 'mod_astroid_layout', '', '', '0', '1', '0', '0', '0', '{\"name\":\"Astroid Layout Module\",\"type\":\"module\",\"creationDate\":\"September 2025\",\"author\":\"Astroid Framework\",\"copyright\":\"(C) 2025 Astroid Framework\",\"authorEmail\":\"sonlv@templaza.com\",\"authorUrl\":\"astroidframe.work\",\"version\":\"3.3.2\",\"description\":\"MOD_ASTROID_LAYOUT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"mod_astroid_layout\"}', '{\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', NULL, NULL, '0', '0', NULL),
('280', '0', 'MOD_ARTICLES', 'module', 'mod_articles', '', '', '0', '1', '0', '0', '1', '{\"name\":\"MOD_ARTICLES\",\"type\":\"module\",\"creationDate\":\"2024-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2024 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.2.0\",\"description\":\"MOD_ARTICLES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Articles\",\"filename\":\"mod_articles\"}', '', '', NULL, NULL, '0', '0', NULL),
('281', '0', 'plg_extension_joomlaupdate', 'plugin', 'joomlaupdate', '', 'extension', '0', '1', '1', '0', '1', '{\"name\":\"plg_extension_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"2025-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2025 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"1.0.0\",\"description\":\"PLG_EXTENSION_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\Joomlaupdate\",\"filename\":\"joomlaupdate\"}', '', '', NULL, NULL, '0', '0', NULL),
('282', '0', 'Astroid Framework', 'library', 'astroid', 'https://raw.githubusercontent.com/templaza/astroid-framework/refs/heads/updates/changelogs.xml', '', '0', '1', '1', '0', '0', '{\"name\":\"Astroid Framework\",\"type\":\"library\",\"creationDate\":\"September 2025\",\"author\":\"Astroid Framework Team\",\"copyright\":\"Copyright (C) 2025 TemPlaza, Inc. All rights reserved.\",\"authorEmail\":\"info@templaza.com\",\"authorUrl\":\"https:\\/\\/www.templaza.com\",\"version\":\"3.3.4-rc2\",\"description\":\"Congratulations! You have successfully installed Astroid<a href=\\\"index.php?option=com_templates&view=styles&client_id=0\\\" class=\\\"btn btn-success ms-3\\\"><i class=\\\"fa-solid fa-bell fa-shake me-2\\\"><\\/i>Get Started<\\/a>\",\"group\":\"\",\"changelogurl\":\"https:\\/\\/raw.githubusercontent.com\\/templaza\\/astroid-framework\\/refs\\/heads\\/updates\\/changelogs.xml\",\"filename\":\"astroid\"}', '{}', '', NULL, NULL, '0', '0', NULL);/**ABDB**/
