<?php
/*------------------------------------------------------------------------

# Google Map Addon

# ------------------------------------------------------------------------

# Author:    DuongTVTemPlaza

# Copyright: Copyright (C) 2016 tzportfolio.com. All Rights Reserved.

# @License - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL

# Website: http://www.tzportfolio.com

# Family Website: http://www.templaza.com

# Technical Support:  Forum - http://tzportfolio.com/Forum

-------------------------------------------------------------------------*/

// No direct access
defined('_JEXEC') or die;

class PlgTZ_Portfolio_PlusContentGooglemap extends TZ_Portfolio_PlusPlugin
{
    protected $autoloadLanguage     = true;
    protected $data_manager         = false;

    public function onAddContentType(){

        $type           = array();
        $type_layout    = new stdClass();
        $lang           = JFactory::getLanguage();

        // create mapTitle
        $lang_key = 'PLG_' . $this->_type . '_' . $this->_name . '_MAPTITLE_TITLE';
        $lang_key = strtoupper($lang_key);

        if ($lang->hasKey($lang_key)) {
            $type_layout->text = JText::_($lang_key);
        } else {
            $type_layout->text = $this->_name;
        }

        $type_layout->value = $this->_name.':maptitle';

        $type[]             = clone($type_layout);

        // create googleMap
        $lang_key = 'PLG_' . $this->_type . '_' . $this->_name . '_TITLE';
        $lang_key = strtoupper($lang_key);

        if ($lang->hasKey($lang_key)) {
            $type_layout->text = JText::_($lang_key);
        } else {
            $type_layout->text = $this->_name;
        }

        $type_layout->value = $this->_name;

        $type[]             = clone($type_layout);

        return $type;

    }

}
