<?php
/*------------------------------------------------------------------------

# Gallery Addon

# ------------------------------------------------------------------------

# author    Sonny

# copyright Copyright (C) 2021 templaza.com. All Rights Reserved.

# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL

# Websites: http://www.tzportfolio.com

# Technical Support:  Forum - https://www.tzportfolio.com/help/forum.html

-------------------------------------------------------------------------*/

// No direct access.
defined('_JEXEC') or die;
use Joomla\CMS\Factory;
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers');

class PlgTZ_Portfolio_PlusContentGalleryViewArticle extends JViewLegacy{

    protected $item             = null;
    protected $params           = null;
    protected $gallery          = null;
    protected $head             = false;

    public function display($tpl = null){
        $this -> item   = $this -> get('Item');
        $this -> items   = $this -> get('GalleryItems');
        $state          = $this -> get('State');
        $params         = $state -> get('params');
        $this -> params = $params;

        if(isset($this -> items) && $this -> items) {
            $mainframe = Factory::getApplication();
            foreach ($this->items as $_item) {
                $this->gallery  =   $_item -> value;
                $this->styleInit($_item -> value);
                if(!$this -> head && isset($this->gallery->gallery_content)) {
                    $wa = $mainframe->getDocument()->getWebAssetManager();
                    $wa->registerAndUseStyle('fontawesome','components/com_tz_portfolio_plus/css/all.min.css');
                    $wa->registerAndUseStyle('fancy.css','components/com_tz_portfolio_plus/css/jquery.fancybox.min.css');
                    $wa->registerAndUseStyle('tzportfolio.gallery.css', 'components/com_tz_portfolio_plus/addons/content/gallery/css/style.css');
                    $wa->registerAndUseScript('fancy.js', 'components/com_tz_portfolio_plus/js/jquery.fancybox.min.js', ['relative' => true, 'version' => 'auto'], [], ['jquery']);
                    $wa->registerAndUseScript('tzportfolio.gallery.lightbox.js', 'components/com_tz_portfolio_plus/addons/content/gallery/js/lightbox.min.js', ['relative' => true, 'version' => 'auto'], [], ['jquery']);

                    $width          =   $params->get('mt_gallery_width','400');
                    $height         =   $params->get('mt_gallery_height','250');
                    $gallerytype    =   $params->get('mt_gallery_type','masonry');


                    if ($gallerytype == 'grid') {
                        $wa -> addInlineStyle('.tz_portfolio_plus_gallery.grid-container{grid-template-columns: repeat(auto-fill, minmax('.$width.'px, 1fr));}.tz_portfolio_plus_gallery.grid-container .gallery-listing{height:'.$height.'px;}');
                    } elseif ($gallerytype == 'masonry') {
                        $wa->registerAndUseScript('tzportfolio', 'components/com_tz_portfolio_plus/js/tz_portfolio_plus.min.js', ['relative' => true, 'version' => 'auto'], [], ['jquery']);
                        $wa->registerAndUseScript('tzportfolio.isotope', 'components/com_tz_portfolio_plus/js/jquery.isotope.min.js', ['relative' => true, 'version' => 'auto'], [], ['jquery']);
                        $wa->registerAndUseStyle('tzportfolio.isotope','components/com_tz_portfolio_plus/css/isotope.min.css');
                        $wa->registerAndUseStyle('tzportfolio','components/com_tz_portfolio_plus/css/tzportfolioplus.min.css');
                        $wa->addInlineScript('
							jQuery(function($){
							    $(document).ready(function(){
							        $(".tz_portfolio_plus_gallery.masonry-container").tzPortfolioPlusIsotope({
							            "containerElementSelector"  : ".tz_portfolio_plus_gallery.masonry-container",
							            "params"                    : {
							                "tz_column_width"       : "' . $width . '"
							            },
							            
										"isotope_options"                   : {
										            "core"  : {
										                sortBy : "original-order"
										            }
										}
							        });
							    });
							});
							');
                    } elseif ($gallerytype == 'horizontal_masonry') {
                        $style  =   '.tz_portfolio_plus_gallery.horizontal_masonry-container .gallery-listing{height:'.$height.'px;}';
                        for ($i = 0; $i<count($this->gallery->gallery_content->gallery_image); $i++) {
                            $style      .=   '.tz_portfolio_plus_gallery.horizontal_masonry-container .gallery-listing:nth-child('.($i+1).') {width: '.(rand(150,500)).'px;}';
                        }
                        $wa -> addInlineStyle($style);
                    } elseif ($gallerytype == 'carousel') {
                        $wa->registerAndUseStyle('slick.css', 'components/com_tz_portfolio_plus/addons/content/gallery/css/slick.min.css');
                        $wa->registerAndUseScript('slick.js', 'components/com_tz_portfolio_plus/addons/content/gallery/js/slick.min.js', ['relative' => true, 'version' => 'auto'], [], ['jquery']);
                        $mt_gallery_carousel_columns            =   $params->get('mt_gallery_carousel_columns','3');
                        $mt_gallery_carousel_autoplay           =   $params->get('mt_gallery_carousel_autoplay',1);
                        $mt_gallery_carousel_navigation         =   $params->get('mt_gallery_carousel_navigation',1);
                        $mt_gallery_carousel_dot_navigation     =   $params->get('mt_gallery_carousel_dot_navigation',1);
                        $mt_gallery_carousel_center_mode        =   $params->get('mt_gallery_carousel_center_mode',0);
                        $mt_gallery_carousel_center_padding     =   $params->get('mt_gallery_carousel_center_padding','18%');
                        $slide_settings     =   array();
                        $slide_settings[]=  'slidesToShow: ' . $mt_gallery_carousel_columns;
                        if ($mt_gallery_carousel_autoplay) {
                            $slide_settings[]       =   'autoplay: true';
                            $slide_settings[]       =   'autoplaySpeed: '. (3 * 1000);
                        }

                        if ($mt_gallery_carousel_dot_navigation) {
                            $slide_settings[]       =   'dots: true';
                        }

                        if (!$mt_gallery_carousel_navigation) {
                            $slide_settings[]       =   'arrows: false';
                        }
                        if ($mt_gallery_carousel_center_mode) {
                            $slide_settings[] = 'centerMode: true';
                            $slide_settings[] = 'centerPadding: \''.$mt_gallery_carousel_center_padding.'\'';
                        }

                        $wa->addInlineScript('jQuery(document).ready(function(){jQuery(\'.tz_portfolio_plus_gallery.carousel-container\').slick({'.implode(',', $slide_settings).'})});');

                    }

                    $lightboxopt    =   $params->get('gallery_lightbox_option',['zoom', 'slideShow', 'fullScreen', 'thumbs', 'close']);
                    if (is_array($lightboxopt)) {
                        for ($i = 0 ; $i< count($lightboxopt); $i++) {
                            $lightboxopt[$i]  =   '"'.$lightboxopt[$i].'"';
                        }
                    }

                    $lightboxopt=   is_array($lightboxopt) ? implode(',', $lightboxopt) : '';

                    $wa->addInlineScript('var gallery_lightbox_buttons = ['.$lightboxopt.'];');
                    $this -> head   =   true;
                }
            }
        }
        parent::display($tpl);
    }

    protected function styleInit($item) {
        $addon_id = '#tz-portfolio-plus-gallery';
        $title_margin_top = (isset($item->title_margin_top) && $item->title_margin_top) ? $item->title_margin_top : '';
        $title_margin_bottom	= (isset($item->title_margin_bottom) && $item->title_margin_bottom) ? $item->title_margin_bottom : '';
        $title_color	= (isset($item->title_color) && $item->title_color) ? $item->title_color : '';
        //Css start
        $css = '';

        $title_style    =   '';
        if (isset($item->title_font) && $item->title_font) {
            $title_style     .=      TZ_Portfolio_PlusContentHelper::font_style($item->title_font);
        }
        if ($title_margin_top) {
            $title_style    .=  'margin-top:'.$title_margin_top.'px;';
        }
        if ($title_margin_bottom) {
            $title_style    .=  'margin-bottom:'.$title_margin_bottom.'px;';
        }
        if ($title_color) {
            $title_style    .=  'color:'.$title_color.';';
        }

        if($title_style) {
            $css .= $addon_id . ' .tz-gallery-title {';
            $css .= $title_style;
            $css .= '}';
        }

        if(isset($item->title_color_hover) && $item->title_color_hover) {
            $css .= $addon_id . ' .tz-gallery-title{';
            $css .= 'transition:.3s;';
            $css .='}';
            $css .= $addon_id . ':hover .tz-gallery-title {';
            $css .= 'color:'.$item->title_color_hover.';';
            $css .='}';
        };
        $doc = JFactory::getDocument();
        $doc->addStyleDeclaration($css);
    }

}