<?php
/*------------------------------------------------------------------------

# Accordion Addon

# ------------------------------------------------------------------------

# author    Sonny

# copyright Copyright (C) 2021 templaza.com. All Rights Reserved.

# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL

# Websites: http://www.tzportfolio.com

# Technical Support:  Forum - https://www.tzportfolio.com/help/forum.html

-------------------------------------------------------------------------*/

// No direct access.
defined('_JEXEC') or die;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
$params = $this->params;
if ($params->get('accordion_show',1)) {
    if (isset($this->accordion) && $accordion = $this->accordion) {
        if (isset($accordion->accordion_items) && is_object($accordion->accordion_items))  {
            //Title
            $title = (isset($accordion->title) && $accordion->title) ? $accordion->title : '';
            $heading_selector = (isset($accordion->title_element) && $accordion->title_element) ? $accordion->title_element : 'h3';

            //Custom Class
            $custom_class = (isset($accordion->custom_class) && trim($accordion->custom_class)) ? $accordion->custom_class : '';

            echo '<div id="tz-portfolio-plus-accordion" class="'.$custom_class.'">';
            if($title) {
                echo '<'.$heading_selector.' class="tz-accordion-title uk-margin-bottom">';
                echo $title;
                echo '</'.$heading_selector.'>';
            }

            $gutter =   isset($accordion->gutter) && $accordion->gutter ? ' '. $accordion->gutter : '';
            echo '<div class="accordion" id="tz-portfolio-accordion">';
            foreach ($accordion->accordion_items as $key => $accordion_item) :
                echo '<div class="accordion-item" id="tzportfolio_'.$key.'">';
                if ($accordion_item->title) {
                    echo '<h3 class="tz-accordion-item-title accordion-header">';
                    echo '<button class="accordion-button'.($key == 'accordion_items0' ? '' : ' collapsed').'" type="button" data-bs-toggle="collapse" data-bs-target="#tz-accordion-item-content'.$key.'" aria-expanded="'.($key == 'accordion_items0' ? 'true' : 'false').'" aria-controls="tz-accordion-item-content'.$key.'">' . $accordion_item->title . '</button>';
                    echo '</h3>';
                }
                if ($accordion_item->content) {
                    echo '<div id="tz-accordion-item-content'.$key.'" class="accordion-collapse collapse'.($key == 'accordion_items0' ? ' show' : '').'" data-bs-parent="#tz-portfolio-accordion"><div class="accordion-body">';
                    echo $accordion_item->content;
                    echo '</div></div>';
                }
                echo '</div>';
            endforeach;
            echo '</div>';

            echo '</div>';
        }
    }
}