<?php

/**
 * @package   Astroid Framework
 * @author    Astroid Framework Team https://astroidframe.work
 * @copyright Copyright (C) 2023 AstroidFrame.work.
 * @license https://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
 * 	DO NOT MODIFY THIS FILE DIRECTLY AS IT WILL BE OVERWRITTEN IN THE NEXT UPDATE
 *  You can easily override all files under /frontend/ folder.
 *	Just copy the file to ROOT/templates/YOURTEMPLATE/html/frontend/blog/ folder to create and override
 */
// No direct access.
defined('_JEXEC') or die;
extract($displayData);

$params = $article->attribs;
if (is_string($params)) {
   $params = $article->params;
}

$type = $params->get('astroid_article_type', 'regular');
$icon = '';
switch ($type) {
   case 'video':
      $type = $params->get('astroid_article_video_type', 'youtube');
       $icon = match ($type) {
           'local' => 'fa-solid fa-video',
           default => 'fab fa-' . $type,
       };
      break;
   case 'gallery':
      $icon = 'far fa-images';
      break;
   case 'audio':
      $type = $params->get('astroid_article_audio_source', 'soundcloud');
      $icon = 'fab fa-' . $type;
      break;
   case 'review':
      $icon = 'far fa-star';
      break;
   case 'quote':
      $icon = 'fas fa-quote-left';
      break;
}
?>
<?php if (!empty($icon)) { ?>
   <div class="article-post-type">
      <span class="article-icon article-icon-<?php echo $type; ?>"><?php echo !empty($icon) ? '<i class="' . $icon . '"></i>' : ''; ?></span>
   </div>
<?php } ?>